/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.group;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.openscience.cdk.group.Partition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEquitablePartitionRefiner {
    private SplitOrder splitOrder = SplitOrder.FORWARD;
    private int currentBlockIndex;
    private Queue<Set<Integer>> blocksToRefine;

    public abstract int getVertexCount();

    public abstract int neighboursInBlock(Set<Integer> var1, int var2);

    public void setSplitOrder(SplitOrder splitOrder) {
        this.splitOrder = splitOrder;
    }

    public Partition refine(Partition coarser) {
        Partition finer = new Partition(coarser);
        this.blocksToRefine = new LinkedList<Set<Integer>>();
        for (int i = 0; i < finer.size(); ++i) {
            this.blocksToRefine.add(finer.copyBlock(i));
        }
        int numberOfVertices = this.getVertexCount();
        while (!this.blocksToRefine.isEmpty()) {
            Set<Integer> t = this.blocksToRefine.remove();
            this.currentBlockIndex = 0;
            while (this.currentBlockIndex < finer.size() && finer.size() < numberOfVertices) {
                if (!finer.isDiscreteCell(this.currentBlockIndex)) {
                    Map<Integer, SortedSet<Integer>> invariants = this.getInvariants(finer, t);
                    this.split(invariants, finer);
                }
                ++this.currentBlockIndex;
            }
            if (finer.size() != numberOfVertices) continue;
            return finer;
        }
        return finer;
    }

    private Map<Integer, SortedSet<Integer>> getInvariants(Partition partition, Set<Integer> targetBlock) {
        HashMap<Integer, SortedSet<Integer>> setList = new HashMap<Integer, SortedSet<Integer>>();
        Iterator i$ = partition.getCell(this.currentBlockIndex).iterator();
        while (i$.hasNext()) {
            int u = (Integer)i$.next();
            int h = this.neighboursInBlock(targetBlock, u);
            if (setList.containsKey(h)) {
                ((SortedSet)setList.get(h)).add(u);
                continue;
            }
            TreeSet<Integer> set = new TreeSet<Integer>();
            set.add(u);
            setList.put(h, set);
        }
        return setList;
    }

    private void split(Map<Integer, SortedSet<Integer>> invariants, Partition partition) {
        int nonEmptyInvariants = invariants.keySet().size();
        if (nonEmptyInvariants > 1) {
            ArrayList<Integer> invariantKeys = new ArrayList<Integer>();
            invariantKeys.addAll(invariants.keySet());
            partition.removeCell(this.currentBlockIndex);
            int k = this.currentBlockIndex;
            if (this.splitOrder == SplitOrder.REVERSE) {
                Collections.sort(invariantKeys);
            } else {
                Collections.sort(invariantKeys, Collections.reverseOrder());
            }
            Iterator i$ = invariantKeys.iterator();
            while (i$.hasNext()) {
                int h = (Integer)i$.next();
                SortedSet<Integer> setH = invariants.get(h);
                partition.insertCell(k, setH);
                this.blocksToRefine.add(setH);
                ++k;
            }
            this.currentBlockIndex += nonEmptyInvariants - 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SplitOrder {
        FORWARD,
        REVERSE;

    }
}

