/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import javax.vecmath.Point3d;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.geometry.GeometryTools;
import org.openscience.cdk.graph.PathTools;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.qsar.AbstractMolecularDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleArrayResult;
import org.openscience.cdk.qsar.result.DoubleArrayResultType;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

@TestClass(value="org.openscience.cdk.qsar.descriptors.molecular.PetitjeanShapeIndexDescriptorTest")
public class PetitjeanShapeIndexDescriptor
extends AbstractMolecularDescriptor
implements IMolecularDescriptor {
    private static final String[] names = new String[]{"topoShape", "geomShape"};

    @TestMethod(value="testGetSpecification")
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#petitjeanShapeIndex", this.getClass().getName(), "$Id: bec47f9880b4e0fdccf12f46b957958c19236be1 $", "The Chemistry Development Kit");
    }

    @TestMethod(value="testSetParameters_arrayObject")
    public void setParameters(Object[] params) throws CDKException {
    }

    @TestMethod(value="testGetParameters")
    public Object[] getParameters() {
        return null;
    }

    @TestMethod(value="testNamesConsistency")
    public String[] getDescriptorNames() {
        return names;
    }

    @TestMethod(value="testGetParameterNames")
    public String[] getParameterNames() {
        return null;
    }

    @TestMethod(value="testGetParameterType_String")
    public Object getParameterType(String name) {
        return null;
    }

    @TestMethod(value="testCalculate_IAtomContainer")
    public DescriptorValue calculate(IAtomContainer container) {
        IAtomContainer local = AtomContainerManipulator.removeHydrogens(container);
        int tradius = PathTools.getMolecularGraphRadius(local);
        int tdiameter = PathTools.getMolecularGraphDiameter(local);
        DoubleArrayResult retval = new DoubleArrayResult();
        retval.add((double)(tdiameter - tradius) / (double)tradius);
        if (GeometryTools.has3DCoordinates(container)) {
            int i;
            int natom = container.getAtomCount();
            double[][] distanceMatrix = new double[natom][natom];
            for (int i2 = 0; i2 < natom; ++i2) {
                for (int j = 0; j < natom; ++j) {
                    if (i2 == j) {
                        distanceMatrix[i2][j] = 0.0;
                        continue;
                    }
                    Point3d a = container.getAtom(i2).getPoint3d();
                    Point3d b = container.getAtom(j).getPoint3d();
                    distanceMatrix[i2][j] = Math.sqrt((a.x - b.x) * (a.x - b.x) + (a.y - b.y) * (a.y - b.y) + (a.z - b.z) * (a.z - b.z));
                }
            }
            double gradius = 999999.0;
            double gdiameter = -999999.0;
            double[] geta = new double[natom];
            for (i = 0; i < natom; ++i) {
                double max = -99999.0;
                for (int j = 0; j < natom; ++j) {
                    if (!(distanceMatrix[i][j] > max)) continue;
                    max = distanceMatrix[i][j];
                }
                geta[i] = max;
            }
            for (i = 0; i < natom; ++i) {
                if (geta[i] < gradius) {
                    gradius = geta[i];
                }
                if (!(geta[i] > gdiameter)) continue;
                gdiameter = geta[i];
            }
            retval.add((gdiameter - gradius) / gradius);
        } else {
            retval.add(Double.NaN);
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), retval, this.getDescriptorNames());
    }

    @TestMethod(value="testGetDescriptorResultType")
    public IDescriptorResult getDescriptorResultType() {
        return new DoubleArrayResultType(2);
    }
}

