/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.reaction.type;

import java.util.Iterator;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.interfaces.IReactionSet;
import org.openscience.cdk.interfaces.IRing;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.reaction.IReactionProcess;
import org.openscience.cdk.reaction.ReactionEngine;
import org.openscience.cdk.reaction.ReactionSpecification;
import org.openscience.cdk.reaction.type.parameters.IParameterReact;
import org.openscience.cdk.reaction.type.parameters.SetReactionCenter;
import org.openscience.cdk.ringsearch.AllRingsFinder;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.manipulator.BondManipulator;

@TestClass(value="org.openscience.cdk.reaction.type.PiBondingMovementReactionTest")
public class PiBondingMovementReaction
extends ReactionEngine
implements IReactionProcess {
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(PiBondingMovementReaction.class);

    @TestMethod(value="testGetSpecification")
    public ReactionSpecification getSpecification() {
        return new ReactionSpecification("http://almost.cubic.uni-koeln.de/jrg/Members/mrc/reactionDict/reactionDict#PiBondingMovement", this.getClass().getName(), "$Id$", "The Chemistry Development Kit");
    }

    @TestMethod(value="testInitiate_IAtomContainerSet_IAtomContainerSet")
    public IReactionSet initiate(IAtomContainerSet reactants, IAtomContainerSet agents) throws CDKException {
        logger.debug("initiate reaction: PiBondingMovementReaction");
        if (reactants.getAtomContainerCount() != 1) {
            throw new CDKException("PiBondingMovementReaction only expects one reactant");
        }
        if (agents != null) {
            throw new CDKException("PiBondingMovementReaction don't expects agents");
        }
        IReactionSet setOfReactions = reactants.getBuilder().newInstance(IReactionSet.class, new Object[0]);
        IAtomContainer reactant = reactants.getAtomContainer(0);
        AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(reactant);
        IParameterReact ipr = super.getParameterClass(SetReactionCenter.class);
        if (ipr != null && !ipr.isSetParameter()) {
            this.setActiveCenters(reactant);
        }
        AllRingsFinder arf = new AllRingsFinder();
        IRingSet ringSet = arf.findAllRings(reactant);
        for (int ir = 0; ir < ringSet.getAtomContainerCount(); ++ir) {
            IAtomContainer reactantCloned;
            IRing ring = (IRing)ringSet.getAtomContainer(ir);
            int nrAtoms = ring.getAtomCount();
            if (nrAtoms % 2 != 0) continue;
            int nrSingleBonds = 0;
            Iterator<IBond> bondrs = ring.bonds().iterator();
            while (bondrs.hasNext()) {
                if (bondrs.next().getOrder() != IBond.Order.SINGLE) continue;
                ++nrSingleBonds;
            }
            if (nrSingleBonds == 0 || nrAtoms / 2 != nrSingleBonds) continue;
            Iterator<IBond> bondfs = ring.bonds().iterator();
            boolean ringCompletActive = false;
            while (bondfs.hasNext()) {
                if (bondfs.next().getFlag(1024)) {
                    ringCompletActive = true;
                    continue;
                }
                ringCompletActive = false;
                break;
            }
            if (!ringCompletActive) continue;
            IReaction reaction = reactants.getBuilder().newInstance(IReaction.class, new Object[0]);
            reaction.addReactant(reactant);
            try {
                reactantCloned = reactant.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new CDKException("Could not clone IAtomContainer!", e);
            }
            for (IBond bondi : ring.bonds()) {
                int bondiP = reactant.getBondNumber(bondi);
                if (bondi.getOrder() == IBond.Order.SINGLE) {
                    BondManipulator.increaseBondOrder(reactantCloned.getBond(bondiP));
                    continue;
                }
                BondManipulator.decreaseBondOrder(reactantCloned.getBond(bondiP));
            }
            reaction.addProduct(reactantCloned);
            setOfReactions.addReaction(reaction);
        }
        return setOfReactions;
    }

    private void setActiveCenters(IAtomContainer reactant) throws CDKException {
        AllRingsFinder arf = new AllRingsFinder();
        IRingSet ringSet = arf.findAllRings(reactant);
        for (int ir = 0; ir < ringSet.getAtomContainerCount(); ++ir) {
            IRing ring = (IRing)ringSet.getAtomContainer(ir);
            int nrAtoms = ring.getAtomCount();
            if (nrAtoms % 2 != 0) continue;
            int nrSingleBonds = 0;
            Iterator<IBond> bondrs = ring.bonds().iterator();
            while (bondrs.hasNext()) {
                if (bondrs.next().getOrder() != IBond.Order.SINGLE) continue;
                ++nrSingleBonds;
            }
            if (nrSingleBonds == 0 || nrAtoms / 2 != nrSingleBonds) continue;
            Iterator<IBond> bondfs = ring.bonds().iterator();
            while (bondfs.hasNext()) {
                bondfs.next().setFlag(1024, true);
            }
        }
    }
}

