/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smsd.algorithm.single;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.isomorphism.matchers.IQueryAtom;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.cdk.smsd.tools.BondEnergies;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TestClass(value="org.openscience.cdk.smsd.algorithm.single.SingleMappingTest")
public class SingleMapping {
    private IAtomContainer source = null;
    private IAtomContainer target = null;
    private List<Map<IAtom, IAtom>> mappings = null;
    private Map<Integer, Double> connectedBondOrder = null;

    @TestMethod(value="testGetOverLaps")
    protected List<Map<IAtom, IAtom>> getOverLaps(IAtomContainer source, IAtomContainer target, boolean removeHydrogen) throws CDKException {
        this.mappings = new ArrayList<Map<IAtom, IAtom>>();
        this.connectedBondOrder = new TreeMap<Integer, Double>();
        this.source = source;
        this.target = target;
        if (source.getAtomCount() == 1 || source.getAtomCount() > 0 && source.getBondCount() == 0) {
            this.setSourceSingleAtomMap(removeHydrogen);
        }
        if (target.getAtomCount() == 1 || target.getAtomCount() > 0 && target.getBondCount() == 0) {
            this.setTargetSingleAtomMap(removeHydrogen);
        }
        this.postFilter();
        return this.mappings;
    }

    @TestMethod(value="testGetOverLaps")
    protected List<Map<IAtom, IAtom>> getOverLaps(IQueryAtomContainer source, IAtomContainer target, boolean removeHydrogen) throws CDKException {
        this.mappings = new ArrayList<Map<IAtom, IAtom>>();
        this.connectedBondOrder = new TreeMap<Integer, Double>();
        this.source = source;
        this.target = target;
        if (source.getAtomCount() == 1 || source.getAtomCount() > 0 && source.getBondCount() == 0) {
            this.setSourceSingleAtomMap(source, removeHydrogen);
        }
        if (target.getAtomCount() == 1 || target.getAtomCount() > 0 && target.getBondCount() == 0) {
            this.setTargetSingleAtomMap(removeHydrogen);
        }
        this.postFilter();
        return this.mappings;
    }

    private void setSourceSingleAtomMap(IQueryAtomContainer source, boolean removeHydrogen) throws CDKException {
        int counter = 0;
        BondEnergies be = BondEnergies.getInstance();
        for (IAtom sourceAtom : source.atoms()) {
            IQueryAtom smartAtom = (IQueryAtom)sourceAtom;
            if (removeHydrogen && !smartAtom.getSymbol().equals("H") || !removeHydrogen) {
                for (IAtom targetAtom : this.target.atoms()) {
                    HashMap<IAtom, IAtom> mapAtoms = new HashMap<IAtom, IAtom>();
                    if (!smartAtom.matches(targetAtom)) continue;
                    mapAtoms.put(sourceAtom, targetAtom);
                    List<IBond> Bonds = this.target.getConnectedBondsList(targetAtom);
                    double totalOrder = 0.0;
                    for (IBond bond : Bonds) {
                        IBond.Order order = bond.getOrder();
                        totalOrder += (double)(order.numeric() + be.getEnergies(bond));
                    }
                    if (targetAtom.getFormalCharge() != sourceAtom.getFormalCharge()) {
                        totalOrder += 0.5;
                    }
                    this.connectedBondOrder.put(counter, totalOrder);
                    this.mappings.add(counter++, mapAtoms);
                }
                continue;
            }
            System.err.println("Skippping Hydrogen mapping or This is not a single mapping case!");
        }
    }

    private void setSourceSingleAtomMap(boolean removeHydrogen) throws CDKException {
        int counter = 0;
        BondEnergies be = BondEnergies.getInstance();
        for (IAtom sourceAtom : this.source.atoms()) {
            if (removeHydrogen && !sourceAtom.getSymbol().equals("H") || !removeHydrogen) {
                for (IAtom targetAtom : this.target.atoms()) {
                    HashMap<IAtom, IAtom> mapAtoms = new HashMap<IAtom, IAtom>();
                    if (!sourceAtom.getSymbol().equalsIgnoreCase(targetAtom.getSymbol())) continue;
                    mapAtoms.put(sourceAtom, targetAtom);
                    List<IBond> Bonds = this.target.getConnectedBondsList(targetAtom);
                    double totalOrder = 0.0;
                    for (IBond bond : Bonds) {
                        IBond.Order order = bond.getOrder();
                        totalOrder += (double)(order.numeric() + be.getEnergies(bond));
                    }
                    if (targetAtom.getFormalCharge() != sourceAtom.getFormalCharge()) {
                        totalOrder += 0.5;
                    }
                    this.connectedBondOrder.put(counter, totalOrder);
                    this.mappings.add(counter++, mapAtoms);
                }
                continue;
            }
            System.err.println("Skippping Hydrogen mapping or This is not a single mapping case!");
        }
    }

    private void setTargetSingleAtomMap(boolean removeHydrogen) throws CDKException {
        int counter = 0;
        BondEnergies be = BondEnergies.getInstance();
        for (IAtom targetAtom : this.target.atoms()) {
            if (removeHydrogen && !targetAtom.getSymbol().equals("H") || !removeHydrogen) {
                for (IAtom sourceAtoms : this.source.atoms()) {
                    HashMap<IAtom, IAtom> mapAtoms = new HashMap<IAtom, IAtom>();
                    if (!targetAtom.getSymbol().equalsIgnoreCase(sourceAtoms.getSymbol())) continue;
                    mapAtoms.put(sourceAtoms, targetAtom);
                    List<IBond> Bonds = this.source.getConnectedBondsList(sourceAtoms);
                    double totalOrder = 0.0;
                    for (IBond bond : Bonds) {
                        IBond.Order order = bond.getOrder();
                        totalOrder += (double)(order.numeric() + be.getEnergies(bond));
                    }
                    if (sourceAtoms.getFormalCharge() != targetAtom.getFormalCharge()) {
                        totalOrder += 0.5;
                    }
                    this.connectedBondOrder.put(counter, totalOrder);
                    this.mappings.add(counter++, mapAtoms);
                }
                continue;
            }
            System.err.println("Skippping Hydrogen mapping or This is not a single mapping case!");
        }
    }

    private void postFilter() {
        ArrayList<Map<IAtom, IAtom>> sortedMap = new ArrayList<Map<IAtom, IAtom>>();
        this.connectedBondOrder = this.sortByValue(this.connectedBondOrder);
        for (Integer key : this.connectedBondOrder.keySet()) {
            Map<IAtom, IAtom> mapToBeMoved = this.mappings.get(key);
            sortedMap.add(mapToBeMoved);
        }
        this.mappings = sortedMap;
    }

    private <K, V extends Comparable<V>> Map<K, V> sortByValue(Map<K, V> map) {
        LinkedList<Map.Entry<K, V>> list = new LinkedList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> object1, Map.Entry<K, V> object2) {
                return ((Comparable)object1.getValue()).compareTo(object2.getValue());
            }
        });
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : list) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }
}

