/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.features;

import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;

public class MoleculeFeaturesTool {
    public static boolean hasPartialCharges(IAtomContainer molecule) {
        for (IAtom atom : molecule.atoms()) {
            if (atom.getCharge() == 0.0) continue;
            return true;
        }
        return false;
    }

    public static boolean hasFormalCharges(IAtomContainer molecule) {
        for (IAtom atom : molecule.atoms()) {
            if (atom.getFormalCharge() == 0) continue;
            return true;
        }
        return false;
    }

    public static boolean hasElementSymbols(IAtomContainer molecule) {
        for (IAtom atom : molecule.atoms()) {
            if (atom.getSymbol() == null || atom.getSymbol().length() <= 0) continue;
            return true;
        }
        return false;
    }

    public static boolean hasGraphRepresentation(IAtomContainer molecule) {
        for (IBond bond : molecule.bonds()) {
            if (bond.getAtomCount() == 2) continue;
            return false;
        }
        return true;
    }
}

