/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.graph;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.graph.PathGraph;

@TestClass(value="org.openscience.cdk.graph.JumboPathGraphTest")
final class JumboPathGraph
extends PathGraph {
    private final List<PathEdge>[] graph;
    private final int limit;
    private final int[] rank;
    private static final BitSet EMPTY_SET = new BitSet(0);

    @TestMethod(value="nullMGraph,limitTooLow,limitTooHigh")
    JumboPathGraph(int[][] mGraph, int[] rank, int limit) {
        int v;
        Preconditions.checkNotNull(mGraph, "no molecule graph");
        Preconditions.checkNotNull(rank, "no rank provided");
        this.graph = new List[mGraph.length];
        this.rank = rank;
        this.limit = limit + 1;
        int ord = this.graph.length;
        Preconditions.checkArgument(ord > 2, "graph was acyclic");
        Preconditions.checkArgument(limit >= 3 && limit <= ord, "limit should be from 3 to |V|");
        for (v = 0; v < ord; ++v) {
            this.graph[v] = Lists.newArrayList();
        }
        for (v = 0; v < ord; ++v) {
            for (int w : mGraph[v]) {
                if (w <= v) continue;
                this.add(new SimpleEdge(v, w));
            }
        }
    }

    private void add(PathEdge edge) {
        int v;
        int u = edge.either();
        if (this.rank[u] < this.rank[v = edge.other(u)]) {
            this.graph[u].add(edge);
        } else {
            this.graph[v].add(edge);
        }
    }

    @Override
    @TestMethod(value="k3Degree")
    public int degree(int x) {
        return this.graph[x].size();
    }

    private List<PathEdge> remove(int x) {
        List<PathEdge> edges = this.graph[x];
        this.graph[x] = Collections.emptyList();
        return edges;
    }

    private List<PathEdge> combine(List<PathEdge> edges, int x) {
        int n = edges.size();
        ArrayList<PathEdge> reduced = new ArrayList<PathEdge>(n);
        for (int i = 0; i < n; ++i) {
            PathEdge e = edges.get(i);
            for (int j = i + 1; j < n; ++j) {
                PathEdge f = edges.get(j);
                if (!e.disjoint(f)) continue;
                reduced.add(new ReducedEdge(e, f, x));
            }
        }
        return reduced;
    }

    @Override
    @TestMethod(value="k3,k8,repeatRemoval")
    void remove(int x, List<int[]> cycles) {
        List<PathEdge> edges = this.remove(x);
        List<PathEdge> reduced = this.combine(edges, x);
        for (PathEdge e : reduced) {
            if (e.len() > this.limit) continue;
            if (e.loop()) {
                cycles.add(e.path());
                continue;
            }
            this.add(e);
        }
    }

    static final class ArrayBuilder {
        private int i = 0;
        final int[] xs;

        ArrayBuilder(int n) {
            this.xs = new int[n];
        }

        ArrayBuilder append(int x) {
            this.xs[this.i++] = x;
            return this;
        }

        int prev() {
            return this.xs[this.i - 1];
        }
    }

    static final class ReducedEdge
    extends PathEdge {
        private final PathEdge e;
        private final PathEdge f;

        ReducedEdge(PathEdge e, PathEdge f, int x) {
            super(e.other(x), f.other(x), ReducedEdge.union(e.xs, f.xs, x));
            this.e = e;
            this.f = f;
        }

        @Override
        ArrayBuilder reconstruct(ArrayBuilder ab) {
            return this.u == ab.prev() ? this.f.reconstruct(this.e.reconstruct(ab)) : this.e.reconstruct(this.f.reconstruct(ab));
        }

        @Override
        int len() {
            return this.xs.cardinality() + 2;
        }

        static BitSet union(BitSet s, BitSet t, int x) {
            BitSet u = (BitSet)s.clone();
            u.or(t);
            u.set(x);
            return u;
        }
    }

    static final class SimpleEdge
    extends PathEdge {
        SimpleEdge(int u, int v) {
            super(u, v, EMPTY_SET);
        }

        @Override
        ArrayBuilder reconstruct(ArrayBuilder ab) {
            return ab.append(this.other(ab.prev()));
        }

        @Override
        int len() {
            return 2;
        }
    }

    static abstract class PathEdge {
        final int u;
        final int v;
        final BitSet xs;

        PathEdge(int u, int v, BitSet xs) {
            this.u = u;
            this.v = v;
            this.xs = xs;
        }

        final boolean disjoint(PathEdge other) {
            return !this.xs.intersects(other.xs);
        }

        final boolean loop() {
            return this.u == this.v;
        }

        final int either() {
            return this.u;
        }

        final int other(int x) {
            return this.u == x ? this.v : this.u;
        }

        abstract int len();

        abstract ArrayBuilder reconstruct(ArrayBuilder var1);

        final int[] path() {
            return this.reconstruct((ArrayBuilder)new ArrayBuilder((int)this.len()).append((int)this.either())).xs;
        }
    }
}

