/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.iupac.parser;

import java.util.List;
import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.aromaticity.Aromaticity;
import org.openscience.cdk.atomtype.CDKAtomTypeMatcher;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IRing;
import org.openscience.cdk.iupac.parser.AttachedGroup;
import org.openscience.cdk.iupac.parser.ParseException;
import org.openscience.cdk.iupac.parser.Token;
import org.openscience.cdk.templates.MoleculeFactory;
import org.openscience.cdk.tools.CDKHydrogenAdder;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.manipulator.AtomTypeManipulator;

public class MoleculeBuilder {
    private IAtomContainer currentMolecule = null;
    private IAtom endOfChain;

    public MoleculeBuilder(IChemObjectBuilder builder) {
        this.currentMolecule = builder.newInstance(IAtomContainer.class, new Object[0]);
    }

    public MoleculeBuilder() {
        this(DefaultChemObjectBuilder.getInstance());
    }

    private IAtomContainer buildChain(int length, boolean isMainCyclic) {
        IAtomContainer currentChain;
        if (length > 0) {
            if (isMainCyclic) {
                currentChain = this.currentMolecule.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
                currentChain.add(this.currentMolecule.getBuilder().newInstance(IRing.class, length, "C"));
            } else {
                currentChain = MoleculeFactory.makeAlkane(length);
            }
        } else {
            currentChain = this.currentMolecule.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        }
        return currentChain;
    }

    private void buildFunGroups(List<AttachedGroup> attachedGroups) {
        for (AttachedGroup attachedGroup : attachedGroups) {
            for (Token locationToken : attachedGroup.getLocations()) {
                this.addFunGroup(attachedGroup.getName(), Integer.parseInt(locationToken.image) - 1);
            }
        }
    }

    private void addFunGroup(String funGroupToken, int addPos) {
        if (funGroupToken != "an") {
            if (funGroupToken == "en") {
                if (addPos < 0) {
                    this.currentMolecule.getBond(0).setOrder(IBond.Order.DOUBLE);
                } else {
                    this.currentMolecule.getBond(addPos).setOrder(IBond.Order.DOUBLE);
                }
            } else if (funGroupToken == "yn") {
                if (addPos < 0) {
                    this.currentMolecule.getBond(0).setOrder(IBond.Order.TRIPLE);
                } else {
                    this.currentMolecule.getBond(addPos).setOrder(IBond.Order.TRIPLE);
                }
            } else if (funGroupToken != "e") {
                if (funGroupToken == "ol" || funGroupToken == "hydroxy") {
                    if (addPos < 0) {
                        this.addAtom("O", this.endOfChain, IBond.Order.SINGLE, 1);
                    } else {
                        this.addAtom("O", this.currentMolecule.getAtom(addPos), IBond.Order.SINGLE, 1);
                    }
                } else if (funGroupToken == "al") {
                    this.addAtom("O", this.endOfChain, IBond.Order.DOUBLE, 0);
                } else if (funGroupToken == "oic acid") {
                    this.addAtom("O", this.endOfChain, IBond.Order.DOUBLE, 0);
                    this.addAtom("O", this.endOfChain, IBond.Order.SINGLE, 1);
                } else if (funGroupToken == "oyl chloride") {
                    this.addAtom("O", this.endOfChain, IBond.Order.DOUBLE, 0);
                    this.addAtom("Cl", this.endOfChain, IBond.Order.SINGLE, 0);
                } else if (funGroupToken == "chloro") {
                    if (addPos < 0) {
                        this.addAtom("Cl", this.currentMolecule.getFirstAtom(), IBond.Order.SINGLE, 0);
                    } else {
                        this.addAtom("Cl", this.currentMolecule.getAtom(addPos), IBond.Order.SINGLE, 0);
                    }
                } else if (funGroupToken == "fluoro") {
                    if (addPos < 0) {
                        this.addAtom("F", this.currentMolecule.getFirstAtom(), IBond.Order.SINGLE, 0);
                    } else {
                        this.addAtom("F", this.currentMolecule.getAtom(addPos), IBond.Order.SINGLE, 0);
                    }
                } else if (funGroupToken == "bromo") {
                    if (addPos < 0) {
                        this.addAtom("Br", this.currentMolecule.getFirstAtom(), IBond.Order.SINGLE, 0);
                    } else {
                        this.addAtom("Br", this.currentMolecule.getAtom(addPos), IBond.Order.SINGLE, 0);
                    }
                } else if (funGroupToken == "iodo") {
                    if (addPos < 0) {
                        this.addAtom("I", this.currentMolecule.getFirstAtom(), IBond.Order.SINGLE, 0);
                    } else {
                        this.addAtom("I", this.currentMolecule.getAtom(addPos), IBond.Order.SINGLE, 0);
                    }
                } else if (funGroupToken == "nitro") {
                    if (addPos < 0) {
                        this.addAtom("N", this.currentMolecule.getFirstAtom(), IBond.Order.SINGLE, 0);
                    } else {
                        this.addAtom("N", this.currentMolecule.getAtom(addPos), IBond.Order.SINGLE, 0);
                    }
                    IAtom nitrogenAtom = this.currentMolecule.getLastAtom();
                    nitrogenAtom.setFormalCharge(1);
                    this.addAtom("O", nitrogenAtom, IBond.Order.SINGLE, 0);
                    this.currentMolecule.getLastAtom().setFormalCharge(-1);
                    this.addAtom("O", nitrogenAtom, IBond.Order.DOUBLE, 0);
                } else if (funGroupToken == "oxo") {
                    if (addPos < 0) {
                        this.addAtom("O", this.currentMolecule.getFirstAtom(), IBond.Order.DOUBLE, 0);
                    } else {
                        this.addAtom("O", this.currentMolecule.getAtom(addPos), IBond.Order.DOUBLE, 0);
                    }
                } else if (funGroupToken == "nitrile") {
                    this.addAtom("N", this.currentMolecule.getFirstAtom(), IBond.Order.TRIPLE, 0);
                } else if (funGroupToken == "phenyl") {
                    IAtomContainer benzene = MoleculeFactory.makeBenzene();
                    try {
                        AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(benzene);
                        Aromaticity.cdkLegacy().apply(benzene);
                    }
                    catch (Exception exc) {
                        // empty catch block
                    }
                    this.currentMolecule.add(benzene);
                    IBond joiningBond = addPos < 0 ? this.currentMolecule.getBuilder().newInstance(IBond.class, this.currentMolecule.getFirstAtom(), benzene.getFirstAtom()) : this.currentMolecule.getBuilder().newInstance(IBond.class, this.currentMolecule.getAtom(addPos), benzene.getFirstAtom());
                    this.currentMolecule.addBond(joiningBond);
                } else if (funGroupToken == "amino") {
                    if (addPos < 0) {
                        this.addAtom("N", this.currentMolecule.getFirstAtom(), IBond.Order.SINGLE, 2);
                    } else {
                        this.addAtom("N", this.currentMolecule.getAtom(addPos), IBond.Order.SINGLE, 2);
                    }
                } else if (funGroupToken == "alumino") {
                    if (addPos < 0) {
                        this.addAtom("Al", this.currentMolecule.getFirstAtom(), IBond.Order.SINGLE, 2);
                    } else {
                        this.addAtom("Al", this.currentMolecule.getAtom(addPos), IBond.Order.SINGLE, 2);
                    }
                } else if (funGroupToken == "litho") {
                    if (addPos < 0) {
                        this.addAtom("Li", this.currentMolecule.getFirstAtom(), IBond.Order.SINGLE, 2);
                    } else {
                        this.addAtom("Li", this.currentMolecule.getAtom(addPos), IBond.Order.SINGLE, 2);
                    }
                } else if (funGroupToken == "oate") {
                    this.addAtom("O", this.endOfChain, IBond.Order.DOUBLE, 0);
                    this.addAtom("O", this.endOfChain, IBond.Order.SINGLE, 0);
                    this.endOfChain = this.currentMolecule.getLastAtom();
                } else if (funGroupToken == "amine") {
                    this.addAtom("N", this.endOfChain, IBond.Order.SINGLE, 1);
                    this.endOfChain = this.currentMolecule.getLastAtom();
                } else if (funGroupToken == "amide") {
                    this.addAtom("O", this.endOfChain, IBond.Order.DOUBLE, 0);
                    this.addAtom("N", this.endOfChain, IBond.Order.SINGLE, 1);
                    this.endOfChain = this.currentMolecule.getLastAtom();
                } else if (funGroupToken == "one") {
                    this.addAtom("O", this.endOfChain, IBond.Order.DOUBLE, 2);
                } else if (this.getMetalAtomicSymbol(funGroupToken) != null) {
                    this.currentMolecule.addAtom(this.currentMolecule.getBuilder().newInstance(IAtom.class, this.getMetalAtomicSymbol(funGroupToken)));
                    this.endOfChain = this.currentMolecule.getLastAtom();
                }
            }
        }
    }

    String getMetalAtomicSymbol(String metalName) {
        if (metalName == "aluminium") {
            return "Al";
        }
        if (metalName == "magnesium") {
            return "Mg";
        }
        if (metalName == "gallium") {
            return "Ga";
        }
        if (metalName == "indium") {
            return "In";
        }
        if (metalName == "thallium") {
            return "Tl";
        }
        if (metalName == "germanium") {
            return "Ge";
        }
        if (metalName == "tin") {
            return "Sn";
        }
        if (metalName == "lead") {
            return "Pb";
        }
        if (metalName == "arsenic") {
            return "As";
        }
        if (metalName == "antimony") {
            return "Sb";
        }
        if (metalName == "bismuth") {
            return "Bi";
        }
        return null;
    }

    private void addAtom(String newAtomType, IAtom otherConnectingAtom, IBond.Order bondOrder, int hydrogenCount) {
        IAtom newAtom = this.currentMolecule.getBuilder().newInstance(IAtom.class, newAtomType);
        newAtom.setImplicitHydrogenCount(hydrogenCount);
        IBond newBond = this.currentMolecule.getBuilder().newInstance(IBond.class, new Object[]{newAtom, otherConnectingAtom, bondOrder});
        this.currentMolecule.addAtom(newAtom);
        this.currentMolecule.addBond(newBond);
    }

    private void addHeads(List<AttachedGroup> attachedSubstituents) {
        for (AttachedGroup attachedSubstituent : attachedSubstituents) {
            for (Token locationToken : attachedSubstituent.getLocations()) {
                int joinLocation = Integer.parseInt(locationToken.image) - 1;
                IAtom connectingAtom = joinLocation < 0 ? this.endOfChain : this.currentMolecule.getAtom(joinLocation);
                IAtomContainer subChain = this.buildChain(attachedSubstituent.getLength(), false);
                IBond linkingBond = this.currentMolecule.getBuilder().newInstance(IBond.class, subChain.getFirstAtom(), connectingAtom);
                this.currentMolecule.addBond(linkingBond);
                this.currentMolecule.add(subChain);
            }
        }
    }

    protected IAtomContainer buildMolecule(int mainChain, List<AttachedGroup> attachedSubstituents, List<AttachedGroup> attachedGroups, boolean isMainCyclic, String name) throws ParseException, CDKException {
        this.currentMolecule.setID(name);
        this.currentMolecule.add(this.buildChain(mainChain, isMainCyclic));
        if (mainChain != 0) {
            this.endOfChain = this.currentMolecule.getLastAtom();
        }
        this.buildFunGroups(attachedGroups);
        this.addHeads(attachedSubstituents);
        CDKAtomTypeMatcher matcher = CDKAtomTypeMatcher.getInstance(this.currentMolecule.getBuilder());
        for (IAtom atom : this.currentMolecule.atoms()) {
            IAtomType type = matcher.findMatchingAtomType(this.currentMolecule, atom);
            AtomTypeManipulator.configure(atom, type);
        }
        CDKHydrogenAdder hAdder = CDKHydrogenAdder.getInstance(this.currentMolecule.getBuilder());
        hAdder.addImplicitHydrogens(this.currentMolecule);
        return this.currentMolecule;
    }
}

