/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.ringsearch;

import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.AllCycles;
import org.openscience.cdk.graph.GraphUtil;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IRing;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.ringsearch.RingSearch;

@TestClass(value="org.openscience.cdk.ringsearch.AllRingsFinderTest")
public final class AllRingsFinder {
    private final Threshold threshold;

    @Deprecated
    public AllRingsFinder(boolean logging) {
        this(Threshold.PubChem_99);
    }

    public AllRingsFinder() {
        this(Threshold.PubChem_99);
    }

    private AllRingsFinder(Threshold threshold) {
        this.threshold = threshold;
    }

    @TestMethod(value="testFindAllRings_IAtomContainer,testBondsWithinRing")
    public IRingSet findAllRings(IAtomContainer container) throws CDKException {
        return this.findAllRings(container, container.getAtomCount());
    }

    public IRingSet findAllRings(IAtomContainer container, int maxRingSize) throws CDKException {
        int m = container.getBondCount();
        GraphUtil.EdgeToBondMap edges = GraphUtil.EdgeToBondMap.withSpaceFor(container);
        int[][] graph = GraphUtil.toAdjList(container, edges);
        RingSearch rs = new RingSearch(container, graph);
        IRingSet ringSet = container.getBuilder().newInstance(IRingSet.class, new Object[0]);
        for (int[] isolated : rs.isolated()) {
            if (isolated.length > maxRingSize) continue;
            IRing ring = this.toRing(container, edges, GraphUtil.cycle(graph, isolated));
            ringSet.addAtomContainer(ring);
        }
        for (int[] fused : rs.fused()) {
            AllCycles ac = new AllCycles(GraphUtil.subgraph(graph, fused), Math.min(maxRingSize, fused.length), this.threshold.value);
            if (!ac.completed()) {
                throw new CDKException("Threshold exceeded for AllRingsFinder");
            }
            for (int[] path : ac.paths()) {
                IRing ring = this.toRing(container, edges, path, fused);
                ringSet.addAtomContainer(ring);
            }
        }
        return ringSet;
    }

    public IRingSet findAllRingsInIsolatedRingSystem(IAtomContainer container) throws CDKException {
        return this.findAllRingsInIsolatedRingSystem(container, container.getAtomCount());
    }

    public IRingSet findAllRingsInIsolatedRingSystem(IAtomContainer atomContainer, int maxRingSize) throws CDKException {
        int m = atomContainer.getBondCount();
        GraphUtil.EdgeToBondMap edges = GraphUtil.EdgeToBondMap.withSpaceFor(atomContainer);
        int[][] graph = GraphUtil.toAdjList(atomContainer, edges);
        AllCycles ac = new AllCycles(graph, maxRingSize, this.threshold.value);
        if (!ac.completed()) {
            throw new CDKException("Threshold exceeded for AllRingsFinder");
        }
        IRingSet ringSet = atomContainer.getBuilder().newInstance(IRingSet.class, new Object[0]);
        for (int[] path : ac.paths()) {
            ringSet.addAtomContainer(this.toRing(atomContainer, edges, path));
        }
        return ringSet;
    }

    @TestMethod(value="testCheckTimeout")
    @Deprecated
    public void checkTimeout() throws CDKException {
    }

    @TestMethod(value="testSetTimeout_long")
    @Deprecated
    public AllRingsFinder setTimeout(long timeout) {
        System.err.println("AllRingsFinder.setTimeout() is not used, please use the new threshold values");
        return this;
    }

    @TestMethod(value="testGetTimeout")
    @Deprecated
    public long getTimeout() {
        return 0L;
    }

    private IRing toRing(IAtomContainer container, GraphUtil.EdgeToBondMap edges, int[] cycle) {
        IRing ring = container.getBuilder().newInstance(IRing.class, 0);
        int len = cycle.length - 1;
        IAtom[] atoms = new IAtom[len];
        IBond[] bonds = new IBond[len];
        for (int i = 0; i < len; ++i) {
            atoms[i] = container.getAtom(cycle[i]);
            bonds[i] = edges.get(cycle[i], cycle[i + 1]);
            atoms[i].setFlag(2, true);
        }
        ring.setAtoms(atoms);
        ring.setBonds(bonds);
        return ring;
    }

    private IRing toRing(IAtomContainer container, GraphUtil.EdgeToBondMap edges, int[] cycle, int[] mapping) {
        IRing ring = container.getBuilder().newInstance(IRing.class, 0);
        int len = cycle.length - 1;
        IAtom[] atoms = new IAtom[len];
        IBond[] bonds = new IBond[len];
        for (int i = 0; i < len; ++i) {
            atoms[i] = container.getAtom(mapping[cycle[i]]);
            bonds[i] = edges.get(mapping[cycle[i]], mapping[cycle[i + 1]]);
            atoms[i].setFlag(2, true);
        }
        ring.setAtoms(atoms);
        ring.setBonds(bonds);
        return ring;
    }

    public static AllRingsFinder usingThreshold(Threshold threshold) {
        return new AllRingsFinder(threshold);
    }

    public static enum Threshold {
        PubChem_95(72),
        PubChem_96(84),
        PubChem_97(126),
        PubChem_98(216),
        PubChem_99(684),
        PubChem_991(882),
        PubChem_992(1062),
        PubChem_993(1440),
        PubChem_994(3072),
        None(Integer.MAX_VALUE);

        private final int value;

        private Threshold(int value) {
            this.value = value;
        }
    }
}

