/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.ringsearch;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.graph.GraphUtil;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.ringsearch.CyclicVertexSearch;
import org.openscience.cdk.ringsearch.JumboCyclicVertexSearch;
import org.openscience.cdk.ringsearch.RegularCyclicVertexSearch;

@TestClass(value="org.openscience.cdk.ringsearch.RingSearchTest")
public final class RingSearch {
    private final CyclicVertexSearch searcher;
    private final IAtomContainer container;

    @TestMethod(value="testNull")
    public RingSearch(IAtomContainer container) {
        this(container, GraphUtil.toAdjList(container));
    }

    @TestMethod(value="testNullContainer,testNullGraph")
    public RingSearch(IAtomContainer container, int[][] graph) {
        this(container, RingSearch.makeSearcher(graph));
    }

    @TestMethod(value="testNullCyclicSearch")
    public RingSearch(IAtomContainer container, CyclicVertexSearch searcher) {
        if (container == null) {
            throw new NullPointerException("container must not be null");
        }
        if (searcher == null) {
            throw new NullPointerException("searcher was null");
        }
        this.searcher = searcher;
        this.container = container;
    }

    private static CyclicVertexSearch makeSearcher(int[][] graph) {
        if (graph == null) {
            throw new NullPointerException("graph[][] must not be null");
        }
        if (graph.length <= 64) {
            return new RegularCyclicVertexSearch(graph);
        }
        return new JumboCyclicVertexSearch(graph);
    }

    @TestMethod(value="testCyclic_IntInt")
    public boolean cyclic(int u, int v) {
        return this.searcher.cyclic(u, v);
    }

    @TestMethod(value="testCyclic_Atom")
    public boolean cyclic(IAtom atom) {
        int i = this.container.getAtomNumber(atom);
        if (i < 0) {
            throw new NoSuchElementException("no such atom");
        }
        return this.cyclic(i);
    }

    @TestMethod(value="testCyclic_Bond")
    public boolean cyclic(IBond bond) {
        int u = this.container.getAtomNumber(bond.getAtom(0));
        int v = this.container.getAtomNumber(bond.getAtom(1));
        if (u < 0 || v < 0) {
            throw new NoSuchElementException("atoms of the bond are not found in the container");
        }
        return this.searcher.cyclic(u, v);
    }

    @TestMethod(value="testCyclic_Int")
    public boolean cyclic(int i) {
        return this.searcher.cyclic(i);
    }

    @TestMethod(value="testCyclic")
    public int[] cyclic() {
        return this.searcher.cyclic();
    }

    @TestMethod(value="testIsolated")
    public int[][] isolated() {
        return this.searcher.isolated();
    }

    @TestMethod(value="testFused")
    public int[][] fused() {
        return this.searcher.fused();
    }

    @TestMethod(value="testRingFragments")
    public IAtomContainer ringFragments() {
        int[] vertices = this.cyclic();
        int n = vertices.length;
        IAtom[] atoms = new IAtom[n];
        ArrayList<IBond> bonds = new ArrayList<IBond>();
        for (int i = 0; i < vertices.length; ++i) {
            atoms[i] = this.container.getAtom(vertices[i]);
        }
        for (IBond bond : this.container.bonds()) {
            int v;
            IAtom either = bond.getAtom(0);
            IAtom other = bond.getAtom(1);
            int u = this.container.getAtomNumber(either);
            if (!this.searcher.cyclic(u, v = this.container.getAtomNumber(other))) continue;
            bonds.add(bond);
        }
        IChemObjectBuilder builder = this.container.getBuilder();
        IAtomContainer fragment = builder.newInstance(IAtomContainer.class, 0, 0, 0, 0);
        fragment.setAtoms(atoms);
        fragment.setBonds(bonds.toArray(new IBond[bonds.size()]));
        return fragment;
    }

    @TestMethod(value="testMatch")
    static boolean match(int eitherColor, int otherColor) {
        return eitherColor != -1 && otherColor != -1 && (eitherColor == otherColor || eitherColor == 0 || otherColor == 0);
    }

    @TestMethod(value="testIsolatedRingFragments")
    public List<IAtomContainer> isolatedRingFragments() {
        return this.toFragments(this.isolated());
    }

    @TestMethod(value="testFusedRingFragments")
    public List<IAtomContainer> fusedRingFragments() {
        return this.toFragments(this.fused());
    }

    private List<IAtomContainer> toFragments(int[][] verticesList) {
        ArrayList<IAtomContainer> fragments = new ArrayList<IAtomContainer>();
        for (int[] vertices : verticesList) {
            fragments.add(this.toFragment(vertices));
        }
        return fragments;
    }

    private IAtomContainer toFragment(int[] vertices) {
        int n = vertices.length;
        HashSet<IAtom> atoms = new HashSet<IAtom>(n > 3 ? n + 1 + n / 3 : n);
        ArrayList<IBond> bonds = new ArrayList<IBond>();
        for (int v : vertices) {
            atoms.add(this.container.getAtom(v));
        }
        for (IBond bond : this.container.bonds()) {
            IAtom either = bond.getAtom(0);
            IAtom other = bond.getAtom(1);
            if (!atoms.contains(either) || !atoms.contains(other)) continue;
            bonds.add(bond);
        }
        IAtomContainer fragment = this.container.getBuilder().newInstance(IAtomContainer.class, 0, 0, 0, 0);
        fragment.setAtoms(atoms.toArray(new IAtom[n]));
        fragment.setBonds(bonds.toArray(new IBond[bonds.size()]));
        return fragment;
    }
}

