/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.debug;

import java.util.Map;
import org.openscience.cdk.AtomType;
import org.openscience.cdk.debug.DebugChemObjectBuilder;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IChemObjectChangeEvent;
import org.openscience.cdk.interfaces.IChemObjectListener;
import org.openscience.cdk.interfaces.IElement;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class DebugAtomType
extends AtomType
implements IAtomType {
    private static final long serialVersionUID = 1427549696666679540L;
    ILoggingTool logger = LoggingToolFactory.createLoggingTool(DebugAtomType.class);

    public DebugAtomType(String elementSymbol) {
        super(elementSymbol);
        this.logger.debug((Object)"Instantiated a DebugAtomType: symbol= ", new Object[]{elementSymbol});
    }

    public DebugAtomType(String identifier, String elementSymbol) {
        super(elementSymbol);
        this.logger.debug((Object)("Instantiated a DebugAtomType: identifier= " + identifier + " symbol= "), new Object[]{elementSymbol});
        this.setSymbol(elementSymbol);
        this.setAtomTypeName(identifier);
    }

    public DebugAtomType(IElement element) {
        super(element);
        this.logger.debug((Object)"Instantiated a DebugAtomType: element= ", new Object[]{element});
    }

    public Integer getAtomicNumber() {
        this.logger.debug((Object)"Getting atomic number: ", new Object[]{super.getAtomicNumber()});
        return super.getAtomicNumber();
    }

    public void setAtomicNumber(Integer atomicNumber) {
        this.logger.debug((Object)"Setting atomic number: ", new Object[]{atomicNumber});
        super.setAtomicNumber(atomicNumber);
    }

    public String getSymbol() {
        this.logger.debug((Object)"Getting symbol: ", new Object[]{super.getSymbol()});
        return super.getSymbol();
    }

    public void setSymbol(String symbol) {
        this.logger.debug((Object)"Setting symbol: ", new Object[]{symbol});
        super.setSymbol(symbol);
    }

    public void addListener(IChemObjectListener col) {
        this.logger.debug((Object)"Adding listener: ", new Object[]{col});
        super.addListener(col);
    }

    public int getListenerCount() {
        this.logger.debug((Object)"Getting listener count: ", new Object[]{super.getListenerCount()});
        return super.getListenerCount();
    }

    public void removeListener(IChemObjectListener col) {
        this.logger.debug((Object)"Removing listener: ", new Object[]{col});
        super.removeListener(col);
    }

    public void notifyChanged() {
        this.logger.debug((Object)"Notifying changed");
        super.notifyChanged();
    }

    public void notifyChanged(IChemObjectChangeEvent evt) {
        this.logger.debug((Object)"Notifying changed event: ", new Object[]{evt});
        super.notifyChanged(evt);
    }

    public void setProperty(Object description, Object property) {
        this.logger.debug((Object)"Setting property: ", new Object[]{description + "=" + property});
        super.setProperty(description, property);
    }

    public void removeProperty(Object description) {
        this.logger.debug((Object)"Removing property: ", new Object[]{description});
        super.removeProperty(description);
    }

    public <T> T getProperty(Object description) {
        this.logger.debug((Object)"Getting property: ", new Object[]{description + "=" + super.getProperty(description)});
        return (T)super.getProperty(description);
    }

    public Map<Object, Object> getProperties() {
        this.logger.debug((Object)"Getting properties");
        return super.getProperties();
    }

    public String getID() {
        this.logger.debug((Object)"Getting ID: ", new Object[]{super.getID()});
        return super.getID();
    }

    public void setID(String identifier) {
        this.logger.debug((Object)"Setting ID: ", new Object[]{identifier});
        super.setID(identifier);
    }

    public void setFlag(int flag_type, boolean flag_value) {
        this.logger.debug((Object)"Setting flag: ", new Object[]{flag_type + "=" + flag_value});
        super.setFlag(flag_type, flag_value);
    }

    public boolean getFlag(int flag_type) {
        this.logger.debug((Object)"Setting flag: ", new Object[]{flag_type + "=" + super.getFlag(flag_type)});
        return super.getFlag(flag_type);
    }

    public void addProperties(Map<Object, Object> properties) {
        this.logger.debug((Object)"Setting properties: ", new Object[]{properties});
        super.addProperties(properties);
    }

    public void setFlags(boolean[] flagsNew) {
        this.logger.debug((Object)"Setting flags:", new Object[]{flagsNew.length});
        super.setFlags(flagsNew);
    }

    public boolean[] getFlags() {
        this.logger.debug((Object)"Getting flags:", new Object[]{super.getFlags().length});
        return super.getFlags();
    }

    public Object clone() throws CloneNotSupportedException {
        Object clone = null;
        try {
            clone = super.clone();
        }
        catch (Exception exception) {
            this.logger.error((Object)("Could not clone DebugAtom: " + exception.getMessage()), new Object[]{exception});
            this.logger.debug((Object)exception);
        }
        return clone;
    }

    public IChemObjectBuilder getBuilder() {
        return DebugChemObjectBuilder.getInstance();
    }

    public void setNaturalAbundance(Double naturalAbundance) {
        this.logger.debug((Object)"Setting natural abundance: ", new Object[]{naturalAbundance});
        super.setNaturalAbundance(naturalAbundance);
    }

    public void setExactMass(Double exactMass) {
        this.logger.debug((Object)"Setting exact mass: ", new Object[]{exactMass});
        super.setExactMass(exactMass);
    }

    public Double getNaturalAbundance() {
        this.logger.debug((Object)"Getting natural abundance: ", new Object[]{super.getNaturalAbundance()});
        return super.getNaturalAbundance();
    }

    public Double getExactMass() {
        this.logger.debug((Object)"Getting exact mass: ", new Object[]{super.getExactMass()});
        return super.getExactMass();
    }

    public Integer getMassNumber() {
        this.logger.debug((Object)"Getting mass number: ", new Object[]{super.getMassNumber()});
        return super.getMassNumber();
    }

    public void setMassNumber(Integer massNumber) {
        this.logger.debug((Object)"Setting mass number: ", new Object[]{massNumber});
        super.setMassNumber(massNumber);
    }

    public void setAtomTypeName(String identifier) {
        this.logger.debug((Object)"Setting atom type name: ", new Object[]{identifier});
        super.setAtomTypeName(identifier);
    }

    public void setMaxBondOrder(IBond.Order maxBondOrder) {
        this.logger.debug((Object)"Setting max bond order: ", new Object[]{maxBondOrder});
        super.setMaxBondOrder(maxBondOrder);
    }

    public void setBondOrderSum(Double bondOrderSum) {
        this.logger.debug((Object)"Setting bond order sum: ", new Object[]{bondOrderSum});
        super.setBondOrderSum(bondOrderSum);
    }

    public String getAtomTypeName() {
        this.logger.debug((Object)"Getting atom type name: ", new Object[]{super.getAtomTypeName()});
        return super.getAtomTypeName();
    }

    public IBond.Order getMaxBondOrder() {
        this.logger.debug((Object)"Getting max bond order: ", new Object[]{super.getMaxBondOrder()});
        return super.getMaxBondOrder();
    }

    public Double getBondOrderSum() {
        this.logger.debug((Object)"Getting bond order sum: ", new Object[]{super.getBondOrderSum()});
        return super.getBondOrderSum();
    }

    public void setFormalCharge(Integer charge) {
        this.logger.debug((Object)"Setting formal charge: ", new Object[]{charge});
        super.setFormalCharge(charge);
    }

    public Integer getFormalCharge() {
        this.logger.debug((Object)"Getting formal charge: ", new Object[]{super.getFormalCharge()});
        return super.getFormalCharge();
    }

    public void setFormalNeighbourCount(Integer count) {
        this.logger.debug((Object)"Setting forml neighbour count: ", new Object[]{count});
        super.setFormalNeighbourCount(count);
    }

    public Integer getFormalNeighbourCount() {
        this.logger.debug((Object)"Getting formal neighbour count: ", new Object[]{super.getFormalNeighbourCount()});
        return super.getFormalNeighbourCount();
    }

    public void setHybridization(IAtomType.Hybridization hybridization) {
        this.logger.debug((Object)"Setting hybridization: ", new Object[]{hybridization});
        super.setHybridization(hybridization);
    }

    public IAtomType.Hybridization getHybridization() {
        this.logger.debug((Object)"Getting hybridization: ", new Object[]{super.getHybridization()});
        return super.getHybridization();
    }

    public void setCovalentRadius(Double radius) {
        this.logger.debug((Object)"Setting covalent radius: ", new Object[]{radius});
        super.setCovalentRadius(radius);
    }

    public Double getCovalentRadius() {
        this.logger.debug((Object)"Getting covalent radius: ", new Object[]{super.getCovalentRadius()});
        return super.getCovalentRadius();
    }

    public void setValency(Integer valency) {
        this.logger.debug((Object)"Setting valency: ", new Object[]{valency});
        super.setValency(valency);
    }

    public Integer getValency() {
        this.logger.debug((Object)"Getting valency: ", new Object[]{super.getValency()});
        return super.getValency();
    }
}

