/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.fingerprint;

import java.util.HashMap;
import java.util.Map;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.fingerprint.IBitFingerprint;
import org.openscience.cdk.fingerprint.ICountFingerprint;
import org.openscience.cdk.fingerprint.IFingerprinter;
import org.openscience.cdk.fingerprint.IntArrayCountFingerprint;
import org.openscience.cdk.fingerprint.IntArrayFingerprint;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.signature.AtomSignature;

@TestClass(value="org.openscience.cdk.fingerprint.SignatureFingerprinterTest")
public class SignatureFingerprinter
implements IFingerprinter {
    private int signatureDepth;

    public SignatureFingerprinter() {
        this(1);
    }

    public SignatureFingerprinter(int depth) {
        this.signatureDepth = depth;
    }

    @TestMethod(value="testBitFingerprint")
    public IBitFingerprint getBitFingerprint(IAtomContainer atomContainer) throws CDKException {
        return new IntArrayFingerprint(this.getRawFingerprint(atomContainer));
    }

    @TestMethod(value="testGetRawFingerprint")
    public Map<String, Integer> getRawFingerprint(IAtomContainer atomContainer) throws CDKException {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (IAtom atom : atomContainer.atoms()) {
            String signature = new AtomSignature(atom, this.signatureDepth, atomContainer).toCanonicalString();
            if (map.containsKey(signature)) {
                map.put(signature, (Integer)map.get(signature) + 1);
                continue;
            }
            map.put(signature, 1);
        }
        return map;
    }

    @TestMethod(value="testGetSize")
    public int getSize() {
        return -1;
    }

    @TestMethod(value="testGetCountFingerprint")
    public ICountFingerprint getCountFingerprint(IAtomContainer container) throws CDKException {
        return new IntArrayCountFingerprint(this.getRawFingerprint(container));
    }
}

