/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smsd.algorithm.mcgregor;

import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.cdk.smsd.algorithm.mcgregor.McGregorChecks;

@TestClass(value="org.openscience.cdk.smsd.algorithm.mcgregor.QueryProcessorTest")
public class QueryProcessor {
    private List<String> cTab1Copy;
    private List<String> cTab2Copy;
    private String[] signs;
    private int neighborBondNumA = 0;
    private int setBondNumA = 0;
    private List<Integer> iBondNeighborsA;
    private List<String> cBondNeighborsA;
    private int newNeighborNumA;
    private List<Integer> newINeighborsA;
    private List<String> newCNeighborsA;

    protected QueryProcessor(List<String> cTab1Copy, List<String> cTab2Copy, String[] signArray, int neighbor_bondnum_A, int set_bondnum_A, List<Integer> i_bond_neighborsA, List<String> c_bond_neighborsA, int mappingSize, List<Integer> i_bond_setA, List<String> c_bond_setA) {
        this.cTab1Copy = cTab1Copy;
        this.cTab2Copy = cTab2Copy;
        this.signs = signArray;
        this.neighborBondNumA = neighbor_bondnum_A;
        this.setBondNumA = set_bondnum_A;
        this.iBondNeighborsA = i_bond_neighborsA;
        this.cBondNeighborsA = c_bond_neighborsA;
        this.newNeighborNumA = mappingSize;
        this.newINeighborsA = i_bond_setA;
        this.newCNeighborsA = c_bond_setA;
    }

    protected void process(IAtomContainer query, IAtomContainer target, List<Integer> unmapped_atoms_molA, List<Integer> mapped_atoms, int counter) {
        int unmapped_numA = unmapped_atoms_molA.size();
        boolean bond_considered = false;
        boolean normal_bond = true;
        for (int atomIndex = 0; atomIndex < query.getBondCount(); ++atomIndex) {
            Integer indexI = query.getAtomNumber(query.getBond(atomIndex).getAtom(0));
            Integer indexJ = query.getAtomNumber(query.getBond(atomIndex).getAtom(1));
            Integer order = query.getBond(atomIndex).getOrder().numeric();
            Integer unMappedAtomIndex = 0;
            while (unMappedAtomIndex < unmapped_numA) {
                if (unmapped_atoms_molA.get(unMappedAtomIndex).equals(indexI)) {
                    normal_bond = this.unMappedAtomsEqualsIndexJ(query, target, atomIndex, counter, mapped_atoms, indexI, indexJ, order);
                    bond_considered = true;
                } else if (unmapped_atoms_molA.get(unMappedAtomIndex).equals(indexJ)) {
                    normal_bond = this.unMappedAtomsEqualsIndexI(query, target, atomIndex, counter, mapped_atoms, indexI, indexJ, order);
                    bond_considered = true;
                }
                if (normal_bond && bond_considered) {
                    this.markNormalBonds(atomIndex, indexI, indexJ, order);
                    normal_bond = true;
                    break;
                }
                Integer n = unMappedAtomIndex;
                Integer n2 = unMappedAtomIndex = Integer.valueOf(unMappedAtomIndex + 1);
            }
            bond_considered = false;
        }
    }

    protected void process(IQueryAtomContainer query, IAtomContainer target, List<Integer> unmapped_atoms_molA, List<Integer> mapped_atoms, int counter) {
        int unmapped_numA = unmapped_atoms_molA.size();
        boolean bond_considered = false;
        boolean normal_bond = true;
        for (int atomIndex = 0; atomIndex < query.getBondCount(); ++atomIndex) {
            Integer indexI = query.getAtomNumber(query.getBond(atomIndex).getAtom(0));
            Integer indexJ = query.getAtomNumber(query.getBond(atomIndex).getAtom(1));
            Integer order = 0;
            if (query.getBond(atomIndex).getOrder() != null) {
                order = query.getBond(atomIndex).getOrder().numeric();
            }
            Integer unMappedAtomIndex = 0;
            while (unMappedAtomIndex < unmapped_numA) {
                if (unmapped_atoms_molA.get(unMappedAtomIndex).equals(indexI)) {
                    normal_bond = this.unMappedAtomsEqualsIndexJ((IAtomContainer)query, target, atomIndex, counter, mapped_atoms, indexI, indexJ, order);
                    bond_considered = true;
                } else if (unmapped_atoms_molA.get(unMappedAtomIndex).equals(indexJ)) {
                    normal_bond = this.unMappedAtomsEqualsIndexI((IAtomContainer)query, target, atomIndex, counter, mapped_atoms, indexI, indexJ, order);
                    bond_considered = true;
                }
                if (normal_bond && bond_considered) {
                    this.markNormalBonds(atomIndex, indexI, indexJ, order);
                    normal_bond = true;
                    break;
                }
                Integer n = unMappedAtomIndex;
                Integer n2 = unMappedAtomIndex = Integer.valueOf(unMappedAtomIndex + 1);
            }
            bond_considered = false;
        }
    }

    protected void process(int setNumA, int setNumB, List<Integer> i_bond_setA, List<Integer> i_bond_setB, List<Integer> unmapped_atoms_molA, List<Integer> new_Mapping, int counter) {
        boolean bond_considered = false;
        boolean normal_bond = true;
        for (int atomIndex = 0; atomIndex < setNumA; ++atomIndex) {
            Integer indexI = i_bond_setA.get(atomIndex * 3 + 0);
            Integer indexJ = i_bond_setA.get(atomIndex * 3 + 1);
            Integer order = i_bond_setA.get(atomIndex * 3 + 2);
            for (Integer unMappedAtomIndex : unmapped_atoms_molA) {
                if (unMappedAtomIndex.equals(indexI)) {
                    normal_bond = this.unMappedAtomsEqualsIndexJ(setNumA, setNumB, i_bond_setA, i_bond_setB, atomIndex, counter, new_Mapping, indexI, indexJ, order);
                    bond_considered = true;
                } else if (unMappedAtomIndex.equals(indexJ)) {
                    normal_bond = this.unMappedAtomsEqualsIndexI(setNumA, setNumB, i_bond_setA, i_bond_setB, atomIndex, counter, new_Mapping, indexI, indexJ, order);
                    bond_considered = true;
                }
                if (!normal_bond || !bond_considered) continue;
                this.markNormalBonds(atomIndex, indexI, indexJ, order);
                normal_bond = true;
                break;
            }
            bond_considered = false;
        }
    }

    private int searchCorrespondingAtom(int mapped_atoms_size, int atom_from_other_molecule, int molecule, List<Integer> mapped_atoms_org) {
        ArrayList<Integer> mapped_atoms = new ArrayList<Integer>(mapped_atoms_org);
        int corresponding_atom = 0;
        for (int a = 0; a < mapped_atoms_size; ++a) {
            if (molecule == 1 && (Integer)mapped_atoms.get(a * 2 + 0) == atom_from_other_molecule) {
                corresponding_atom = (Integer)mapped_atoms.get(a * 2 + 1);
            }
            if (molecule != 2 || (Integer)mapped_atoms.get(a * 2 + 1) != atom_from_other_molecule) continue;
            corresponding_atom = (Integer)mapped_atoms.get(a * 2 + 0);
        }
        return corresponding_atom;
    }

    private void markNormalBonds(int atomIndex, Integer indexI, Integer indexJ, Integer order) {
        this.newINeighborsA.add(indexI);
        this.newINeighborsA.add(indexJ);
        this.newINeighborsA.add(order);
        this.newCNeighborsA.add(this.cTab1Copy.get(atomIndex * 4 + 0));
        this.newCNeighborsA.add(this.cTab1Copy.get(atomIndex * 4 + 1));
        this.newCNeighborsA.add("X");
        this.newCNeighborsA.add("X");
        ++this.setBondNumA;
    }

    private void step1(int atomIndex, int counter) {
        this.cBondNeighborsA.add(this.cTab1Copy.get(atomIndex * 4 + 0));
        this.cBondNeighborsA.add(this.signs[counter]);
        this.cBondNeighborsA.add("X");
        this.cBondNeighborsA.add(this.cTab1Copy.get(atomIndex * 4 + 1));
    }

    private void step2(int atomIndex) {
        this.cBondNeighborsA.add(this.cTab1Copy.get(atomIndex * 4 + 0));
        this.cBondNeighborsA.add(this.cTab1Copy.get(atomIndex * 4 + 1));
        this.cBondNeighborsA.add("X");
        this.cBondNeighborsA.add(this.cTab1Copy.get(atomIndex * 4 + 3));
    }

    private void step3(int atomIndex, int counter) {
        this.cBondNeighborsA.add(this.signs[counter]);
        this.cBondNeighborsA.add(this.cTab1Copy.get(atomIndex * 4 + 1));
        this.cBondNeighborsA.add(this.cTab1Copy.get(atomIndex * 4 + 0));
        this.cBondNeighborsA.add("X");
    }

    private void step4(int atomIndex) {
        this.cBondNeighborsA.add(this.cTab1Copy.get(atomIndex * 4 + 0));
        this.cBondNeighborsA.add(this.cTab1Copy.get(atomIndex * 4 + 1));
        this.cBondNeighborsA.add(this.cTab1Copy.get(atomIndex * 4 + 2));
        this.cBondNeighborsA.add("X");
    }

    private boolean unMappedAtomsEqualsIndexJ(IAtomContainer query, IAtomContainer target, int atomIndex, int counter, List<Integer> mapped_atoms, Integer indexI, Integer indexJ, Integer order) {
        boolean normal_bond = true;
        for (int c = 0; c < this.newNeighborNumA; ++c) {
            if (!mapped_atoms.get(c * 2).equals(indexJ)) continue;
            this.setBondNeighbors(indexI, indexJ, order);
            if (this.cTab1Copy.get(atomIndex * 4 + 3).compareToIgnoreCase("X") == 0) {
                this.step1(atomIndex, counter);
                McGregorChecks.changeCharBonds((int)indexI, this.signs[counter], query.getBondCount(), query, this.cTab1Copy);
                int cor_atom = this.searchCorrespondingAtom(this.newNeighborNumA, indexI, 1, mapped_atoms);
                McGregorChecks.changeCharBonds(cor_atom, this.signs[counter], target.getBondCount(), target, this.cTab2Copy);
                ++counter;
            } else {
                this.step2(atomIndex);
            }
            normal_bond = false;
            ++this.neighborBondNumA;
        }
        return normal_bond;
    }

    private boolean unMappedAtomsEqualsIndexI(IAtomContainer query, IAtomContainer target, int atomIndex, int counter, List<Integer> mapped_atoms, Integer indexI, Integer indexJ, Integer order) {
        boolean normal_bond = true;
        for (int c = 0; c < this.newNeighborNumA; ++c) {
            if (!mapped_atoms.get(c * 2 + 0).equals(indexI)) continue;
            this.setBondNeighbors(indexI, indexJ, order);
            if (this.cTab1Copy.get(atomIndex * 4 + 2).compareToIgnoreCase("X") == 0) {
                this.step3(atomIndex, counter);
                McGregorChecks.changeCharBonds((int)indexJ, this.signs[counter], query.getBondCount(), query, this.cTab1Copy);
                int cor_atom = this.searchCorrespondingAtom(this.newNeighborNumA, indexJ, 1, mapped_atoms);
                McGregorChecks.changeCharBonds(cor_atom, this.signs[counter], target.getBondCount(), target, this.cTab2Copy);
                ++counter;
            } else {
                this.step4(atomIndex);
            }
            normal_bond = false;
            ++this.neighborBondNumA;
        }
        return normal_bond;
    }

    private boolean unMappedAtomsEqualsIndexJ(int setNumA, int setNumB, List<Integer> i_bond_setA, List<Integer> i_bond_setB, int atomIndex, int counter, List<Integer> new_Mapping, Integer indexI, Integer indexJ, Integer order) {
        boolean normal_bond = true;
        for (int c = 0; c < this.newNeighborNumA; ++c) {
            if (!new_Mapping.get(c * 2 + 0).equals(indexJ)) continue;
            this.setBondNeighbors(indexI, indexJ, order);
            if (this.cTab1Copy.get(atomIndex * 4 + 3).compareToIgnoreCase("X") == 0) {
                this.step1(atomIndex, counter);
                McGregorChecks.changeCharBonds((int)indexI, this.signs[counter], setNumA, i_bond_setA, this.cTab1Copy);
                int cor_atom = McGregorChecks.searchCorrespondingAtom(this.newNeighborNumA, indexI, 1, new_Mapping);
                McGregorChecks.changeCharBonds(cor_atom, this.signs[counter], setNumB, i_bond_setB, this.cTab2Copy);
                ++counter;
            } else {
                this.step2(atomIndex);
            }
            normal_bond = false;
            ++this.neighborBondNumA;
        }
        return normal_bond;
    }

    private boolean unMappedAtomsEqualsIndexI(int setNumA, int setNumB, List<Integer> i_bond_setA, List<Integer> i_bond_setB, int atomIndex, int counter, List<Integer> new_Mapping, Integer indexI, Integer indexJ, Integer order) {
        boolean normal_bond = true;
        for (int c = 0; c < this.newNeighborNumA; ++c) {
            if (!new_Mapping.get(c * 2 + 0).equals(indexI)) continue;
            this.setBondNeighbors(indexI, indexJ, order);
            if (this.cTab1Copy.get(atomIndex * 4 + 2).compareToIgnoreCase("X") == 0) {
                this.step3(atomIndex, counter);
                McGregorChecks.changeCharBonds((int)indexJ, this.signs[counter], setNumA, i_bond_setA, this.cTab1Copy);
                int cor_atom = McGregorChecks.searchCorrespondingAtom(this.newNeighborNumA, indexJ, 1, new_Mapping);
                McGregorChecks.changeCharBonds(cor_atom, this.signs[counter], setNumB, i_bond_setB, this.cTab2Copy);
                ++counter;
            } else {
                this.step4(atomIndex);
            }
            normal_bond = false;
            ++this.neighborBondNumA;
        }
        return normal_bond;
    }

    private void setBondNeighbors(Integer indexI, Integer indexJ, Integer order) {
        this.iBondNeighborsA.add(indexI);
        this.iBondNeighborsA.add(indexJ);
        this.iBondNeighborsA.add(order);
    }

    protected List<String> getCTab1() {
        return this.cTab1Copy;
    }

    protected List<String> getCTab2() {
        return this.cTab2Copy;
    }

    protected int getNeighborBondNumA() {
        return this.neighborBondNumA;
    }

    protected int getBondNumA() {
        return this.setBondNumA;
    }

    List<Integer> getIBondNeighboursA() {
        return this.iBondNeighborsA;
    }

    List<String> getCBondNeighborsA() {
        return this.cBondNeighborsA;
    }
}

