/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.forcefield.mmff;

import com.google.common.base.Charsets;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

enum MmffParamSet {
    INSTANCE;

    private static final int MAX_MMFF_ATOMTYPE = 99;
    private Map<BondKey, BigDecimal> bcis = new HashMap<BondKey, BigDecimal>();
    private MmffProp[] properties = new MmffProp[100];
    private Map<String, Integer> typeMap = new HashMap<String, Integer>();
    private Map<String, BigDecimal> fCharges = new HashMap<String, BigDecimal>();

    private MmffParamSet() {
        Throwable throwable;
        InputStream in;
        try {
            in = ((Object)((Object)this)).getClass().getResourceAsStream("MMFFCHG.PAR");
            throwable = null;
            try {
                MmffParamSet.parseMMFFCHARGE(in, this.bcis);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (in != null) {
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        in.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new InternalError("Could not load MMFFCHG.PAR");
        }
        try {
            in = ((Object)((Object)this)).getClass().getResourceAsStream("MMFFFORMCHG.PAR");
            throwable = null;
            try {
                MmffParamSet.parseMMFFFORMCHG(in, this.fCharges);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (in != null) {
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        in.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new InternalError("Could not load MMFFFORMCHG.PAR");
        }
        try {
            in = ((Object)((Object)this)).getClass().getResourceAsStream("MMFFPROP.PAR");
            throwable = null;
            try {
                MmffParamSet.parseMMFFPPROP(in, this.properties);
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                if (in != null) {
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable7) {
                            throwable.addSuppressed(throwable7);
                        }
                    } else {
                        in.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new InternalError("Could not load MMFFPROP.PAR");
        }
        try {
            in = ((Object)((Object)this)).getClass().getResourceAsStream("MMFFPBCI.PAR");
            throwable = null;
            try {
                MmffParamSet.parseMMFFPBCI(in, this.properties);
            }
            catch (Throwable throwable8) {
                throwable = throwable8;
                throw throwable8;
            }
            finally {
                if (in != null) {
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable9) {
                            throwable.addSuppressed(throwable9);
                        }
                    } else {
                        in.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new InternalError("Could not load MMFFPBCI.PAR");
        }
        try {
            in = ((Object)((Object)this)).getClass().getResourceAsStream("mmff-symb-mapping.tsv");
            throwable = null;
            try {
                MmffParamSet.parseMMFFTypeMap(in, this.typeMap);
            }
            catch (Throwable throwable10) {
                throwable = throwable10;
                throw throwable10;
            }
            finally {
                if (in != null) {
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable11) {
                            throwable.addSuppressed(throwable11);
                        }
                    } else {
                        in.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new InternalError("Could not load mmff-symb-mapping.tsv");
        }
    }

    int intType(String sym2) {
        Integer intType = this.typeMap.get(sym2);
        if (intType == null) {
            return 0;
        }
        return intType;
    }

    BigDecimal getBondChargeIncrement(int cls, int type1, int type2) {
        return this.bcis.get(new BondKey(cls, type1, type2));
    }

    BigDecimal getPartialBondChargeIncrement(int atype) {
        return this.properties[this.checkType(atype)].pbci;
    }

    BigDecimal getFormalChargeAdjustment(int atype) {
        return this.properties[this.checkType(atype)].fcAdj;
    }

    int getCrd(int atype) {
        return this.properties[this.checkType(atype)].crd;
    }

    BigDecimal getFormalCharge(String symb) {
        return this.fCharges.get(symb);
    }

    int getBondCls(int type1, int type2, int bord, boolean barom) {
        MmffProp prop1 = this.properties[this.checkType(type1)];
        MmffProp prop2 = this.properties[this.checkType(type2)];
        if (bord == 1 && !prop1.arom && prop1.sbmb && !prop2.arom && prop2.sbmb) {
            return 1;
        }
        if (bord == 1 && !barom && prop1.arom && prop2.arom) {
            return 1;
        }
        return 0;
    }

    private int checkType(int atype) {
        if (atype < 0 || atype > 99) {
            throw new IllegalArgumentException("Invalid MMFF atom type:" + atype);
        }
        return atype;
    }

    private static void parseMMFFCHARGE(InputStream in, Map<BondKey, BigDecimal> map) throws IOException {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(in, Charsets.UTF_8));){
            String line;
            while ((line = br.readLine()) != null) {
                if (line.isEmpty() || line.charAt(0) == '*') continue;
                String[] cols = line.split("\\s+");
                if (cols.length != 5) {
                    throw new IOException("Malformed MMFFBOND.PAR file.");
                }
                BondKey key = new BondKey(Integer.parseInt(cols[0]), Integer.parseInt(cols[1]), Integer.parseInt(cols[2]));
                BigDecimal bci = new BigDecimal(cols[3]);
                map.put(key, bci);
                map.put(key.inv(), bci.negate());
            }
        }
    }

    private static void parseMMFFPBCI(InputStream in, MmffProp[] props) throws IOException {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(in, Charsets.UTF_8));){
            String line;
            while ((line = br.readLine()) != null) {
                if (line.isEmpty() || line.charAt(0) == '*') continue;
                String[] cols = line.split("\\s+");
                if (cols.length < 5) {
                    throw new IOException("Malformed MMFFPCBI.PAR file.");
                }
                int type = Integer.parseInt(cols[1]);
                props[type].pbci = new BigDecimal(cols[2]);
                props[type].fcAdj = new BigDecimal(cols[3]);
            }
        }
    }

    private static void parseMMFFPPROP(InputStream in, MmffProp[] props) throws IOException {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(in, Charsets.UTF_8));){
            String line;
            while ((line = br.readLine()) != null) {
                if (line.isEmpty() || line.charAt(0) == '*') continue;
                String[] cols = line.split("\\s+");
                if (cols.length != 10) {
                    throw new IOException("Malformed MMFFPROP.PAR file.");
                }
                int type = Integer.parseInt(cols[1]);
                props[type] = new MmffProp(Integer.parseInt(cols[2]), Integer.parseInt(cols[3]), Integer.parseInt(cols[4]), Integer.parseInt(cols[5]), Integer.parseInt(cols[6]), Integer.parseInt(cols[7]), Integer.parseInt(cols[8]), Integer.parseInt(cols[9]));
            }
        }
    }

    private static void parseMMFFTypeMap(InputStream in, Map<String, Integer> types) throws IOException {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(in, Charsets.UTF_8));){
            String line = br.readLine();
            while ((line = br.readLine()) != null) {
                if (line.isEmpty() || line.charAt(0) == '*') continue;
                String[] cols = line.split("\t");
                int intType = Integer.parseInt(cols[1]);
                types.put(cols[0], intType);
                types.put(cols[2], intType);
            }
        }
    }

    private static void parseMMFFFORMCHG(InputStream in, Map<String, BigDecimal> fcharges) throws IOException {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(in, Charsets.UTF_8));){
            String line = br.readLine();
            while ((line = br.readLine()) != null) {
                if (line.isEmpty() || line.charAt(0) == '*') continue;
                String[] cols = line.split("\\s+");
                fcharges.put(cols[0], new BigDecimal(cols[1]));
            }
        }
    }

    private static final class MmffProp {
        private final int aspec;
        private final int crd;
        private final int val;
        private final int pilp;
        private final int mltb;
        private final boolean arom;
        private final boolean lin;
        private final boolean sbmb;
        private BigDecimal pbci;
        private BigDecimal fcAdj;

        public MmffProp(int aspec, int crd, int val, int pilp, int mltb, int arom, int lin, int sbmb) {
            this.aspec = aspec;
            this.crd = crd;
            this.val = val;
            this.pilp = pilp;
            this.mltb = mltb;
            this.arom = arom != 0;
            this.lin = lin != 0;
            this.sbmb = sbmb != 0;
        }
    }

    static final class BondKey {
        private final int cls;
        private final int type1;
        private final int type2;

        public BondKey(int cls, int type1, int type2) {
            this.cls = cls;
            this.type1 = type1;
            this.type2 = type2;
        }

        public BondKey inv() {
            return new BondKey(this.cls, this.type2, this.type1);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BondKey bondKey = (BondKey)o;
            if (this.cls != bondKey.cls) {
                return false;
            }
            if (this.type1 != bondKey.type1) {
                return false;
            }
            return this.type2 == bondKey.type2;
        }

        public int hashCode() {
            int result = this.cls;
            result = 31 * result + this.type1;
            result = 31 * result + this.type2;
            return result;
        }
    }
}

