/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.silent;

import com.google.common.base.Objects;
import java.io.Serializable;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.interfaces.IElement;
import org.openscience.cdk.silent.ChemObject;
import org.openscience.cdk.tools.periodictable.PeriodicTable;

public class Element
extends ChemObject
implements Serializable,
IElement,
Cloneable {
    private static final long serialVersionUID = 3062529834691231436L;
    protected String symbol;
    protected Integer atomicNumber = (Integer)CDKConstants.UNSET;

    public Element() {
        this.symbol = null;
    }

    public Element(IElement element) {
        super(element);
        this.symbol = element.getSymbol();
        this.atomicNumber = element.getAtomicNumber();
    }

    public Element(String symbol) {
        this(symbol, PeriodicTable.getAtomicNumber(symbol));
    }

    public Element(String symbol, Integer atomicNumber) {
        this.symbol = symbol;
        this.atomicNumber = atomicNumber;
    }

    @Override
    public Integer getAtomicNumber() {
        return this.atomicNumber;
    }

    @Override
    public void setAtomicNumber(Integer atomicNumber) {
        this.atomicNumber = atomicNumber;
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    @Override
    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    @Override
    public String toString() {
        StringBuffer resultString = new StringBuffer(32);
        resultString.append("Element(").append(this.hashCode());
        if (this.getSymbol() != null) {
            resultString.append(", S:").append(this.getSymbol());
        }
        if (this.getID() != null) {
            resultString.append(", ID:").append(this.getID());
        }
        if (this.getAtomicNumber() != null) {
            resultString.append(", AN:").append(this.getAtomicNumber());
        }
        resultString.append(')');
        return resultString.toString();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public boolean compare(Object object) {
        if (!(object instanceof Element)) {
            return false;
        }
        if (!super.compare(object)) {
            return false;
        }
        Element elem = (Element)object;
        return Objects.equal(this.atomicNumber, elem.atomicNumber) && Objects.equal(this.symbol, elem.symbol);
    }
}

