/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.diff.tree;

import java.util.Iterator;
import javax.vecmath.Point3d;
import org.openscience.cdk.tools.diff.tree.AbstractDifferenceList;
import org.openscience.cdk.tools.diff.tree.DoubleDifference;
import org.openscience.cdk.tools.diff.tree.IDifference;
import org.openscience.cdk.tools.diff.tree.IDifferenceList;

public class Point3dDifference
extends AbstractDifferenceList
implements IDifferenceList {
    private String name;

    private Point3dDifference(String name) {
        this.name = name;
    }

    public static IDifference construct(String name, Point3d first, Point3d second) {
        if (first == null && second == null) {
            return null;
        }
        Point3dDifference totalDiff = new Point3dDifference(name);
        totalDiff.addChild(DoubleDifference.construct("x", first == null ? null : Double.valueOf(first.x), second == null ? null : Double.valueOf(second.x)));
        totalDiff.addChild(DoubleDifference.construct("y", first == null ? null : Double.valueOf(first.y), second == null ? null : Double.valueOf(second.y)));
        totalDiff.addChild(DoubleDifference.construct("z", first == null ? null : Double.valueOf(first.z), second == null ? null : Double.valueOf(second.z)));
        if (totalDiff.childCount() == 0) {
            return null;
        }
        return totalDiff;
    }

    public String toString() {
        if (this.differences.size() == 0) {
            return "";
        }
        StringBuffer diffBuffer = new StringBuffer();
        diffBuffer.append(this.name).append('{');
        Iterator<IDifference> children = this.getChildren().iterator();
        while (children.hasNext()) {
            diffBuffer.append(children.next().toString());
            if (!children.hasNext()) continue;
            diffBuffer.append(", ");
        }
        diffBuffer.append('}');
        return diffBuffer.toString();
    }
}

