/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.euclid;

import org.apache.log4j.Logger;
import org.xmlcml.euclid.EuclidConstants;
import org.xmlcml.euclid.EuclidRuntimeException;
import org.xmlcml.euclid.Real2;
import org.xmlcml.euclid.Real2Range;
import org.xmlcml.euclid.RealArray;
import org.xmlcml.euclid.Transform2;
import org.xmlcml.euclid.Util;

public class Real2Array
implements EuclidConstants {
    private static Logger LOG = Logger.getLogger(Real2Array.class);
    RealArray xarr;
    RealArray yarr;
    int nelem = 0;

    public Real2Array() {
    }

    public Real2Range getRange2() {
        Real2Range range = new Real2Range();
        for (int i = 0; i < this.nelem; ++i) {
            Real2 r2 = new Real2(this.xarr.elementAt(i), this.yarr.elementAt(i));
            range.add(r2);
        }
        return range;
    }

    public Real2Array(Real2Array r2a) {
        if (r2a != null && !r2a.equals(this)) {
            this.xarr = new RealArray(r2a.getXArray());
            this.yarr = new RealArray(r2a.getYArray());
            this.nelem = r2a.nelem;
        }
    }

    public Real2Array(RealArray x, RealArray y) throws EuclidRuntimeException {
        if (x.size() != y.size()) {
            throw new EuclidRuntimeException("incompatible array sizes " + x.size() + "/" + y.size());
        }
        this.nelem = x.size();
        this.xarr = (RealArray)x.clone();
        this.yarr = (RealArray)y.clone();
    }

    public void add(Real2 r2) {
        if (this.nelem == 0 || this.xarr == null || this.yarr == null) {
            this.xarr = new RealArray();
            this.yarr = new RealArray();
        }
        this.xarr.addElement(r2.getX());
        this.yarr.addElement(r2.getY());
        ++this.nelem;
    }

    public void add(Real2Array real2Array) {
        if (real2Array != null) {
            if (this.nelem == 0 || this.xarr == null || this.yarr == null) {
                this.xarr = new RealArray();
                this.yarr = new RealArray();
            }
            this.xarr.addArray(real2Array.xarr);
            this.yarr.addArray(real2Array.yarr);
            this.nelem += real2Array.size();
        }
    }

    public static Real2Array createFromPairs(String sss, String delimiter) {
        String[] ss;
        Real2Array real2Array = null;
        if (sss != null && (ss = sss.split(delimiter)).length % 2 == 0) {
            RealArray realArray = new RealArray(ss);
            real2Array = Real2Array.createFromPairs(realArray);
        }
        return real2Array;
    }

    public static Real2Array createFromPairs(RealArray ra) {
        if (ra == null) {
            throw new RuntimeException("Null RealArray");
        }
        if (ra.size() % 2 != 0) {
            throw new RuntimeException("Must have even number of points");
        }
        Real2Array real2Array = new Real2Array();
        real2Array.xarr = new RealArray();
        real2Array.yarr = new RealArray();
        int i = 0;
        while (i < ra.size()) {
            real2Array.xarr.addElement(ra.elementAt(i++));
            real2Array.yarr.addElement(ra.elementAt(i++));
            ++real2Array.nelem;
        }
        return real2Array;
    }

    public RealArray getXArray() {
        return this.xarr;
    }

    public RealArray getYArray() {
        return this.yarr;
    }

    public int size() {
        return this.nelem;
    }

    public Real2 elementAt(int elem) {
        return new Real2(this.xarr.elementAt(elem), this.yarr.elementAt(elem));
    }

    public Real2 get(int elem) {
        return new Real2(this.xarr.elementAt(elem), this.yarr.elementAt(elem));
    }

    public void setElement(int elem, Real2 r2) {
        this.xarr.setElementAt(elem, r2.getX());
        this.yarr.setElementAt(elem, r2.getY());
    }

    public void deleteElement(int i) {
        if (i >= 0 && i < this.nelem) {
            this.xarr.deleteElement(i);
            this.yarr.deleteElement(i);
            --this.nelem;
        } else {
            throw new EuclidRuntimeException("Cannt delete element at: " + i);
        }
    }

    public void transformBy(Transform2 t2) {
        for (int i = 0; i < this.nelem; ++i) {
            Real2 xy = this.get(i);
            xy.transformBy(t2);
            this.setElement(i, xy);
        }
    }

    public Real2Array format(int places) {
        double[] xarray = this.xarr.getArray();
        double[] yarray = this.yarr.getArray();
        for (int i = 0; i < this.nelem; ++i) {
            xarray[i] = Util.format(xarray[i], places);
            yarray[i] = Util.format(yarray[i], places);
        }
        return this;
    }

    public String getStringArray() {
        StringBuffer s = new StringBuffer();
        double[] xarray = this.xarr == null ? null : this.xarr.getArray();
        double[] yarray = this.yarr == null ? null : this.yarr.getArray();
        for (int i = 0; i < this.nelem; ++i) {
            if (i > 0) {
                s.append(" ");
            }
            s.append(xarray[i]);
            s.append(" ");
            s.append(yarray[i]);
        }
        return s.toString();
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        double[] xarray = this.xarr == null ? null : this.xarr.getArray();
        double[] yarray = this.yarr == null ? null : this.yarr.getArray();
        s.append("(");
        for (int i = 0; i < this.nelem; ++i) {
            s.append("(");
            s.append(xarray[i]);
            s.append(",");
            s.append(yarray[i]);
            s.append(")");
        }
        s.append(")");
        return s.toString();
    }
}

