/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.beam;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import uk.ac.ebi.beam.Atom;
import uk.ac.ebi.beam.AtomBuilder;
import uk.ac.ebi.beam.AtomImpl;
import uk.ac.ebi.beam.Bond;
import uk.ac.ebi.beam.Configuration;
import uk.ac.ebi.beam.Edge;
import uk.ac.ebi.beam.Element;
import uk.ac.ebi.beam.Graph;
import uk.ac.ebi.beam.Topology;

public final class GraphBuilder {
    private final Graph g;
    private final List<GeometricBuilder> builders = new ArrayList<GeometricBuilder>(2);
    private int[] valence;

    private GraphBuilder(int nAtoms) {
        this.g = new Graph(nAtoms);
        this.valence = new int[nAtoms];
    }

    public static GraphBuilder create(int n) {
        return new GraphBuilder(n);
    }

    public GraphBuilder add(Element e, int hCount) {
        return this.add(AtomBuilder.aliphatic(e).hydrogens(hCount).build());
    }

    public GraphBuilder add(Atom a) {
        if (this.g.order() >= this.valence.length) {
            this.valence = Arrays.copyOf(this.valence, this.valence.length * 2);
        }
        this.g.addAtom(a);
        return this;
    }

    public GraphBuilder add(Edge e) {
        Bond b = e.bond();
        int u = e.either();
        int v = e.other(u);
        if (!(b != Bond.SINGLE || this.g.atom(u).aromatic() && this.g.atom(v).aromatic())) {
            e.bond(Bond.IMPLICIT);
        } else if (b == Bond.AROMATIC && this.g.atom(u).aromatic() && this.g.atom(v).aromatic()) {
            e.bond(Bond.IMPLICIT);
        }
        this.g.addEdge(e);
        int n = u;
        this.valence[n] = this.valence[n] + b.order();
        int n2 = v;
        this.valence[n2] = this.valence[n2] + b.order();
        return this;
    }

    public GraphBuilder add(int u, int v) {
        this.add(u, v, Bond.IMPLICIT);
        return this;
    }

    public GraphBuilder add(int u, int v, Bond b) {
        this.add(b.edge(u, v));
        return this;
    }

    public GraphBuilder singleBond(int u, int v) {
        if (this.g.atom(u).aromatic() && this.g.atom(v).aromatic()) {
            return this.add(u, v, Bond.SINGLE);
        }
        return this.add(u, v, Bond.IMPLICIT);
    }

    public GraphBuilder aromaticBond(int u, int v) {
        if (this.g.atom(u).aromatic() && this.g.atom(v).aromatic()) {
            return this.add(u, v, Bond.IMPLICIT);
        }
        return this.add(u, v, Bond.AROMATIC);
    }

    public GraphBuilder doubleBond(int u, int v) {
        return this.add(u, v, Bond.DOUBLE);
    }

    public TetrahedralBuilder tetrahedral(int u) {
        return new TetrahedralBuilder(this, u);
    }

    public GeometricBuilder geometric(int u, int v) {
        return new GeometricBuilder(this, u, v);
    }

    public ExtendedTetrahedralBuilder extendedTetrahedral(int u) {
        return new ExtendedTetrahedralBuilder(this, u);
    }

    void topology(int u, Topology t) {
        this.g.addTopology(t);
        if (t != Topology.unknown()) {
            this.g.addFlags(2);
            if (t.configuration().type() == Configuration.Type.ExtendedTetrahedral) {
                this.g.addFlags(4);
            }
        }
    }

    private void assignLeftOverFlags() {
        for (int v = 0; v < this.g.order(); ++v) {
            if (!this.g.atom(v).aromatic()) continue;
            this.g.addFlags(1);
        }
    }

    private void assignDirectionalLabels() {
        int v;
        int u;
        if (this.builders.isEmpty()) {
            return;
        }
        BitSet pibonded = new BitSet();
        BitSet unspecified = new BitSet();
        HashSet<Edge> unspecEdges = new HashSet<Edge>();
        if (this.g.getFlags(8) != 0) {
            for (Edge edge : this.g.edges()) {
                if (!edge.bond().directional()) continue;
                edge.bond(Bond.IMPLICIT);
            }
        }
        for (Edge e : this.g.edges()) {
            u = e.either();
            v = e.other(u);
            if (e.bond().order() != 2 || this.g.degree(u) < 2 || this.g.degree(v) < 2) continue;
            unspecified.set(u);
            unspecified.set(v);
            pibonded.set(u);
            pibonded.set(v);
            unspecEdges.add(e);
        }
        for (GeometricBuilder builder : this.builders) {
            Bond second;
            this.g.addFlags(8);
            if (builder.c == Configuration.DoubleBond.UNSPECIFIED) continue;
            this.checkGeometricBuilder(builder);
            u = builder.u;
            v = builder.v;
            int x = builder.x;
            int y = builder.y;
            if (x == y) continue;
            unspecEdges.remove(this.g.edge(u, v));
            unspecified.clear(u);
            unspecified.clear(v);
            this.fix(this.g, u, v, pibonded);
            this.fix(this.g, v, u, pibonded);
            Bond first = this.firstDirectionalLabel(u, x, pibonded);
            Bond bond = second = builder.c == Configuration.DoubleBond.TOGETHER ? first : first.inverse();
            if (this.checkDirectionalAssignment(second, v, y, pibonded)) {
                this.g.replace(this.g.edge(u, x), new Edge(u, x, first));
                this.g.replace(this.g.edge(v, y), new Edge(v, y, second));
            } else if (this.checkDirectionalAssignment(first.inverse(), u, x, pibonded)) {
                first = first.inverse();
                this.g.replace(this.g.edge(u, x), new Edge(u, x, first));
                second = second.inverse();
                this.g.replace(this.g.edge(v, y), new Edge(v, y, second));
            } else {
                BitSet visited = new BitSet();
                visited.set(v);
                this.invertExistingDirectionalLabels(pibonded, visited, v, u);
                if (!this.checkDirectionalAssignment(first, u, x, pibonded) || !this.checkDirectionalAssignment(second, v, y, pibonded)) {
                    throw new IllegalArgumentException("cannot assign geometric configuration");
                }
                this.g.replace(this.g.edge(u, x), new Edge(u, x, first));
                this.g.replace(this.g.edge(v, y), new Edge(v, y, second));
            }
            for (Edge e : this.g.edges(u)) {
                if (e.bond() == Bond.DOUBLE || e.bond().directional()) continue;
                e.bond(e.either() == u ? first.inverse() : first);
            }
            for (Edge e : this.g.edges(v)) {
                if (e.bond() == Bond.DOUBLE || e.bond().directional()) continue;
                e.bond(e.either() == v ? second.inverse() : second);
            }
        }
        for (Edge unspecEdge : unspecEdges) {
            u = unspecEdge.either();
            v = unspecEdge.other(u);
            if (!this.hasDirectional(this.g, u) || !this.hasDirectional(this.g, v)) continue;
            for (Edge e : this.g.edges(u)) {
                if (!this.isRedundantDirectionalEdge(this.g, e, unspecified)) continue;
                e.bond(Bond.IMPLICIT);
            }
            if (!this.hasDirectional(this.g, u)) continue;
            for (Edge e : this.g.edges(v)) {
                if (!this.isRedundantDirectionalEdge(this.g, e, unspecified)) continue;
                e.bond(Bond.IMPLICIT);
            }
        }
    }

    private boolean hasDirectional(Graph g, int v) {
        for (Edge e : g.edges(v)) {
            if (!e.bond().directional()) continue;
            return true;
        }
        return false;
    }

    private boolean isRedundantDirectionalEdge(Graph g, Edge edge, BitSet unspecified) {
        block4: {
            int v;
            block3: {
                if (!edge.bond().directional()) {
                    return false;
                }
                int u = edge.either();
                v = edge.other(u);
                if (unspecified.get(u)) break block3;
                for (Edge f : g.edges(u)) {
                    if (!f.bond().directional() || edge == f) continue;
                    return true;
                }
                break block4;
            }
            if (unspecified.get(v)) break block4;
            for (Edge f : g.edges(v)) {
                if (!f.bond().directional() || edge == f) continue;
                return true;
            }
        }
        return false;
    }

    private void fix(Graph g, int u, int p, BitSet adjToDb) {
        Bond other = null;
        for (Edge e : g.edges(u)) {
            Bond bond = e.bond(u);
            if (!bond.directional()) continue;
            if (other != null && other == bond) {
                BitSet visited = new BitSet();
                visited.set(p);
                visited.set(e.other(u));
                this.invertExistingDirectionalLabels(adjToDb, visited, u, p);
            }
            other = bond;
        }
    }

    private void invertExistingDirectionalLabels(BitSet adjToDb, BitSet visited, int u, int p) {
        visited.set(u);
        for (Edge e : this.g.edges(u)) {
            int v = e.other(u);
            if (visited.get(v) || p == v) continue;
            this.g.replace(e, e.inverse());
            if (!adjToDb.get(v)) continue;
            this.invertExistingDirectionalLabels(adjToDb, visited, v, u);
        }
    }

    private Bond firstDirectionalLabel(int u, int x, BitSet adjToDb) {
        Edge e = this.g.edge(u, x);
        Bond b = e.bond(u);
        if (adjToDb.get(x) && this.g.degree(x) > 2) {
            for (Edge f : this.g.edges(x)) {
                if (f.other(x) == u || f.bond() == Bond.DOUBLE || !f.bond().directional()) continue;
                return f.bond(x);
            }
        }
        if (this.g.degree(u) > 2) {
            for (Edge f : this.g.edges(u)) {
                if (f.other(u) == x || f.bond() == Bond.DOUBLE || !f.bond().directional()) continue;
                return f.bond(u).inverse();
            }
        }
        return b.directional() ? b : Bond.DOWN;
    }

    private boolean checkDirectionalAssignment(Bond b, int u, int v, BitSet adjToDb) {
        for (Edge e : this.g.edges(u)) {
            int x = e.other(u);
            Bond existing = e.bond(u);
            if (!existing.directional() || !(x != v ? existing == b : existing != b)) continue;
            return false;
        }
        return true;
    }

    private void checkGeometricBuilder(GeometricBuilder builder) {
        if (!(this.g.adjacent(builder.u, builder.x) && this.g.adjacent(builder.u, builder.v) && this.g.adjacent(builder.v, builder.y))) {
            throw new IllegalArgumentException("cannot assign directional labels, vertices were not adjacentwhere not adjacent - expected topology of 'x-u=v-y' where x=" + builder.x + " u=" + builder.u + " v=" + builder.v + " y=" + builder.y);
        }
        Edge db = this.g.edge(builder.u, builder.v);
        if (db.bond() != Bond.DOUBLE) {
            throw new IllegalArgumentException("cannot assign double bond configuration to non-double bond");
        }
    }

    private void suppress() {
        for (int v = 0; v < this.g.order(); ++v) {
            Atom atom;
            if (this.g.topologyOf(v).type() != Configuration.Type.None || !this.suppressible(atom = this.g.atom(v), this.valence[v])) continue;
            this.g.setAtom(v, this.toSubset(atom));
        }
    }

    private Atom toSubset(Atom a) {
        if (a.aromatic()) {
            return AtomImpl.AromaticSubset.ofElement(a.element());
        }
        return AtomImpl.AliphaticSubset.ofElement(a.element());
    }

    private boolean suppressible(Atom a, int v) {
        if (!a.subset() && a.element().organic() && a.isotope() < 0 && a.charge() == 0 && a.atomClass() == 0) {
            int h = a.hydrogens();
            if (a.aromatic()) {
                return h == a.element().aromaticImplicitHydrogens(1 + v);
            }
            return h == a.element().implicitHydrogens(v);
        }
        return false;
    }

    public Graph build() {
        this.suppress();
        this.assignDirectionalLabels();
        return this.g;
    }

    public static final class GeometricBuilder {
        final GraphBuilder gb;
        final int u;
        final int v;
        int x;
        int y;
        Configuration.DoubleBond c;

        public GeometricBuilder(GraphBuilder gb, int u, int v) {
            this.gb = gb;
            this.u = u;
            this.v = v;
        }

        public GraphBuilder together(int x, int y) {
            return this.configure(x, y, Configuration.DoubleBond.TOGETHER);
        }

        public GraphBuilder opposite(int x, int y) {
            return this.configure(x, y, Configuration.DoubleBond.OPPOSITE);
        }

        public GraphBuilder configure(int x, int y, Configuration.DoubleBond c) {
            this.x = x;
            this.y = y;
            this.c = c;
            this.gb.builders.add(this);
            return this.gb;
        }

        public String toString() {
            return this.x + "/" + this.u + "=" + this.v + (this.c == Configuration.DoubleBond.TOGETHER ? "\\" : "/") + this.y;
        }
    }

    public static final class ExtendedTetrahedralBuilder {
        final GraphBuilder gb;
        final int u;
        int v;
        int[] vs;
        Configuration config;

        private ExtendedTetrahedralBuilder(GraphBuilder gb, int u) {
            this.gb = gb;
            this.u = u;
        }

        public ExtendedTetrahedralBuilder lookingFrom(int v) {
            this.v = v;
            return this;
        }

        public ExtendedTetrahedralBuilder neighbors(int[] vs) {
            if (vs.length != 3) {
                throw new IllegalArgumentException("3 vertex required for tetrahedral centre");
            }
            this.vs = vs;
            return this;
        }

        public ExtendedTetrahedralBuilder neighbors(int u, int v, int w) {
            return this.neighbors(new int[]{u, v, w});
        }

        public ExtendedTetrahedralBuilder parity(int p) {
            if (p < 0) {
                return this.winding(Configuration.AL1);
            }
            if (p > 0) {
                return this.winding(Configuration.AL2);
            }
            throw new IllegalArgumentException("parity must be < 0 or > 0");
        }

        public ExtendedTetrahedralBuilder winding(Configuration c) {
            this.config = c;
            return this;
        }

        public GraphBuilder build() {
            if (this.config == null) {
                throw new IllegalArgumentException("no configuration defined");
            }
            if (this.vs == null) {
                throw new IllegalArgumentException("no neighbors defined");
            }
            if (this.gb.g.degree(this.u) != 2) {
                throw new IllegalArgumentException("extended tetrahedral atom needs exactly 2 neighbors");
            }
            Topology t = Topology.extendedTetrahedral(this.u, new int[]{this.v, this.vs[0], this.vs[1], this.vs[2]}, this.config);
            this.gb.topology(this.u, t);
            return this.gb;
        }
    }

    public static final class TetrahedralBuilder {
        final GraphBuilder gb;
        final int u;
        int v;
        int[] vs;
        Configuration config;

        private TetrahedralBuilder(GraphBuilder gb, int u) {
            this.gb = gb;
            this.u = u;
        }

        public TetrahedralBuilder lookingFrom(int v) {
            this.v = v;
            return this;
        }

        public TetrahedralBuilder neighbors(int[] vs) {
            if (vs.length != 3) {
                throw new IllegalArgumentException("3 vertex required for tetrahedral centre");
            }
            this.vs = vs;
            return this;
        }

        public TetrahedralBuilder neighbors(int u, int v, int w) {
            return this.neighbors(new int[]{u, v, w});
        }

        public TetrahedralBuilder parity(int p) {
            if (p < 0) {
                return this.winding(Configuration.TH1);
            }
            if (p > 0) {
                return this.winding(Configuration.TH2);
            }
            throw new IllegalArgumentException("parity must be < 0 or > 0");
        }

        public TetrahedralBuilder winding(Configuration c) {
            this.config = c;
            return this;
        }

        public GraphBuilder build() {
            if (this.config == null) {
                throw new IllegalArgumentException("no configuration defined");
            }
            if (this.vs == null) {
                throw new IllegalArgumentException("no neighbors defined");
            }
            Topology t = Topology.tetrahedral(this.u, new int[]{this.v, this.vs[0], this.vs[1], this.vs[2]}, this.config);
            this.gb.topology(this.u, t);
            return this.gb;
        }
    }
}

