/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.fingerprint;

import java.util.BitSet;
import org.openscience.cdk.fingerprint.IBitFingerprint;

public class BitSetFingerprint
implements IBitFingerprint {
    private static final long serialVersionUID = 9034774011095165227L;
    private BitSet bitset;

    public BitSetFingerprint(BitSet bitset) {
        this.bitset = bitset;
    }

    public BitSetFingerprint() {
        this.bitset = new BitSet();
    }

    public BitSetFingerprint(int size) {
        this.bitset = new BitSet(size);
    }

    public BitSetFingerprint(IBitFingerprint fingerprint) {
        if (fingerprint instanceof BitSetFingerprint) {
            this.bitset = (BitSet)((BitSetFingerprint)fingerprint).bitset.clone();
        } else {
            BitSet bitSet = new BitSet();
            int i = 0;
            while ((long)i < fingerprint.size()) {
                bitSet.set(i, fingerprint.get(i));
                ++i;
            }
            this.bitset = bitSet;
        }
    }

    @Override
    public int cardinality() {
        return this.bitset.cardinality();
    }

    @Override
    public long size() {
        return this.bitset.size();
    }

    @Override
    public void and(IBitFingerprint fingerprint) {
        if ((long)this.bitset.size() != fingerprint.size()) {
            throw new IllegalArgumentException("Fingerprints must have same size");
        }
        if (fingerprint instanceof BitSetFingerprint) {
            this.bitset.and(((BitSetFingerprint)fingerprint).bitset);
        } else {
            for (int i = 0; i < this.bitset.size(); ++i) {
                this.bitset.set(i, this.bitset.get(i) && fingerprint.get(i));
            }
        }
    }

    @Override
    public void or(IBitFingerprint fingerprint) {
        if ((long)this.bitset.size() != fingerprint.size()) {
            throw new IllegalArgumentException("Fingerprints must have same size");
        }
        if (fingerprint instanceof BitSetFingerprint) {
            this.bitset.or(((BitSetFingerprint)fingerprint).bitset);
        } else {
            for (int i = 0; i < this.bitset.size(); ++i) {
                this.bitset.set(i, this.bitset.get(i) || fingerprint.get(i));
            }
        }
    }

    @Override
    public boolean get(int index) {
        return this.bitset.get(index);
    }

    @Override
    public void set(int index, boolean b) {
        this.bitset.set(index, b);
    }

    @Override
    public BitSet asBitSet() {
        return (BitSet)this.bitset.clone();
    }

    @Override
    public void set(int i) {
        this.bitset.set(i);
    }

    public int hashCode() {
        return this.bitset.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BitSetFingerprint other = (BitSetFingerprint)obj;
        return !(this.bitset == null ? other.bitset != null : !this.bitset.equals(other.bitset));
    }

    @Override
    public int[] getSetbits() {
        int[] result = new int[this.bitset.cardinality()];
        int index = 0;
        for (int i = 0; i < this.bitset.length(); ++i) {
            if (!this.bitset.get(i)) continue;
            result[index++] = i;
        }
        return result;
    }
}

