/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.fingerprint;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Map;
import org.openscience.cdk.fingerprint.IBitFingerprint;

public class IntArrayFingerprint
implements IBitFingerprint {
    private static final long serialVersionUID = 5175105019921245323L;
    private volatile int[] trueBits;

    public IntArrayFingerprint(Map<String, Integer> rawFingerPrint) {
        this.trueBits = new int[rawFingerPrint.size()];
        int i = 0;
        for (String key : rawFingerPrint.keySet()) {
            this.trueBits[i++] = key.hashCode();
        }
        Arrays.sort(this.trueBits);
    }

    public IntArrayFingerprint(int[] setBits) {
        this.trueBits = setBits;
    }

    public IntArrayFingerprint() {
        this.trueBits = new int[0];
    }

    public IntArrayFingerprint(IBitFingerprint fingerprint) {
        if (fingerprint instanceof IntArrayFingerprint) {
            IntArrayFingerprint iaFP = (IntArrayFingerprint)fingerprint;
            this.trueBits = new int[iaFP.trueBits.length];
            System.arraycopy(iaFP.trueBits, 0, this.trueBits, 0, this.trueBits.length);
        } else {
            this.trueBits = new int[fingerprint.cardinality()];
            int index = 0;
            int i = 0;
            while ((long)i < fingerprint.size()) {
                if (fingerprint.get(i)) {
                    this.trueBits[index++] = i;
                }
                ++i;
            }
        }
    }

    @Override
    public int cardinality() {
        return this.trueBits.length;
    }

    @Override
    public long size() {
        return 0x100000000L;
    }

    @Override
    public void and(IBitFingerprint fingerprint) {
        if (!(fingerprint instanceof IntArrayFingerprint)) {
            throw new UnsupportedOperationException("AND on IntArrayFingerPrint only supported for other IntArrayFingerPrints for the moment");
        }
        this.and((IntArrayFingerprint)fingerprint);
    }

    public void and(IntArrayFingerprint fingerprint) {
        ArrayList<Integer> tmp = new ArrayList<Integer>();
        int i = 0;
        int j = 0;
        while (i < this.trueBits.length && j < fingerprint.trueBits.length) {
            int local = this.trueBits[i];
            int remote = fingerprint.trueBits[j];
            if (local == remote) {
                tmp.add(local);
                ++i;
                ++j;
                continue;
            }
            if (local < remote) {
                ++i;
                continue;
            }
            ++j;
        }
        this.trueBits = new int[tmp.size()];
        i = 0;
        for (Integer t : tmp) {
            this.trueBits[i] = t;
        }
        Arrays.sort(this.trueBits);
    }

    @Override
    public void or(IBitFingerprint fingerprint) {
        if (!(fingerprint instanceof IntArrayFingerprint)) {
            throw new UnsupportedOperationException("OR on IntArrayFingerPrint only supported for other IntArrayFingerPrints for the moment");
        }
        this.or((IntArrayFingerprint)fingerprint);
    }

    public void or(IntArrayFingerprint fingerprint) {
        int i;
        HashSet<Integer> tmp = new HashSet<Integer>();
        for (int trueBit : this.trueBits) {
            tmp.add(trueBit);
        }
        for (i = 0; i < fingerprint.trueBits.length; ++i) {
            tmp.add(fingerprint.trueBits[i]);
        }
        this.trueBits = new int[tmp.size()];
        i = 0;
        for (Integer t : tmp) {
            this.trueBits[i++] = t;
        }
        Arrays.sort(this.trueBits);
    }

    @Override
    public boolean get(int index) {
        return Arrays.binarySearch(this.trueBits, index) >= 0;
    }

    @Override
    public void set(int index, boolean value) {
        int i = Arrays.binarySearch(this.trueBits, index);
        if (i >= 0 && !value) {
            int[] tmp = new int[this.trueBits.length - 1];
            System.arraycopy(this.trueBits, 0, tmp, 0, i);
            System.arraycopy(this.trueBits, i + 1, tmp, i, this.trueBits.length - i - 1);
            this.trueBits = tmp;
        } else if (i < 0 && value) {
            int[] tmp = new int[this.trueBits.length + 1];
            System.arraycopy(this.trueBits, 0, tmp, 0, this.trueBits.length);
            tmp[tmp.length - 1] = index;
            this.trueBits = tmp;
            Arrays.sort(this.trueBits);
        }
    }

    @Override
    public BitSet asBitSet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(int i) {
        this.set(i, true);
    }

    public int hashCode() {
        return Arrays.hashCode(this.trueBits);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IntArrayFingerprint other = (IntArrayFingerprint)obj;
        return Arrays.equals(this.trueBits, other.trueBits);
    }

    @Override
    public int[] getSetbits() {
        int[] copy = new int[this.trueBits.length];
        System.arraycopy(this.trueBits, 0, copy, 0, this.trueBits.length);
        return copy;
    }
}

