/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.atomic;

import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.ShortestPaths;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.qsar.AbstractAtomicDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IAtomicDescriptor;
import org.openscience.cdk.qsar.result.IntegerResult;

public class BondsToAtomDescriptor
extends AbstractAtomicDescriptor
implements IAtomicDescriptor {
    private int focusPosition = 0;

    @Override
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#bondsToAtom", this.getClass().getName(), "The Chemistry Development Kit");
    }

    @Override
    public void setParameters(Object[] params) throws CDKException {
        if (params.length > 1) {
            throw new CDKException("BondsToAtomDescriptor only expects one parameters");
        }
        if (!(params[0] instanceof Integer)) {
            throw new CDKException("The parameter must be of type Integer");
        }
        this.focusPosition = (Integer)params[0];
    }

    @Override
    public Object[] getParameters() {
        Object[] params = new Object[]{this.focusPosition};
        return params;
    }

    @Override
    public String[] getDescriptorNames() {
        return new String[]{"bondsToAtom"};
    }

    @Override
    public DescriptorValue calculate(IAtom atom, IAtomContainer container) {
        IAtom focus = container.getAtom(this.focusPosition);
        int bondsToAtom = new ShortestPaths(container, atom).distanceTo(focus);
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new IntegerResult(bondsToAtom), this.getDescriptorNames());
    }

    @Override
    public String[] getParameterNames() {
        String[] params = new String[]{"focusPosition"};
        return params;
    }

    @Override
    public Object getParameterType(String name) {
        return 0;
    }
}

