/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smsd.algorithm.mcsplus;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.smsd.algorithm.matchers.DefaultBondMatcher;
import org.openscience.cdk.smsd.algorithm.matchers.DefaultMCSPlusAtomMatcher;
import org.openscience.cdk.smsd.algorithm.matchers.DefaultMatcher;
import org.openscience.cdk.smsd.helper.LabelContainer;

@Deprecated
public final class GenerateCompatibilityGraph {
    private List<Integer> compGraphNodes = null;
    private List<Integer> compGraphNodesCZero = null;
    private List<Integer> cEdges = null;
    private List<Integer> dEdges = null;
    private int cEdgesSize = 0;
    private int dEdgesSize = 0;
    private IAtomContainer source = null;
    private IAtomContainer target = null;
    private boolean shouldMatchBonds = false;

    public GenerateCompatibilityGraph() {
    }

    public GenerateCompatibilityGraph(IAtomContainer source, IAtomContainer target, boolean shouldMatchBonds) throws IOException {
        this.setMatchBond(shouldMatchBonds);
        this.source = source;
        this.target = target;
        this.compGraphNodes = new ArrayList<Integer>();
        this.compGraphNodesCZero = new ArrayList<Integer>();
        this.cEdges = new ArrayList<Integer>();
        this.dEdges = new ArrayList<Integer>();
        this.compatibilityGraphNodes();
        this.compatibilityGraph();
        if (this.getCEdgesSize() == 0) {
            this.clearCompGraphNodes();
            this.clearCEgdes();
            this.clearDEgdes();
            this.resetCEdgesSize();
            this.resetDEdgesSize();
            this.compatibilityGraphNodesIfCEdgeIsZero();
            this.compatibilityGraphCEdgeZero();
            this.clearCompGraphNodesCZero();
        }
    }

    private List<List<Integer>> labelAtoms(IAtomContainer atomCont) {
        ArrayList<List<Integer>> labelList = new ArrayList<List<Integer>>();
        for (int i = 0; i < atomCont.getAtomCount(); ++i) {
            LabelContainer labelContainer = LabelContainer.getInstance();
            ArrayList<Integer> label = new ArrayList<Integer>(7);
            for (int a = 0; a < 7; ++a) {
                label.add(a, 0);
            }
            IAtom refAtom = atomCont.getAtom(i);
            String atom1Type = refAtom.getSymbol();
            label.set(0, labelContainer.getLabelID(atom1Type));
            int countNeighbors = 1;
            List<IAtom> connAtoms = atomCont.getConnectedAtomsList(refAtom);
            for (IAtom negAtom : connAtoms) {
                String atom2Type = negAtom.getSymbol();
                label.set(countNeighbors++, labelContainer.getLabelID(atom2Type));
            }
            this.bubbleSort(label);
            labelList.add(label);
        }
        return labelList;
    }

    private void bubbleSort(List<Integer> label) {
        boolean flag = true;
        for (int i = 0; i < 7 && flag; ++i) {
            flag = false;
            for (int j = 0; j < 6; ++j) {
                if (label.get(i) <= label.get(j + 1)) continue;
                int temp = label.get(i);
                label.set(i, label.get(j + 1));
                label.set(j + 1, temp);
                flag = true;
            }
        }
    }

    private List<IAtom> reduceAtomSet(IAtomContainer atomCont) {
        ArrayList<IAtom> basicAtoms = new ArrayList<IAtom>();
        for (IAtom atom : atomCont.atoms()) {
            basicAtoms.add(atom);
        }
        return basicAtoms;
    }

    protected int compatibilityGraphNodes() throws IOException {
        this.compGraphNodes.clear();
        List<IAtom> basicAtomVecA = null;
        List<IAtom> basicAtomVecB = null;
        IAtomContainer reactant = this.source;
        IAtomContainer product = this.target;
        basicAtomVecA = this.reduceAtomSet(reactant);
        basicAtomVecB = this.reduceAtomSet(product);
        List<List<Integer>> labelListMolA = this.labelAtoms(reactant);
        List<List<Integer>> labelListMolB = this.labelAtoms(product);
        int molANodes = 0;
        int countNodes = 1;
        for (List<Integer> labelA : labelListMolA) {
            int molBNodes = 0;
            for (List<Integer> labelB : labelListMolB) {
                if (labelA.equals(labelB)) {
                    this.compGraphNodes.add(reactant.indexOf(basicAtomVecA.get(molANodes)));
                    this.compGraphNodes.add(product.indexOf(basicAtomVecB.get(molBNodes)));
                    this.compGraphNodes.add(countNodes++);
                }
                ++molBNodes;
            }
            ++molANodes;
        }
        return 0;
    }

    protected int compatibilityGraph() throws IOException {
        int compGraphNodesListSize = this.compGraphNodes.size();
        this.cEdges = new ArrayList<Integer>();
        this.dEdges = new ArrayList<Integer>();
        for (int a = 0; a < compGraphNodesListSize; a += 3) {
            int indexA = this.compGraphNodes.get(a);
            int indexAPlus1 = this.compGraphNodes.get(a + 1);
            for (int b = a + 3; b < compGraphNodesListSize; b += 3) {
                int indexB = this.compGraphNodes.get(b);
                int indexBPlus1 = this.compGraphNodes.get(b + 1);
                if (a == b || indexA == indexB || indexAPlus1 == indexBPlus1) continue;
                IBond reactantBond = null;
                IBond productBond = null;
                reactantBond = this.source.getBond(this.source.getAtom(indexA), this.source.getAtom(indexB));
                productBond = this.target.getBond(this.target.getAtom(indexAPlus1), this.target.getAtom(indexBPlus1));
                if (reactantBond == null || productBond == null) continue;
                this.addEdges(reactantBond, productBond, a, b);
            }
        }
        this.cEdgesSize = this.cEdges.size();
        this.dEdgesSize = this.dEdges.size();
        return 0;
    }

    private void addEdges(IBond reactantBond, IBond productBond, int iIndex, int jIndex) {
        if (GenerateCompatibilityGraph.isMatchFeasible(this.source, reactantBond, this.target, productBond, this.shouldMatchBonds)) {
            this.cEdges.add(iIndex / 3 + 1);
            this.cEdges.add(jIndex / 3 + 1);
        } else if (reactantBond == null && productBond == null) {
            this.dEdges.add(iIndex / 3 + 1);
            this.dEdges.add(jIndex / 3 + 1);
        }
    }

    protected Integer compatibilityGraphNodesIfCEdgeIsZero() throws IOException {
        int countNodes = 1;
        ArrayList<String> map = new ArrayList<String>();
        this.compGraphNodesCZero = new ArrayList<Integer>();
        LabelContainer labelContainer = LabelContainer.getInstance();
        this.compGraphNodes.clear();
        for (int i = 0; i < this.source.getAtomCount(); ++i) {
            for (int j = 0; j < this.target.getAtomCount(); ++j) {
                IAtom atom1 = this.source.getAtom(i);
                IAtom atom2 = this.target.getAtom(j);
                if (!atom1.getSymbol().equalsIgnoreCase(atom2.getSymbol()) || map.contains(i + "_" + j)) continue;
                this.compGraphNodesCZero.add(i);
                this.compGraphNodesCZero.add(j);
                this.compGraphNodesCZero.add(labelContainer.getLabelID(atom1.getSymbol()));
                this.compGraphNodesCZero.add(countNodes);
                this.compGraphNodes.add(i);
                this.compGraphNodes.add(j);
                this.compGraphNodes.add(countNodes++);
                map.add(i + "_" + j);
            }
        }
        map.clear();
        return countNodes;
    }

    protected int compatibilityGraphCEdgeZero() throws IOException {
        int compGraphNodesCZeroListSize = this.compGraphNodesCZero.size();
        this.cEdges = new ArrayList<Integer>();
        this.dEdges = new ArrayList<Integer>();
        for (int a = 0; a < compGraphNodesCZeroListSize; a += 4) {
            int indexA = this.compGraphNodesCZero.get(a);
            int indexAPlus1 = this.compGraphNodesCZero.get(a + 1);
            for (int b = a + 4; b < compGraphNodesCZeroListSize; b += 4) {
                int indexB = this.compGraphNodesCZero.get(b);
                int indexBPlus1 = this.compGraphNodesCZero.get(b + 1);
                if (a == b || indexA == indexB || indexAPlus1 == indexBPlus1) continue;
                IBond reactantBond = null;
                IBond productBond = null;
                reactantBond = this.source.getBond(this.source.getAtom(indexA), this.source.getAtom(indexB));
                productBond = this.target.getBond(this.target.getAtom(indexAPlus1), this.target.getAtom(indexBPlus1));
                if (reactantBond == null || productBond == null) continue;
                this.addCZeroEdges(reactantBond, productBond, a, b);
            }
        }
        this.cEdgesSize = this.cEdges.size();
        this.dEdgesSize = this.dEdges.size();
        return 0;
    }

    private void addCZeroEdges(IBond reactantBond, IBond productBond, int indexI, int indexJ) {
        if (GenerateCompatibilityGraph.isMatchFeasible(this.source, reactantBond, this.target, productBond, this.shouldMatchBonds)) {
            this.cEdges.add(indexI / 4 + 1);
            this.cEdges.add(indexJ / 4 + 1);
        }
        if (reactantBond == null && productBond == null) {
            this.dEdges.add(indexI / 4 + 1);
            this.dEdges.add(indexJ / 4 + 1);
        }
    }

    private static boolean isMatchFeasible(IAtomContainer ac1, IBond bondA1, IAtomContainer ac2, IBond bondA2, boolean shouldMatchBonds) {
        DefaultBondMatcher bondMatcher = new DefaultBondMatcher(ac1, bondA1, shouldMatchBonds);
        DefaultMCSPlusAtomMatcher atomMatcher1 = new DefaultMCSPlusAtomMatcher(ac1, bondA1.getBegin(), shouldMatchBonds);
        DefaultMCSPlusAtomMatcher atomMatcher2 = new DefaultMCSPlusAtomMatcher(ac1, bondA1.getEnd(), shouldMatchBonds);
        return DefaultMatcher.isBondMatch(bondMatcher, ac2, bondA2, shouldMatchBonds) && DefaultMatcher.isAtomMatch(atomMatcher1, atomMatcher2, ac2, bondA2, shouldMatchBonds);
    }

    public List<Integer> getCEgdes() {
        return Collections.unmodifiableList(this.cEdges);
    }

    protected List<Integer> getDEgdes() {
        return Collections.unmodifiableList(this.dEdges);
    }

    protected List<Integer> getCompGraphNodes() {
        return Collections.unmodifiableList(this.compGraphNodes);
    }

    protected int getCEdgesSize() {
        return this.cEdgesSize;
    }

    protected int getDEdgesSize() {
        return this.dEdgesSize;
    }

    protected List<Integer> getCompGraphNodesCZero() {
        return this.compGraphNodesCZero;
    }

    protected void clearCEgdes() {
        this.cEdges.clear();
    }

    protected void clearDEgdes() {
        this.dEdges.clear();
    }

    protected void clearCompGraphNodes() {
        this.compGraphNodes.clear();
    }

    protected void clearCompGraphNodesCZero() {
        this.compGraphNodesCZero.clear();
    }

    protected void resetCEdgesSize() {
        this.cEdgesSize = 0;
    }

    protected void resetDEdgesSize() {
        this.dEdgesSize = 0;
    }

    public void clear() {
        this.cEdges = null;
        this.dEdges = null;
        this.compGraphNodes = null;
        this.compGraphNodesCZero = null;
    }

    public boolean isMatchBond() {
        return this.shouldMatchBonds;
    }

    public void setMatchBond(boolean shouldMatchBonds) {
        this.shouldMatchBonds = shouldMatchBonds;
    }
}

