/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.stereo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;
import org.openscience.cdk.graph.Cycles;
import org.openscience.cdk.graph.GraphUtil;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IDoubleBondStereochemistry;
import org.openscience.cdk.interfaces.IStereoElement;
import org.openscience.cdk.interfaces.ITetrahedralChirality;
import org.openscience.cdk.stereo.Atropisomeric;
import org.openscience.cdk.stereo.CyclicCarbohydrateRecognition;
import org.openscience.cdk.stereo.DoubleBondStereochemistry;
import org.openscience.cdk.stereo.ExtendedCisTrans;
import org.openscience.cdk.stereo.ExtendedTetrahedral;
import org.openscience.cdk.stereo.FischerRecognition;
import org.openscience.cdk.stereo.Projection;
import org.openscience.cdk.stereo.Stereocenters;
import org.openscience.cdk.stereo.TetrahedralChirality;

public abstract class StereoElementFactory {
    protected final IAtomContainer container;
    protected final int[][] graph;
    protected final GraphUtil.EdgeToBondMap bondMap;
    protected final Set<Projection> projections = EnumSet.noneOf(Projection.class);
    private boolean check = false;

    protected StereoElementFactory(IAtomContainer container, int[][] graph, GraphUtil.EdgeToBondMap bondMap) {
        this.container = container;
        this.graph = graph;
        this.bondMap = bondMap;
    }

    private boolean visitSmallRing(int[] mark, int aidx, int prev, int depth, int max) {
        if (mark[aidx] == 2) {
            return true;
        }
        if (depth == max) {
            return false;
        }
        if (mark[aidx] == 1) {
            return false;
        }
        mark[aidx] = 1;
        for (int nbr : this.graph[aidx]) {
            if (nbr == prev || !this.visitSmallRing(mark, nbr, aidx, depth + 1, max)) continue;
            return true;
        }
        mark[aidx] = 0;
        return false;
    }

    private boolean isInSmallRing(IBond bond, int max) {
        if (!bond.isInRing()) {
            return false;
        }
        IAtom beg = bond.getBegin();
        IAtom end = bond.getEnd();
        int[] mark = new int[this.container.getAtomCount()];
        int bidx = this.container.indexOf(beg);
        int eidx = this.container.indexOf(end);
        mark[bidx] = 2;
        return this.visitSmallRing(mark, eidx, bidx, 1, max);
    }

    private boolean isInSmallRing(IAtom atom, int max) {
        if (!atom.isInRing()) {
            return false;
        }
        for (IBond bond : this.container.getConnectedBondsList(atom)) {
            if (!this.isInSmallRing(bond, max)) continue;
            return true;
        }
        return false;
    }

    private IBond getOtherDb(IAtom a, IBond other) {
        IBond result = null;
        for (IBond bond : this.container.getConnectedBondsList(a)) {
            if (bond.equals(other) || bond.getOrder() != IBond.Order.DOUBLE) continue;
            if (result != null) {
                return null;
            }
            result = bond;
        }
        return result;
    }

    private static IAtom getShared(IBond a, IBond b) {
        if (b.contains(a.getBegin())) {
            return a.getBegin();
        }
        if (b.contains(a.getEnd())) {
            return a.getEnd();
        }
        return null;
    }

    private List<IBond> getCumulatedDbs(IBond endBond) {
        ArrayList<IBond> dbs = new ArrayList<IBond>();
        dbs.add(endBond);
        IBond other = this.getOtherDb(endBond.getBegin(), endBond);
        if (other == null) {
            other = this.getOtherDb(endBond.getEnd(), endBond);
        }
        if (other == null) {
            return null;
        }
        while (other != null) {
            dbs.add(other);
            IAtom a = StereoElementFactory.getShared((IBond)dbs.get(dbs.size() - 1), (IBond)dbs.get(dbs.size() - 2));
            other = this.getOtherDb(other.getOther(a), other);
        }
        return dbs;
    }

    public List<IStereoElement> createAll() {
        IStereoElement<IBond, IBond> element;
        int v;
        Cycles.markRingAtomsAndBonds(this.container);
        Stereocenters centers = new Stereocenters(this.container, this.graph, this.bondMap);
        if (this.check) {
            centers.checkSymmetry();
        }
        ArrayList<IStereoElement> elements = new ArrayList<IStereoElement>();
        FischerRecognition fischerRecon = new FischerRecognition(this.container, this.graph, this.bondMap, centers);
        CyclicCarbohydrateRecognition cycleRecon = new CyclicCarbohydrateRecognition(this.container, this.graph, this.bondMap, centers);
        elements.addAll(fischerRecon.recognise(this.projections));
        elements.addAll(cycleRecon.recognise(this.projections));
        block8: for (v = 0; v < this.graph.length; ++v) {
            switch (centers.elementType(v)) {
                case Bicoordinate: {
                    for (int w : this.graph[v]) {
                        List<IBond> dbs;
                        if (centers.elementType(w) != Stereocenters.Type.Tricoordinate || (dbs = this.getCumulatedDbs(this.container.getBond(this.container.getAtom(w), this.container.getAtom(v)))) == null || this.container.indexOf(dbs.get(0)) > this.container.indexOf(dbs.get(dbs.size() - 1))) continue;
                        if ((dbs.size() & 1) == 0) {
                            IAtom focus = StereoElementFactory.getShared(dbs.get(dbs.size() / 2), dbs.get(dbs.size() / 2 - 1));
                            ExtendedTetrahedral element2 = this.createExtendedTetrahedral(this.container.indexOf(focus), centers);
                            if (element2 == null) continue block8;
                            elements.add(element2);
                            continue block8;
                        }
                        element = this.createExtendedCisTrans(dbs, centers);
                        if (element == null) continue block8;
                        elements.add(element);
                        continue block8;
                    }
                    continue block8;
                }
                case Tetracoordinate: {
                    IStereoElement<IAtom, IAtom> element3 = this.createTetrahedral(v, centers);
                    if (element3 == null) continue block8;
                    elements.add(element3);
                    continue block8;
                }
                case Tricoordinate: {
                    IStereoElement<IAtom, IAtom> element3;
                    int[] nArray = this.graph[v];
                    int n = nArray.length;
                    for (int w = 0; w < n; ++w) {
                        int w2 = nArray[w];
                        IBond bond = this.bondMap.get(v, w2);
                        if (w2 <= v || centers.elementType(w2) != Stereocenters.Type.Tricoordinate || bond.getOrder() != IBond.Order.SINGLE || this.isInSmallRing(bond, 6) || !this.isInSmallRing(bond.getBegin(), 6) || !this.isInSmallRing(bond.getEnd(), 6)) continue;
                        element3 = this.createAtropisomer(v, w2, centers);
                        if (element3 == null) continue block8;
                        elements.add(element3);
                        continue block8;
                    }
                    continue block8;
                }
            }
        }
        centers.checkSymmetry();
        block11: for (v = 0; v < this.graph.length; ++v) {
            switch (centers.elementType(v)) {
                case Tricoordinate: {
                    if (!centers.isStereocenter(v)) continue block11;
                    for (int w : this.graph[v]) {
                        IBond bond = this.bondMap.get(v, w);
                        if (w <= v || bond.getOrder() != IBond.Order.DOUBLE) continue;
                        if (centers.elementType(w) != Stereocenters.Type.Tricoordinate || !centers.isStereocenter(w) || this.isInSmallRing(bond, 7) || (element = this.createGeometric(v, w, centers)) == null) continue block11;
                        elements.add(element);
                        continue block11;
                    }
                    continue block11;
                }
            }
        }
        return elements;
    }

    abstract ITetrahedralChirality createTetrahedral(int var1, Stereocenters var2);

    abstract IStereoElement createAtropisomer(int var1, int var2, Stereocenters var3);

    abstract ITetrahedralChirality createTetrahedral(IAtom var1, Stereocenters var2);

    abstract IDoubleBondStereochemistry createGeometric(int var1, int var2, Stereocenters var3);

    abstract IDoubleBondStereochemistry createGeometric(IBond var1, Stereocenters var2);

    abstract ExtendedTetrahedral createExtendedTetrahedral(int var1, Stereocenters var2);

    abstract ExtendedCisTrans createExtendedCisTrans(List<IBond> var1, Stereocenters var2);

    public StereoElementFactory interpretProjections(Projection ... projections) {
        Collections.addAll(this.projections, projections);
        this.check = true;
        return this;
    }

    public StereoElementFactory checkSymmetry(boolean check) {
        this.check = check;
        return this;
    }

    public static StereoElementFactory using2DCoordinates(IAtomContainer container) {
        GraphUtil.EdgeToBondMap bondMap = GraphUtil.EdgeToBondMap.withSpaceFor(container);
        int[][] graph = GraphUtil.toAdjList(container, bondMap);
        return new StereoElementFactory2D(container, graph, bondMap);
    }

    public static StereoElementFactory using3DCoordinates(IAtomContainer container) {
        GraphUtil.EdgeToBondMap bondMap = GraphUtil.EdgeToBondMap.withSpaceFor(container);
        int[][] graph = GraphUtil.toAdjList(container, bondMap);
        return new StereoElementFactory3D(container, graph, bondMap).checkSymmetry(true);
    }

    private static boolean hasUnspecifiedParity(IAtom atom) {
        return atom.getStereoParity() != null && atom.getStereoParity() == 3;
    }

    private static boolean isHydrogen(IAtom atom) {
        Integer elem = atom.getAtomicNumber();
        return elem != null && elem == 1;
    }

    private static final class StereoElementFactory3D
    extends StereoElementFactory {
        StereoElementFactory3D(IAtomContainer container, int[][] graph, GraphUtil.EdgeToBondMap bondMap) {
            super(container, graph, bondMap);
        }

        @Override
        ITetrahedralChirality createTetrahedral(IAtom atom, Stereocenters stereocenters) {
            return this.createTetrahedral(this.container.indexOf(atom), stereocenters);
        }

        @Override
        IDoubleBondStereochemistry createGeometric(IBond bond, Stereocenters stereocenters) {
            return this.createGeometric(this.container.indexOf(bond.getBegin()), this.container.indexOf(bond.getEnd()), stereocenters);
        }

        @Override
        ITetrahedralChirality createTetrahedral(int v, Stereocenters stereocenters) {
            if (!stereocenters.isStereocenter(v)) {
                return null;
            }
            IAtom focus = this.container.getAtom(v);
            if (StereoElementFactory.hasUnspecifiedParity(focus)) {
                return null;
            }
            IAtom[] neighbors = new IAtom[4];
            neighbors[3] = focus;
            int n = 0;
            for (int w : this.graph[v]) {
                neighbors[n++] = this.container.getAtom(w);
            }
            if (n < 3 || n > 4) {
                return null;
            }
            int parity = this.parity(neighbors);
            ITetrahedralChirality.Stereo winding = parity > 0 ? ITetrahedralChirality.Stereo.ANTI_CLOCKWISE : ITetrahedralChirality.Stereo.CLOCKWISE;
            return new TetrahedralChirality(focus, neighbors, winding);
        }

        @Override
        IStereoElement createAtropisomer(int u, int v, Stereocenters stereocenters) {
            IAtom end1 = this.container.getAtom(u);
            IAtom end2 = this.container.getAtom(v);
            if (StereoElementFactory.hasUnspecifiedParity(end1) || StereoElementFactory.hasUnspecifiedParity(end2)) {
                return null;
            }
            if (this.graph[u].length != 3 || this.graph[v].length != 3) {
                return null;
            }
            int sum1 = this.graph[this.graph[u][0]].length + this.graph[this.graph[u][1]].length + this.graph[this.graph[u][2]].length;
            int sum2 = this.graph[this.graph[v][0]].length + this.graph[this.graph[v][1]].length + this.graph[this.graph[v][2]].length;
            if (sum1 > 9 || sum1 < 8) {
                return null;
            }
            if (sum2 > 9 || sum2 < 8) {
                return null;
            }
            if (sum1 + sum2 < 17) {
                return null;
            }
            IAtom[] carriers = new IAtom[4];
            int n = 0;
            for (int w : this.graph[u]) {
                if (w == v) continue;
                carriers[n] = this.container.getAtom(w);
                for (int w2 : this.graph[w]) {
                    if (!StereoElementFactory.isHydrogen(this.container.getAtom(w2))) continue;
                    --sum1;
                }
                ++n;
            }
            n = 2;
            for (int w : this.graph[v]) {
                if (w == u) continue;
                carriers[n] = this.container.getAtom(w);
                for (int w2 : this.graph[w]) {
                    if (!StereoElementFactory.isHydrogen(this.container.getAtom(w2))) continue;
                    --sum2;
                }
                ++n;
            }
            if (n != 4) {
                return null;
            }
            if (sum1 > 9 || sum1 < 8) {
                return null;
            }
            if (sum2 > 9 || sum2 < 8) {
                return null;
            }
            if (sum1 + sum2 < 17) {
                return null;
            }
            int parity = this.parity(carriers);
            int cfg = parity > 0 ? 1 : 2;
            return new Atropisomeric(this.container.getBond(end1, end2), carriers, cfg);
        }

        @Override
        IDoubleBondStereochemistry createGeometric(int u, int v, Stereocenters stereocenters) {
            if (StereoElementFactory.hasUnspecifiedParity(this.container.getAtom(u)) || StereoElementFactory.hasUnspecifiedParity(this.container.getAtom(v))) {
                return null;
            }
            int[] us = this.graph[u];
            int[] vs = this.graph[v];
            int x = us[0] == v ? us[1] : us[0];
            int w = vs[0] == u ? vs[1] : vs[0];
            IAtom uAtom = this.container.getAtom(u);
            IAtom vAtom = this.container.getAtom(v);
            IAtom uSubstituentAtom = this.container.getAtom(x);
            IAtom vSubstituentAtom = this.container.getAtom(w);
            if (uAtom.getPoint3d() == null || vAtom.getPoint3d() == null || uSubstituentAtom.getPoint3d() == null || vSubstituentAtom.getPoint3d() == null) {
                return null;
            }
            int parity = this.parity(uAtom.getPoint3d(), vAtom.getPoint3d(), uSubstituentAtom.getPoint3d(), vSubstituentAtom.getPoint3d());
            IDoubleBondStereochemistry.Conformation conformation = parity > 0 ? IDoubleBondStereochemistry.Conformation.OPPOSITE : IDoubleBondStereochemistry.Conformation.TOGETHER;
            IBond bond = this.bondMap.get(u, v);
            bond.setAtoms(new IAtom[]{uAtom, vAtom});
            return new DoubleBondStereochemistry(bond, new IBond[]{this.bondMap.get(u, x), this.bondMap.get(v, w)}, conformation);
        }

        @Override
        ExtendedTetrahedral createExtendedTetrahedral(int v, Stereocenters stereocenters) {
            IAtom focus = this.container.getAtom(v);
            if (StereoElementFactory.hasUnspecifiedParity(focus)) {
                return null;
            }
            IAtom[] terminals = ExtendedTetrahedral.findTerminalAtoms(this.container, focus);
            IAtom[] neighbors = new IAtom[4];
            int t0 = this.container.indexOf(terminals[0]);
            int t1 = this.container.indexOf(terminals[1]);
            if (!this.isColinear(focus, terminals)) {
                return null;
            }
            neighbors[1] = terminals[0];
            neighbors[3] = terminals[1];
            int n = 0;
            for (int w : this.graph[t0]) {
                if (this.bondMap.get(t0, w).getOrder() != IBond.Order.SINGLE) continue;
                neighbors[n++] = this.container.getAtom(w);
            }
            if (n == 0) {
                return null;
            }
            n = 2;
            for (int w : this.graph[t1]) {
                if (this.bondMap.get(t1, w).getOrder() != IBond.Order.SINGLE) continue;
                neighbors[n++] = this.container.getAtom(w);
            }
            if (n == 2) {
                return null;
            }
            int parity = this.parity(neighbors);
            ITetrahedralChirality.Stereo winding = parity > 0 ? ITetrahedralChirality.Stereo.ANTI_CLOCKWISE : ITetrahedralChirality.Stereo.CLOCKWISE;
            return new ExtendedTetrahedral(focus, neighbors, winding);
        }

        @Override
        ExtendedCisTrans createExtendedCisTrans(List<IBond> dbs, Stereocenters centers) {
            if ((dbs.size() & 1) == 0) {
                return null;
            }
            IBond focus = dbs.get(dbs.size() / 2);
            IBond[] carriers = new IBond[2];
            int config = 0;
            IAtom begAtom = dbs.get(0).getOther(StereoElementFactory.getShared(dbs.get(0), dbs.get(1)));
            IAtom endAtom = dbs.get(dbs.size() - 1).getOther(StereoElementFactory.getShared(dbs.get(dbs.size() - 1), dbs.get(dbs.size() - 2)));
            List<IBond> begBonds = this.container.getConnectedBondsList(begAtom);
            List<IBond> endBonds = this.container.getConnectedBondsList(endAtom);
            if (begBonds.size() < 2 || endBonds.size() < 2) {
                return null;
            }
            begBonds.remove(dbs.get(0));
            endBonds.remove(dbs.get(dbs.size() - 1));
            IAtom[] ends = ExtendedCisTrans.findTerminalAtoms(this.container, focus);
            assert (ends != null);
            if (ends[0].equals(begAtom)) {
                carriers[0] = begBonds.get(0);
                carriers[1] = endBonds.get(0);
            } else {
                carriers[1] = begBonds.get(0);
                carriers[0] = endBonds.get(0);
            }
            IAtom begNbr = begBonds.get(0).getOther(begAtom);
            IAtom endNbr = endBonds.get(0).getOther(endAtom);
            Vector3d begVec = new Vector3d(begNbr.getPoint3d().x - begAtom.getPoint3d().x, begNbr.getPoint3d().y - begAtom.getPoint3d().y, begNbr.getPoint3d().z - begAtom.getPoint3d().z);
            Vector3d endVec = new Vector3d(endNbr.getPoint3d().x - endAtom.getPoint3d().x, endNbr.getPoint3d().y - endAtom.getPoint3d().y, endNbr.getPoint3d().z - endAtom.getPoint3d().z);
            begVec.normalize();
            endVec.normalize();
            double dot = begVec.dot(endVec);
            config = dot < 0.0 ? 1 : 2;
            return new ExtendedCisTrans(focus, carriers, config);
        }

        private boolean isColinear(IAtom focus, IAtom[] terminals) {
            Vector3d vec0 = new Vector3d(terminals[0].getPoint3d().x - focus.getPoint3d().x, terminals[0].getPoint3d().y - focus.getPoint3d().y, terminals[0].getPoint3d().z - focus.getPoint3d().z);
            Vector3d vec1 = new Vector3d(terminals[1].getPoint3d().x - focus.getPoint3d().x, terminals[1].getPoint3d().y - focus.getPoint3d().y, terminals[1].getPoint3d().z - focus.getPoint3d().z);
            vec0.normalize();
            vec1.normalize();
            return Math.abs(vec0.dot(vec1) + 1.0) < 0.05;
        }

        private static double det(double xa, double ya, double xb, double yb, double xc, double yc) {
            return (xa - xc) * (yb - yc) - (ya - yc) * (xb - xc);
        }

        private int parity(Point3d u, Point3d v, Point3d x, Point3d w) {
            double[] vu = StereoElementFactory3D.toVector(v, u);
            double[] vw = StereoElementFactory3D.toVector(v, w);
            double[] ux = StereoElementFactory3D.toVector(u, x);
            double[] normal = StereoElementFactory3D.crossProduct(vu, StereoElementFactory3D.crossProduct(vu, vw));
            int parity = (int)Math.signum(StereoElementFactory3D.dot(normal, vw)) * (int)Math.signum(StereoElementFactory3D.dot(normal, ux));
            return parity * -1;
        }

        private int parity(IAtom[] atoms) {
            if (atoms.length != 4) {
                throw new IllegalArgumentException("incorrect number of atoms");
            }
            Point3d[] coordinates = new Point3d[atoms.length];
            for (int i = 0; i < atoms.length; ++i) {
                coordinates[i] = atoms[i].getPoint3d();
                if (coordinates[i] != null) continue;
                return 0;
            }
            double x1 = coordinates[0].x;
            double x2 = coordinates[1].x;
            double x3 = coordinates[2].x;
            double x4 = coordinates[3].x;
            double y1 = coordinates[0].y;
            double y2 = coordinates[1].y;
            double y3 = coordinates[2].y;
            double y4 = coordinates[3].y;
            double z1 = coordinates[0].z;
            double z2 = coordinates[1].z;
            double z3 = coordinates[2].z;
            double z4 = coordinates[3].z;
            double det = z1 * StereoElementFactory3D.det(x2, y2, x3, y3, x4, y4) - z2 * StereoElementFactory3D.det(x1, y1, x3, y3, x4, y4) + z3 * StereoElementFactory3D.det(x1, y1, x2, y2, x4, y4) - z4 * StereoElementFactory3D.det(x1, y1, x2, y2, x3, y3);
            return (int)Math.signum(det);
        }

        private static double[] toVector(Point3d src, Point3d dest) {
            return new double[]{dest.x - src.x, dest.y - src.y, dest.z - src.z};
        }

        private static double dot(double[] u, double[] v) {
            return u[0] * v[0] + u[1] * v[1] + u[2] * v[2];
        }

        private static double[] crossProduct(double[] u, double[] v) {
            return new double[]{u[1] * v[2] - v[1] * u[2], u[2] * v[0] - v[2] * u[0], u[0] * v[1] - v[0] * u[1]};
        }
    }

    static final class StereoElementFactory2D
    extends StereoElementFactory {
        private static final double THRESHOLD = 0.1;

        StereoElementFactory2D(IAtomContainer container, int[][] graph, GraphUtil.EdgeToBondMap bondMap) {
            super(container, graph, bondMap);
        }

        @Override
        ITetrahedralChirality createTetrahedral(IAtom atom, Stereocenters stereocenters) {
            return this.createTetrahedral(this.container.indexOf(atom), stereocenters);
        }

        @Override
        IDoubleBondStereochemistry createGeometric(IBond bond, Stereocenters stereocenters) {
            return this.createGeometric(this.container.indexOf(bond.getBegin()), this.container.indexOf(bond.getEnd()), stereocenters);
        }

        @Override
        ITetrahedralChirality createTetrahedral(int v, Stereocenters stereocenters) {
            int parity;
            IAtom focus = this.container.getAtom(v);
            if (StereoElementFactory.hasUnspecifiedParity(focus)) {
                return null;
            }
            IAtom[] neighbors = new IAtom[4];
            int[] elevation = new int[4];
            neighbors[3] = focus;
            boolean nonplanar = false;
            int n = 0;
            for (int w : this.graph[v]) {
                IBond bond = this.bondMap.get(v, w);
                if (this.isUnspecified(bond)) {
                    return null;
                }
                neighbors[n] = this.container.getAtom(w);
                elevation[n] = this.elevationOf(focus, bond);
                if (elevation[n] != 0) {
                    nonplanar = true;
                }
                ++n;
            }
            if (n < 3 || n > 4) {
                return null;
            }
            if (!nonplanar) {
                int[] ws = this.graph[v];
                for (int i = 0; i < ws.length; ++i) {
                    int w = ws[i];
                    IBond bond = this.bondMap.get(v, w);
                    if (bond.getStereo() != IBond.Stereo.DOWN && bond.getStereo() != IBond.Stereo.DOWN_INVERTED || stereocenters.isStereocenter(w)) continue;
                    elevation[i] = -1;
                    nonplanar = true;
                }
                if (!nonplanar) {
                    return null;
                }
            }
            if ((parity = this.parity(focus, neighbors, elevation)) == 0) {
                return null;
            }
            ITetrahedralChirality.Stereo winding = parity > 0 ? ITetrahedralChirality.Stereo.ANTI_CLOCKWISE : ITetrahedralChirality.Stereo.CLOCKWISE;
            return new TetrahedralChirality(focus, neighbors, winding);
        }

        private static boolean isWedged(IBond bond) {
            switch (bond.getStereo()) {
                case UP: 
                case DOWN: 
                case UP_INVERTED: 
                case DOWN_INVERTED: {
                    return true;
                }
            }
            return false;
        }

        @Override
        IStereoElement createAtropisomer(int u, int v, Stereocenters stereocenters) {
            IBond bond;
            IAtom end1 = this.container.getAtom(u);
            IAtom end2 = this.container.getAtom(v);
            if (StereoElementFactory.hasUnspecifiedParity(end1) || StereoElementFactory.hasUnspecifiedParity(end2)) {
                return null;
            }
            if (this.graph[u].length != 3 || this.graph[v].length != 3) {
                return null;
            }
            int sum1 = this.graph[this.graph[u][0]].length + this.graph[this.graph[u][1]].length + this.graph[this.graph[u][2]].length;
            int sum2 = this.graph[this.graph[v][0]].length + this.graph[this.graph[v][1]].length + this.graph[this.graph[v][2]].length;
            if (sum1 > 9 || sum1 < 8) {
                return null;
            }
            if (sum2 > 9 || sum2 < 8) {
                return null;
            }
            if (sum1 + sum2 < 17) {
                return null;
            }
            IAtom[] carriers = new IAtom[4];
            int[] elevation = new int[4];
            int n = 0;
            for (int w : this.graph[u]) {
                bond = this.bondMap.get(u, w);
                if (w == v) continue;
                if (this.isUnspecified(bond)) {
                    return null;
                }
                carriers[n] = this.container.getAtom(w);
                elevation[n] = this.elevationOf(end1, bond);
                for (int w2 : this.graph[w]) {
                    if (StereoElementFactory.isHydrogen(this.container.getAtom(w2))) {
                        --sum1;
                        continue;
                    }
                    if (elevation[n] != 0 || !StereoElementFactory2D.isWedged(this.bondMap.get(w, w2))) continue;
                    elevation[n] = this.elevationOf(this.container.getAtom(w), this.bondMap.get(w, w2));
                }
                ++n;
            }
            n = 2;
            for (int w : this.graph[v]) {
                bond = this.bondMap.get(v, w);
                if (w == u) continue;
                if (this.isUnspecified(bond)) {
                    return null;
                }
                carriers[n] = this.container.getAtom(w);
                elevation[n] = this.elevationOf(end2, bond);
                for (int w2 : this.graph[w]) {
                    if (StereoElementFactory.isHydrogen(this.container.getAtom(w2))) {
                        --sum2;
                        continue;
                    }
                    if (elevation[n] != 0 || !StereoElementFactory2D.isWedged(this.bondMap.get(w, w2))) continue;
                    elevation[n] = this.elevationOf(this.container.getAtom(w), this.bondMap.get(w, w2));
                }
                ++n;
            }
            if (n != 4) {
                return null;
            }
            if (sum1 > 9 || sum1 < 8) {
                return null;
            }
            if (sum2 > 9 || sum2 < 8) {
                return null;
            }
            if (sum1 + sum2 < 17) {
                return null;
            }
            if (elevation[0] != 0 || elevation[1] != 0 ? elevation[2] != 0 || elevation[3] != 0 : elevation[2] == 0 && elevation[3] == 0) {
                return null;
            }
            IAtom tmp = end1.getBuilder().newAtom();
            tmp.setPoint2d(new Point2d((end1.getPoint2d().x + end2.getPoint2d().x) / 2.0, (end2.getPoint2d().y + end2.getPoint2d().y) / 2.0));
            int parity = this.parity(tmp, carriers, elevation);
            int cfg = parity > 0 ? 1 : 2;
            return new Atropisomeric(this.container.getBond(end1, end2), carriers, cfg);
        }

        @Override
        IDoubleBondStereochemistry createGeometric(int u, int v, Stereocenters stereocenters) {
            IDoubleBondStereochemistry.Conformation conformation;
            if (StereoElementFactory.hasUnspecifiedParity(this.container.getAtom(u)) || StereoElementFactory.hasUnspecifiedParity(this.container.getAtom(v))) {
                return null;
            }
            int[] us = this.graph[u];
            int[] vs = this.graph[v];
            if (us.length < 2 || us.length > 3 || vs.length < 2 || vs.length > 3) {
                return null;
            }
            StereoElementFactory2D.moveToBack(us, v);
            StereoElementFactory2D.moveToBack(vs, u);
            IAtom[] vAtoms = new IAtom[]{this.container.getAtom(us[0]), this.container.getAtom(us.length > 2 ? us[1] : u), this.container.getAtom(v)};
            IAtom[] wAtoms = new IAtom[]{this.container.getAtom(vs[0]), this.container.getAtom(vs.length > 2 ? vs[1] : v), this.container.getAtom(u)};
            if (this.isUnspecified(this.bondMap.get(u, us[0])) || this.isUnspecified(this.bondMap.get(u, us[1])) || this.isUnspecified(this.bondMap.get(v, vs[0])) || this.isUnspecified(this.bondMap.get(v, vs[1]))) {
                return null;
            }
            int parity = this.parity(vAtoms) * this.parity(wAtoms);
            IDoubleBondStereochemistry.Conformation conformation2 = conformation = parity > 0 ? IDoubleBondStereochemistry.Conformation.OPPOSITE : IDoubleBondStereochemistry.Conformation.TOGETHER;
            if (parity == 0) {
                return null;
            }
            IBond bond = this.bondMap.get(u, v);
            if (this.isUnspecified(bond)) {
                return null;
            }
            bond.setAtoms(new IAtom[]{this.container.getAtom(u), this.container.getAtom(v)});
            return new DoubleBondStereochemistry(bond, new IBond[]{this.bondMap.get(u, us[0]), this.bondMap.get(v, vs[0])}, conformation);
        }

        @Override
        ExtendedTetrahedral createExtendedTetrahedral(int v, Stereocenters stereocenters) {
            IBond bond;
            IAtom focus = this.container.getAtom(v);
            if (StereoElementFactory.hasUnspecifiedParity(focus)) {
                return null;
            }
            IAtom[] terminals = ExtendedTetrahedral.findTerminalAtoms(this.container, focus);
            int t0 = this.container.indexOf(terminals[0]);
            int t1 = this.container.indexOf(terminals[1]);
            if (!(!stereocenters.isSymmetryChecked() || stereocenters.isStereocenter(t0) && stereocenters.isStereocenter(t1))) {
                return null;
            }
            IAtom[] neighbors = new IAtom[4];
            int[] elevation = new int[4];
            neighbors[1] = terminals[0];
            neighbors[3] = terminals[1];
            int n = 0;
            for (int w : this.graph[t0]) {
                bond = this.bondMap.get(t0, w);
                if (w == v || bond.getOrder() != IBond.Order.SINGLE) continue;
                if (this.isUnspecified(bond)) {
                    return null;
                }
                neighbors[n] = this.container.getAtom(w);
                elevation[n] = this.elevationOf(terminals[0], bond);
                ++n;
            }
            if (n == 0) {
                return null;
            }
            n = 2;
            for (int w : this.graph[t1]) {
                bond = this.bondMap.get(t1, w);
                if (bond.getOrder() != IBond.Order.SINGLE) continue;
                if (this.isUnspecified(bond)) {
                    return null;
                }
                neighbors[n] = this.container.getAtom(w);
                elevation[n] = this.elevationOf(terminals[1], bond);
                ++n;
            }
            if (n == 2) {
                return null;
            }
            if (elevation[0] != 0 || elevation[1] != 0 ? elevation[2] != 0 || elevation[3] != 0 : elevation[2] == 0 && elevation[3] == 0) {
                return null;
            }
            int parity = this.parity(focus, neighbors, elevation);
            ITetrahedralChirality.Stereo winding = parity > 0 ? ITetrahedralChirality.Stereo.ANTI_CLOCKWISE : ITetrahedralChirality.Stereo.CLOCKWISE;
            return new ExtendedTetrahedral(focus, neighbors, winding);
        }

        @Override
        ExtendedCisTrans createExtendedCisTrans(List<IBond> dbs, Stereocenters stereocenters) {
            if ((dbs.size() & 1) == 0) {
                return null;
            }
            IBond focus = dbs.get(dbs.size() / 2);
            IBond[] carriers = new IBond[2];
            int config = 0;
            IAtom begAtom = dbs.get(0).getOther(StereoElementFactory.getShared(dbs.get(0), dbs.get(1)));
            IAtom endAtom = dbs.get(dbs.size() - 1).getOther(StereoElementFactory.getShared(dbs.get(dbs.size() - 1), dbs.get(dbs.size() - 2)));
            List<IBond> begBonds = this.container.getConnectedBondsList(begAtom);
            List<IBond> endBonds = this.container.getConnectedBondsList(endAtom);
            if (!(!stereocenters.isSymmetryChecked() || stereocenters.isStereocenter(this.container.indexOf(begAtom)) && stereocenters.isStereocenter(this.container.indexOf(endAtom)))) {
                return null;
            }
            if (begBonds.size() < 2 || endBonds.size() < 2) {
                return null;
            }
            begBonds.remove(dbs.get(0));
            endBonds.remove(dbs.get(dbs.size() - 1));
            IAtom[] ends = ExtendedCisTrans.findTerminalAtoms(this.container, focus);
            assert (ends != null);
            if (ends[0].equals(begAtom)) {
                carriers[0] = begBonds.get(0);
                carriers[1] = endBonds.get(0);
            } else {
                carriers[1] = begBonds.get(0);
                carriers[0] = endBonds.get(0);
            }
            IAtom begNbr = begBonds.get(0).getOther(begAtom);
            IAtom endNbr = endBonds.get(0).getOther(endAtom);
            Vector2d begVec = new Vector2d(begNbr.getPoint2d().x - begAtom.getPoint2d().x, begNbr.getPoint2d().y - begAtom.getPoint2d().y);
            Vector2d endVec = new Vector2d(endNbr.getPoint2d().x - endAtom.getPoint2d().x, endNbr.getPoint2d().y - endAtom.getPoint2d().y);
            begVec.normalize();
            endVec.normalize();
            double dot = begVec.dot(endVec);
            config = dot < 0.0 ? 1 : 2;
            return new ExtendedCisTrans(focus, carriers, config);
        }

        private boolean isUnspecified(IBond bond) {
            switch (bond.getStereo()) {
                case UP_OR_DOWN: 
                case UP_OR_DOWN_INVERTED: 
                case E_OR_Z: {
                    return true;
                }
            }
            return false;
        }

        private int parity(IAtom[] atoms) {
            if (atoms.length != 3) {
                throw new IllegalArgumentException("incorrect number of atoms");
            }
            Point2d a = atoms[0].getPoint2d();
            Point2d b = atoms[1].getPoint2d();
            Point2d c = atoms[2].getPoint2d();
            if (a == null || b == null || c == null) {
                return 0;
            }
            double det = StereoElementFactory2D.det(a.x, a.y, b.x, b.y, c.x, c.y);
            if (Math.abs(det) < 0.1) {
                return 0;
            }
            return (int)Math.signum(det);
        }

        private int parity(IAtom focus, IAtom[] atoms, int[] elevations) {
            if (atoms.length != 4) {
                throw new IllegalArgumentException("incorrect number of atoms");
            }
            Point2d[] coordinates = new Point2d[atoms.length];
            for (int i = 0; i < atoms.length; ++i) {
                coordinates[i] = atoms[i].getPoint2d();
                if (coordinates[i] == null) {
                    return 0;
                }
                coordinates[i] = this.toUnitVector(focus.getPoint2d(), atoms[i].getPoint2d());
            }
            double det = this.parity(coordinates, elevations);
            return (int)Math.signum(det);
        }

        private Point2d toUnitVector(Point2d from, Point2d to) {
            if (from.equals(to)) {
                return new Point2d(0.0, 0.0);
            }
            Vector2d v2d = new Vector2d(to.x - from.x, to.y - from.y);
            v2d.normalize();
            return new Point2d(v2d);
        }

        private double parity(Point2d[] coordinates, int[] elevations) {
            double x1 = coordinates[0].x;
            double x2 = coordinates[1].x;
            double x3 = coordinates[2].x;
            double x4 = coordinates[3].x;
            double y1 = coordinates[0].y;
            double y2 = coordinates[1].y;
            double y3 = coordinates[2].y;
            double y4 = coordinates[3].y;
            return (double)elevations[0] * StereoElementFactory2D.det(x2, y2, x3, y3, x4, y4) - (double)elevations[1] * StereoElementFactory2D.det(x1, y1, x3, y3, x4, y4) + (double)elevations[2] * StereoElementFactory2D.det(x1, y1, x2, y2, x4, y4) - (double)elevations[3] * StereoElementFactory2D.det(x1, y1, x2, y2, x3, y3);
        }

        private static double det(double xa, double ya, double xb, double yb, double xc, double yc) {
            return (xa - xc) * (yb - yc) - (ya - yc) * (xb - xc);
        }

        private static void moveToBack(int[] vs, int v) {
            for (int i = 0; i < vs.length; ++i) {
                if (vs[i] != v) continue;
                System.arraycopy(vs, i + 1, vs, i + 1 - 1, vs.length - (i + 1));
                vs[vs.length - 1] = v;
                return;
            }
        }

        private int elevationOf(IAtom focus, IBond bond) {
            switch (bond.getStereo()) {
                case UP: {
                    return bond.getBegin().equals(focus) ? 1 : 0;
                }
                case UP_INVERTED: {
                    return bond.getEnd().equals(focus) ? 1 : 0;
                }
                case DOWN: {
                    return bond.getBegin().equals(focus) ? -1 : 0;
                }
                case DOWN_INVERTED: {
                    return bond.getEnd().equals(focus) ? -1 : 0;
                }
            }
            return 0;
        }
    }
}

