/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.validate;

import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.validate.AbstractValidator;
import org.openscience.cdk.validate.ValidationReport;
import org.openscience.cdk.validate.ValidationTest;

public class CDKValidator
extends AbstractValidator {
    @Override
    public ValidationReport validateChemFile(IChemFile subject) {
        return this.validateChemFileNulls(subject);
    }

    @Override
    public ValidationReport validateChemSequence(IChemSequence subject) {
        return this.validateChemSequenceNulls(subject);
    }

    private ValidationReport validateChemFileNulls(IChemFile chemFile) {
        ValidationReport report = new ValidationReport();
        ValidationTest hasNulls = new ValidationTest(chemFile, "ChemFile contains a null ChemSequence.");
        for (int i = 0; i < chemFile.getChemSequenceCount(); ++i) {
            if (chemFile.getChemSequence(i) == null) {
                report.addError(hasNulls);
                continue;
            }
            report.addOK(hasNulls);
        }
        return report;
    }

    private ValidationReport validateChemSequenceNulls(IChemSequence sequence) {
        ValidationReport report = new ValidationReport();
        ValidationTest hasNulls = new ValidationTest(sequence, "ChemSequence contains a null ChemModel.");
        for (int i = 0; i < sequence.getChemModelCount(); ++i) {
            if (sequence.getChemModel(i) == null) {
                report.addError(hasNulls);
                continue;
            }
            report.addOK(hasNulls);
        }
        return report;
    }
}

