/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.euclid;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.xmlcml.euclid.EuclidConstants;
import org.xmlcml.euclid.EuclidRuntimeException;
import org.xmlcml.euclid.IntArray;
import org.xmlcml.euclid.RealArray;
import org.xmlcml.euclid.StringIntegerComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util
implements EuclidConstants {
    static final Logger logger = Logger.getLogger(Util.class.getName());
    public static final String[] LOWER_ROMAN_NUMERAL = new String[]{"i", "ii", "iii", "iv", "v", "vi", "vii", "viii", "ix", "x", "xi", "xii", "xiii", "xiv", "xv", "xvi", "xvii", "xviii", "xix", "xx", "xxi", "xxii", "xxiii", "xxiv", "xxv", "xxvi", "xxvii", "xxviii", "xxix", "xxx", "xxxi", "xxxii", "xxxiii", "xxxiv", "xxxv", "xxxvi", "xxxvii", "xxxviii", "xxxix", "xl", "xli", "xlii", "xliii", "xliv", "xlv", "xlvi", "xlvii", "xlviii", "xlix", "l"};
    public static final String LOWER_ROMAN_REGEX = "[ivxlcdm]+";
    public static final String UPPER_ROMAN_REGEX = "[IVXLCDM]+";
    private static final File TEMP_DIRECTORY = new File("target" + File.separator + "test-outputs");
    static final String FS = System.getProperty("file.separator");
    static String[] dosEquivalents = new String[]{"\f", "\u007f", "\u0080", "\u0081", "\u0082", "\u0083", "\u0084", "\u0085", "\u0086", "\u0087", "\u0088", "\u0089", "\u008a", "\u008b", "\u008c", "\u008d", "\u008e", "\u008f", "\u0090", "\u0091", "\u0092", "\u0093", "\u0094", "\u0095", "\u0096", "\u0097", "\u0098", "\u0099", "\u009a", "\u009b", "\u009c", "\u009d", "\u009e", "\u009f", "\u00a0", "\u00a1", "\u00a2", "\u00a3", "\u00a4", "\u00a5", "\u00a6", "\u00a7", "\u00a8", "\u00a9", "\u00aa", "\u00ab", "\u00ac", "\u00ad", "\u00ae", "\u00af", "\u00b0", "\u00b1", "\u00b2", "\u00b3", "\u00b4", "\u00c0", "\u00f8", "\u0160", "\u0192", "\u02c6", "\u201a", "\u201d", "\u201e", "\u2021", "\u2026", "\u2030", "\ufffd"};
    static String[] asciiEquivalents = new String[]{"", "\u0000", "\u00c7", "\u00fc", "\u00e9", "\u00e2", "\u00e4", "\u00e0", "\u00e5", "\u00e7", "\u00ea", "\u00eb", "\u00e8", "\u00ef", "\u00ee", "\u00ec", "\u00c4", "\u00c5", "\u00c9", "\u00e6", "\u0000", "\u00f4", "\u00f6", "\u00f2", "\u00fb", "\u00f9", "\u00ff", "\u00d6", "\u00dc", "\u0000", "\u0000", "\u0000", "\u0000", "\u0000", "\u00e1", "\u00ed", "\u00f3", "\u00fa", "\u00f1", "\u00d1", "\u0000", "\u0000", "\u0000", "\u0000", "\u0000", "\u0000", "\u0000", "\u0000", "\u0000", "\u0000", "\u0000", "\u0000", "\u0000", "\u0000", "\u0000", "\u00e9", "[degrees]", "\u00e8", "\u00e2", "\u00ea", "\u00e9", "\u00f6", "\u00e4", "\u00e7", "\u00e0", "\u00eb", "\u00fc"};
    public static final String[] ISOLATIN_ENTITIES = new String[256];
    public static final int ISOLATIN_LO = 160;
    public static final int ISOLATIN_HI = 255;
    public static final String[] GREEK_ENTITIES;
    public static final String[] UPPER_GREEK_ENTITIES;
    public static final Map<String, Character> GREEK2CHARACTER_MAP;
    static Hashtable<String, DecimalFormat> formTable;
    private static List<Integer> primeList;
    public static final String DATE_REGEX1 = "([0-3][0-9])\\-(jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec)\\-(\\d\\d\\d\\d)";
    public static final String DATE_REGEX2 = "\\d\\d\\d\\d\\-[0-1][0-9]\\-[0-3][0-9]";
    public static final String[] months;

    public static File getTEMP_DIRECTORY() {
        boolean ok;
        if (!TEMP_DIRECTORY.exists() && !(ok = TEMP_DIRECTORY.mkdirs())) {
            throw new RuntimeException("Cannot create temporary directory : " + TEMP_DIRECTORY.getAbsolutePath());
        }
        return TEMP_DIRECTORY;
    }

    public static File getTestOutputDirectory(Class<?> classx) {
        boolean ok;
        String dirs;
        File tempDir = Util.getTEMP_DIRECTORY();
        File testDir = new File(tempDir, dirs = classx.getName().replace(".", File.separator));
        if (!testDir.exists() && !(ok = testDir.mkdirs())) {
            throw new RuntimeException("Cannot create temporary class directory : " + testDir.getAbsolutePath());
        }
        return testDir;
    }

    public static final String[] addElementToStringArray(String[] array, String s) {
        int l = array.length;
        String[] array1 = new String[l + 1];
        for (int i = 0; i < l; ++i) {
            array1[i] = array[i];
        }
        array1[l] = s;
        return array1;
    }

    public static final String[] removeElementFromStringArray(String[] array, String s) {
        ArrayList<String> sList = new ArrayList<String>();
        for (int i = 0; i < array.length; ++i) {
            if (array[i].equals(s)) continue;
            sList.add(array[i]);
        }
        return sList.toArray(new String[0]);
    }

    public static void BUG(String msg, Exception e) {
        msg = msg == null || msg.trim().length() == 0 ? "" : "(" + msg + ")";
        throw new RuntimeException("BUG: " + msg + "should never throw: " + e, e);
    }

    public static void BUG(Exception e) {
        Util.BUG("", e);
    }

    public static void throwNYI() {
        throw new RuntimeException(Message.NYI.value);
    }

    public static void BUG(String msg) {
        Util.BUG(msg, new RuntimeException());
    }

    public static InputStream getInputStreamFromResource(String filename) throws IOException {
        return Util.getResource(filename).openStream();
    }

    public static void createFile(File dir, String filename) throws IOException {
        boolean ok;
        File file = new File(dir + File.separator + filename);
        if (!dir.exists() && !(ok = dir.mkdirs())) {
            throw new IOException("cannot make dictories: " + dir + " " + filename);
        }
        if (!file.exists()) {
            file.createNewFile();
        }
    }

    public static URL getResource(String filename) {
        ClassLoader l;
        URL url = null;
        if (filename != null && (url = (l = Util.class.getClassLoader()).getResource(filename)) == null) {
            throw new RuntimeException("No resource with name " + filename);
        }
        return url;
    }

    public static InputStream getResourceUsingContextClassLoader(String name, Class<?> clazz) throws FileNotFoundException {
        InputStream is;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = clazz.getClassLoader();
        }
        if ((is = cl.getResourceAsStream(name)) == null) {
            throw new FileNotFoundException("Resource not found: " + name);
        }
        return is;
    }

    public static File getResourceFile(String ... path) throws URISyntaxException {
        File f = new File(Util.class.getClassLoader().getResource(Util.buildPath(path)).toURI());
        return f;
    }

    public static String buildPath(String ... parts) {
        StringBuilder sb = new StringBuilder(parts.length * 20);
        for (String part : parts) {
            sb.append(part).append(File.separatorChar);
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public static boolean deleteFile(File file, boolean deleteDirectory) {
        if (file.exists()) {
            if (file.isDirectory() && deleteDirectory) {
                String[] filenames = file.list();
                for (int i = 0; i < filenames.length; ++i) {
                    File childFile = new File(file.toString() + File.separator + filenames[i]);
                    Util.deleteFile(childFile, deleteDirectory);
                }
            }
            return file.delete();
        }
        return false;
    }

    public static void copyFile(File inFile, File outFile) throws FileNotFoundException, IOException {
        int b;
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(inFile));
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(outFile));
        byte[] buffer = new byte[10000];
        while ((b = bis.read(buffer)) != -1) {
            bos.write(buffer, 0, b);
        }
        bis.close();
        bos.close();
    }

    public static String dump(URL url) throws Exception {
        int i;
        BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream()));
        int count = 0;
        StringBuffer sb = new StringBuffer();
        String s0 = "\n";
        String s1 = "";
        while ((i = br.read()) != -1) {
            String s = "   " + i;
            while (s.length() > 4) {
                s = s.substring(1);
            }
            s0 = s0 + s;
            s1 = i >= 32 && i < 128 ? s1 + (char)i : s1 + " ";
            if (++count % 10 != 0) continue;
            sb.append(s0 + "   " + s1);
            s1 = "";
            s0 = "\n";
        }
        if (count != 0) {
            sb.append(s0 + "   " + s1);
        }
        return sb.toString();
    }

    public static String spaces(int nspace) {
        if (nspace <= 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < nspace; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }

    public static String getSuffix(String filename) {
        int idx = filename.lastIndexOf(".");
        if (idx == -1) {
            return null;
        }
        return filename.substring(idx + 1, filename.length());
    }

    public static String truncateAndAddEllipsis(String s, int maxlength) {
        if (s != null) {
            int l = s.length();
            s = l <= maxlength ? s : s.substring(0, maxlength) + " ... ";
        }
        return s;
    }

    public static String truncateAndAddNewlinesAndEllipsis(String s, int maxlength) {
        return s == null ? null : Util.truncateAndAddEllipsis(s.replace("\n", "\\n"), maxlength);
    }

    public static String deQuote(String s) {
        int l;
        if (s == null) {
            return null;
        }
        String ss = s.trim();
        if (ss.equals("")) {
            return ss;
        }
        char c = ss.charAt(0);
        if ((c == '\"' || c == '\'') && ss.charAt((l = ss.length()) - 1) == c) {
            return ss.substring(1, l - 1);
        }
        return s;
    }

    public static String rightTrim(String s) {
        if (s == null) {
            return null;
        }
        if (s.trim().equals("")) {
            return "";
        }
        int l = s.length();
        while (l >= 0) {
            if (Character.isWhitespace(s.charAt(--l))) continue;
            ++l;
            break;
        }
        return s.substring(0, l);
    }

    public static String leftTrim(String s) {
        if (s == null) {
            return null;
        }
        if (s.trim().equals("")) {
            return "";
        }
        int l = s.length();
        for (int i = 0; i < l; ++i) {
            if (s.charAt(i) == ' ') continue;
            return s.substring(i);
        }
        return s;
    }

    public static int indexOfBalancedBracket(char lbrack, String s) {
        if (s == null) {
            return -1;
        }
        if (s.charAt(0) != lbrack) {
            return -1;
        }
        char rbrack = ' ';
        if (lbrack == '(') {
            rbrack = ')';
        } else if (lbrack == '<') {
            rbrack = '>';
        } else if (lbrack == '[') {
            rbrack = ']';
        } else if (lbrack == '{') {
            rbrack = '}';
        }
        int l = s.length();
        int level = 0;
        for (int i = 0; i < l; ++i) {
            if (s.charAt(i) == lbrack) {
                ++level;
                continue;
            }
            if (s.charAt(i) != rbrack || --level != 0) continue;
            return i;
        }
        return -1;
    }

    public static List<String> getCommaSeparatedStrings(String s) throws RuntimeException {
        if (s == null) {
            return null;
        }
        String s0 = s;
        s = s.trim();
        ArrayList<String> v = new ArrayList<String>();
        while (!s.equals("")) {
            if (s.startsWith("\"")) {
                int idx;
                String temp = "";
                s = s.substring(1);
                while (true) {
                    if ((idx = s.indexOf("\"")) == -1) {
                        throw new RuntimeException("Missing Quote:" + s0 + ":");
                    }
                    int idx2 = s.indexOf("\"\"");
                    if (idx2 != idx) break;
                    temp = temp + s.substring(0, idx) + "\"";
                    s = s.substring(idx + 2);
                }
                temp = temp + s.substring(0, idx);
                s = s.substring(idx + 1);
                v.add(temp);
                if (s.startsWith(",")) {
                    s = s.substring(1);
                    continue;
                }
                if (s.equals("")) continue;
                throw new RuntimeException("Unbalanced Quotes:" + s0 + ":");
            }
            int idx = s.indexOf(",");
            if (idx == -1) {
                v.add(s);
                break;
            }
            String temp = s.substring(0, idx);
            v.add(temp);
            if (!(s = s.substring(idx + 1)).equals("")) continue;
            v.add(s);
            break;
        }
        return v;
    }

    public static String createCommaSeparatedStrings(List<String> v) {
        if (v == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < v.size(); ++i) {
            String s = v.get(i).toString();
            if ((s = Util.substituteStrings(s, new String[]{"\""}, new String[]{"\"\""})).indexOf(",") != -1 || s.indexOf("\"") != -1) {
                s = "\"" + s + "\"";
            }
            if (i > 0) {
                sb.append(",");
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public static String quoteConcatenate(String[] s) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length; ++i) {
            if (i > 0) {
                sb.append(" ");
            }
            boolean quote = false;
            if (s[i].indexOf(" ") != -1) {
                sb.append("\"");
                quote = true;
            }
            sb.append(s[i]);
            if (!quote) continue;
            sb.append("\"");
        }
        return sb.toString();
    }

    public static int indexOf(String string, String[] strings, boolean ignoreCase) {
        if (string == null || strings == null) {
            return -1;
        }
        for (int i = 0; i < strings.length; ++i) {
            if (!(ignoreCase ? string.equalsIgnoreCase(strings[i]) : string.equals(strings[i]))) continue;
            return i;
        }
        return -1;
    }

    public static String removeHTML(String s) {
        StringBuilder sb = new StringBuilder();
        while (true) {
            int idx;
            if ((idx = s.indexOf("<")) == -1) break;
            sb.append(s.substring(0, idx));
            s = s.substring(idx);
            idx = s.indexOf(62);
            if (idx == -1) {
                throw new RuntimeException("missing >");
            }
            s = s.substring(idx + 1);
        }
        sb.append(s);
        return sb.toString();
    }

    public static void warning(String s) {
        logger.info("WARNING: " + s);
    }

    public static void message(String s) {
        logger.info(s);
    }

    public static void error(String s) {
        logger.info("ERROR: " + s);
    }

    public static void BUG(String msg, Throwable t) {
        msg = msg == null || msg.trim().length() == 0 ? "" : "(" + msg + ")";
        throw new RuntimeException("BUG: " + msg + "should never throw", t);
    }

    public static void BUG(Throwable t) {
        Util.BUG("", t);
    }

    public static String getPWDName() {
        File f = new File(".");
        return new File(f.getAbsolutePath()).getParent();
    }

    public static File createNewFile(String fileName) throws IOException {
        File f = null;
        String path = null;
        int idx = fileName.lastIndexOf(FS);
        if (idx != -1) {
            path = fileName.substring(0, idx);
        }
        if (path != null) {
            f = new File(path);
            f.mkdirs();
        }
        if (!fileName.endsWith(FS)) {
            f = new File(fileName);
        }
        return f;
    }

    public static String substituteString(String s, String oldSubstring, String newSubstring, int count) {
        int idx;
        if (count <= 0) {
            count = Integer.MAX_VALUE;
        }
        StringBuffer sb = new StringBuffer();
        int lo = oldSubstring.length();
        for (int i = 0; i < count && (idx = s.indexOf(oldSubstring)) != -1; ++i) {
            sb.append(s.substring(0, idx));
            sb.append(newSubstring);
            s = s.substring(idx + lo);
        }
        sb.append(s);
        return sb.toString();
    }

    public static String substituteStrings(String s, String[] oldSubstrings, String[] newSubstrings) {
        int ol = oldSubstrings.length;
        int nl = newSubstrings.length;
        if (ol != nl) {
            throw new RuntimeException("Util.substituteStrings  arguments of different lengths: " + ol + "/" + nl);
        }
        for (int i = 0; i < ol; ++i) {
            String oldS = oldSubstrings[i];
            String newS = newSubstrings[i];
            int lo = oldS.length();
            if (s.indexOf(oldS) == -1) continue;
            String ss = "";
            while (true) {
                int idx;
                if ((idx = s.indexOf(oldS)) == -1) break;
                ss = ss + s.substring(0, idx) + newS;
                s = s.substring(idx + lo);
            }
            ss = ss + s;
            s = ss;
        }
        return s;
    }

    private static String replaceNumericEntityByMnemonic(String s, String ent, int lo, int hi, String[] chars) throws RuntimeException {
        if (ent == null || !ent.endsWith("&#")) {
            throw new RuntimeException("bad entity: " + ent);
        }
        int idx = s.indexOf(ent);
        if (idx != -1) {
            while ((idx = s.indexOf(ent)) != -1) {
                String ss = s.substring(idx + ent.length());
                int ii = ss.indexOf(";");
                if (ii == -1) {
                    throw new RuntimeException("Bad entity after (" + ent + "): " + s);
                }
                String alpha = "_unk_";
                String sss = ss.substring(0, ii);
                try {
                    int ia = Integer.parseInt(sss);
                    alpha = ia >= 32 && ia <= 127 ? "" + (char)ia : (ia < lo || ia > hi ? "_ent" + ia + "_" : "_" + chars[ia] + "_");
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException("Bad numeric entity: " + sss);
                }
                s = s.replace(ent + sss + ";", alpha);
            }
        }
        return s;
    }

    public static String replaceNumericEntityByISOLatinString(String s, String ent) {
        return Util.replaceNumericEntityByMnemonic(s, ent, 160, 255, ISOLATIN_ENTITIES);
    }

    public static String replaceISOControlsByMnemonic(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int l = s.length();
        for (int i = 0; i < l; ++i) {
            char ch = s.charAt(i);
            if (Character.isISOControl(ch)) {
                sb.append(Util.translateToMnemonic(ch));
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static String translateToMnemonic(char ch) {
        switch (ch) {
            case '\u0000': {
                return "NUL";
            }
            case '\u0001': {
                return "SOH";
            }
            case '\u0002': {
                return "STX";
            }
            case '\u0003': {
                return "ETX";
            }
            case '\u0004': {
                return "EOT";
            }
            case '\u0005': {
                return "ENQ";
            }
            case '\u0006': {
                return "ACK";
            }
            case '\u0007': {
                return "BEL";
            }
            case '\b': {
                return "BS";
            }
            case '\t': {
                return "HT";
            }
            case '\n': {
                return "LF";
            }
            case '\u000b': {
                return "VT";
            }
            case '\f': {
                return "FF";
            }
            case '\r': {
                return "CR";
            }
            case '\u000e': {
                return "SO";
            }
            case '\u000f': {
                return "SI";
            }
            case '\u0010': {
                return "DLE";
            }
            case '\u0011': {
                return "DC1";
            }
            case '\u0012': {
                return "DC2";
            }
            case '\u0013': {
                return "DC3";
            }
            case '\u0014': {
                return "DC4";
            }
            case '\u0015': {
                return "NAK";
            }
            case '\u0016': {
                return "SYN";
            }
            case '\u0017': {
                return "ETB";
            }
            case '\u0018': {
                return "CAN";
            }
            case '\u0019': {
                return "EM";
            }
            case '\u001a': {
                return "SUB";
            }
            case '\u001b': {
                return "ESC";
            }
            case '\u001c': {
                return "FS";
            }
            case '\u001d': {
                return "GS";
            }
            case '\u001e': {
                return "RS";
            }
            case '\u001f': {
                return "US";
            }
            case '\u007f': {
                return "DEL";
            }
        }
        return "";
    }

    public static char convertUTF8ToLatin1(char a, char b) {
        char c = '\u0000';
        if (b >= '\u0080' && b < '\u00c0') {
            if (a == '\u00c2') {
                c = b;
            } else if (a == '\u00c3') {
                c = (char)(b + 64);
            }
        }
        return c;
    }

    public static char[] convertLatin1ToUTF8(char a) {
        char[] c = null;
        if (a >= '\u0080' && a < '\u00c0') {
            c = new char[]{'\u00c2', a};
        } else if (a >= '\u00c0' && a < '\u0100') {
            c = new char[]{'\u00c3', (char)(a - 64)};
        }
        return c;
    }

    public static String replaceNumericEntityByGreekMnemonics(String s, String ent) {
        return Util.replaceNumericEntityByMnemonic(s, ent, 145, 199, GREEK_ENTITIES);
    }

    public static String substituteDOSbyAscii(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char jj = s.charAt(i);
            if (jj <= '\u00b4') continue;
            boolean ok = false;
            for (int j = 0; j < dosEquivalents.length; ++j) {
                if (!dosEquivalents[j].equals("" + s.charAt(i))) continue;
                ok = true;
                break;
            }
            if (ok) continue;
            logger.error("==Unknown DOS character==" + jj + "//" + s);
        }
        String s1 = Util.substituteStrings(s, dosEquivalents, asciiEquivalents);
        return s1;
    }

    public static String substituteNonASCIIChars(String s, char replacement) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            c = c > '\u0100' ? replacement : c;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String substituteSmartCharacters(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            int c = s.charAt(i);
            if (c == 8204 || c == 160) {
                c = 32;
            } else if (c == 8205) {
                c = -1;
            } else if (c == 8211 || c == 8212) {
                c = 45;
            } else if (c == 8216 || c == 8217) {
                c = 39;
            } else if (c == 8220 || c == 8221) {
                c = 34;
            } else if (c > 127) {
                c = 63;
            }
            if (c <= 0) continue;
            sb.append((char)c);
        }
        return sb.toString();
    }

    public static String replaceTabs(String s, int width) {
        StringBuilder sb = new StringBuilder();
        int out = 0;
        for (int in = 0; in < s.length(); ++in) {
            char c = s.charAt(in);
            if (c == '\t') {
                int mod = width - out % width;
                for (int i = 0; i < mod; ++i) {
                    sb.append(' ');
                    ++out;
                }
                continue;
            }
            sb.append(c);
            ++out;
        }
        return sb.toString();
    }

    public static String substituteEquals(String s) {
        if (s == null) {
            return null;
        }
        int len = s.length();
        StringBuffer sb = new StringBuffer("");
        while (true) {
            int idx;
            if ((idx = s.indexOf("=")) == -1) {
                sb.append(s);
                return sb.toString();
            }
            sb.append(s.substring(0, idx));
            s = s.substring(idx + 1);
            if ((len -= idx + 1) <= 1) {
                sb.append("=");
                sb.append(s);
                return sb.toString();
            }
            int hex = Util.getIntFromHex(s.substring(0, 2));
            if (hex < 0) {
                sb.append("=");
                continue;
            }
            sb.append((char)hex);
            s = s.substring(2);
            len -= 2;
        }
    }

    public static int getIntFromHex(String hex) {
        if ((hex = hex.toUpperCase()).startsWith("0X")) {
            hex = hex.substring(2);
        } else if (hex.charAt(0) == 'X') {
            hex = hex.substring(1);
        }
        int result = 0;
        for (int i = 0; i < hex.length(); ++i) {
            char c = hex.charAt(i);
            if (Character.isDigit(c)) {
                c = (char)(c - 48);
            } else {
                if (c < 'A' || c > 'F') {
                    return -1;
                }
                c = (char)(c - 65);
                c = (char)(c + 10);
            }
            result = 16 * result + c;
        }
        return result;
    }

    public static String capitalise(String s) {
        if (s.equals("")) {
            return "";
        }
        if (s.length() == 1) {
            return s.toUpperCase();
        }
        return s.substring(0, 1).toUpperCase() + s.substring(1).toLowerCase();
    }

    public static String toCamelCase(String s) {
        StringTokenizer st = new StringTokenizer(s, " \n\r\t");
        String out = "";
        while (st.hasMoreTokens()) {
            s = st.nextToken();
            if (out != "") {
                s = Util.capitalise(s);
            }
            out = out + s;
        }
        return out;
    }

    public static byte[] readByteArray(String filename) throws FileNotFoundException, IOException {
        DataInputStream dis = new DataInputStream(new FileInputStream(filename));
        return Util.readByteArray(dis);
    }

    public static byte[] readByteArray(DataInputStream d) throws IOException {
        int len = 100;
        int count = 0;
        byte[] src = new byte[len];
        while (true) {
            byte b;
            try {
                b = d.readByte();
            }
            catch (EOFException e) {
                break;
            }
            src[count] = b;
            if (++count < len) continue;
            byte[] temp = new byte[len *= 2];
            System.arraycopy(src, 0, temp, 0, count);
            src = temp;
        }
        len = count;
        byte[] temp = new byte[len];
        System.arraycopy(src, 0, temp, 0, count);
        return temp;
    }

    public static String stripISOControls(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int l = s.length();
        for (int i = 0; i < l; ++i) {
            char ch = s.charAt(i);
            if (Character.isISOControl(ch)) continue;
            sb.append(ch);
        }
        return sb.toString();
    }

    public static String normaliseWhitespace(String s) {
        if (s == null || s.equals("")) {
            return s;
        }
        StringTokenizer st = new StringTokenizer(s, " \t\r\n\f");
        int l = s.length();
        String ss = "";
        if (Character.isWhitespace(s.charAt(0))) {
            ss = " ";
        }
        String end = "";
        if (Character.isWhitespace(s.charAt(l - 1))) {
            end = " ";
        }
        boolean start = true;
        while (st.hasMoreTokens()) {
            if (start) {
                ss = ss + st.nextToken();
                start = false;
                continue;
            }
            ss = ss + " " + st.nextToken();
        }
        return ss + end;
    }

    public static byte[] stripNewlines(byte[] b) {
        int l = b.length;
        byte[] bb = new byte[l];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            if (b[i] == 10) continue;
            bb[j++] = b[i];
        }
        byte[] bbb = new byte[j];
        System.arraycopy(bb, 0, bbb, 0, j);
        return bbb;
    }

    public static FileOutputStream getFileOutputStream(String fileName) throws FileNotFoundException {
        if (fileName == null) {
            return null;
        }
        if (fileName.startsWith("file:") && fileName.substring(5).indexOf(":") != -1 && ((fileName = fileName.substring(5)).startsWith("/") || fileName.startsWith("\\"))) {
            fileName = fileName.substring(1);
        }
        return new FileOutputStream(fileName);
    }

    public static String outputFloat(int nPlaces, int nDec, double value) throws EuclidRuntimeException {
        String f = "f" + nPlaces + "." + nDec;
        DecimalFormat form = formTable.get(f);
        if (form == null) {
            int i;
            String pattern = "";
            for (i = 0; i < nPlaces - nDec - 2; ++i) {
                pattern = pattern + "#";
            }
            pattern = pattern + "0.";
            for (i = nPlaces - nDec; i < nPlaces; ++i) {
                pattern = pattern + "0";
            }
            form = (DecimalFormat)NumberFormat.getInstance();
            DecimalFormatSymbols symbols = form.getDecimalFormatSymbols();
            symbols.setDecimalSeparator('.');
            form.setDecimalFormatSymbols(symbols);
            form.setMaximumIntegerDigits(nPlaces - nDec - 1);
            form.applyPattern(pattern);
            formTable.put(f, form);
        }
        String result = form.format(value).trim();
        boolean negative = false;
        if (result.charAt(0) == '-') {
            result = result.substring(1);
            negative = true;
        }
        if (negative) {
            result = "-" + result;
        }
        StringBuffer sb = new StringBuffer();
        int l = result.length();
        for (int i = 0; i < nPlaces - l; ++i) {
            sb.append(" ");
        }
        String s = sb.append(result).toString();
        if (l > nPlaces && (s = s.substring(0, nPlaces)).indexOf(".") == -1) {
            s = "";
            for (int i = 0; i < nPlaces; ++i) {
                s = s + "*";
            }
        }
        return s;
    }

    public static String outputNumber(int nPlaces, int nDec, double c) {
        String s = Util.outputFloat(nPlaces, nDec, c).trim();
        if (s.indexOf(".") != -1) {
            while (s.endsWith("0")) {
                s = s.substring(0, s.length() - 1);
            }
            if (s.endsWith(".")) {
                s = s.substring(0, s.length() - 1);
            }
        }
        return s;
    }

    public static Hashtable<Object, Object> invert(Hashtable<Object, Object> table) {
        if (table == null) {
            return null;
        }
        Hashtable<Object, Object> newTable = new Hashtable<Object, Object>();
        Enumeration<Object> e = table.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Object value = table.get(key);
            newTable.put(value, key);
        }
        return newTable;
    }

    public static void check(double[] array, int size) throws EuclidRuntimeException {
        if (array == null) {
            throw new EuclidRuntimeException("null array");
        }
        if (array.length != size) {
            throw new EuclidRuntimeException("array size required (" + size + ") found " + array.length);
        }
    }

    public static void check(int n, int low, int high) throws EuclidRuntimeException {
        if (n < low || n > high) {
            throw new EuclidRuntimeException("index (" + n + ")out of range: " + low + "/" + high);
        }
    }

    public static boolean isEqual(double[] a, double[] b, double eps) {
        boolean equal;
        boolean bl = equal = a != null && b != null && a.length == b.length;
        if (equal) {
            for (int i = 0; i < a.length; ++i) {
                if (!(Math.abs(a[i] - b[i]) >= eps)) continue;
                equal = false;
                break;
            }
        }
        return equal;
    }

    public static boolean isEqual(int[] a, int[] b, int eps) {
        boolean equal;
        boolean bl = equal = a != null && b != null && a.length == b.length;
        if (equal) {
            for (int i = 0; i < a.length; ++i) {
                if (Math.abs(a[i] - b[i]) < eps) continue;
                equal = false;
                break;
            }
        }
        return equal;
    }

    public static final String concatenate(boolean[] bb, String separator) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < bb.length; ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            sb.append(bb[i]);
        }
        return sb.toString();
    }

    public static final String concatenate(double[] ss, String separator) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < ss.length; ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            if (Double.isInfinite(ss[i])) {
                if (ss[i] < 0.0) {
                    sb.append("-");
                }
                sb.append("INF");
                continue;
            }
            if (Double.isNaN(ss[i])) {
                sb.append("NaN");
                continue;
            }
            sb.append(ss[i]);
        }
        return sb.toString();
    }

    public static final String concatenate(double[][] ss, String separator) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < ss.length; ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            sb.append(Util.concatenate(ss[i], separator));
        }
        return sb.toString();
    }

    public static final int[] splitToIntArray(String s, String delim) throws EuclidRuntimeException {
        String[] ss = s.split(delim);
        int[] ii = new int[ss.length];
        for (int i = 0; i < ss.length; ++i) {
            try {
                ii[i] = Integer.parseInt(ss[i]);
                continue;
            }
            catch (NumberFormatException nfe) {
                throw new EuclidRuntimeException("" + nfe);
            }
        }
        return ii;
    }

    public static final double[] splitToDoubleArray(String s) {
        return Util.splitToDoubleArray(s, " ");
    }

    public static double parseFlexibleDouble(String value) throws ParseException {
        if (value != null) {
            if ("INF".equals(value)) {
                return Double.POSITIVE_INFINITY;
            }
            if ("-INF".equals(value)) {
                return Double.NEGATIVE_INFINITY;
            }
            if ("NaN".equals(value)) {
                return Double.NaN;
            }
            try {
                return Double.valueOf(value);
            }
            catch (NumberFormatException e) {
                throw new ParseException(e.toString(), 0);
            }
        }
        throw new IllegalArgumentException("Null double string not allowed");
    }

    public static final double[] splitToDoubleArray(String s, String delim) throws EuclidRuntimeException {
        if (s == null) {
            throw new RuntimeException("null argument");
        }
        String[] ss = s.trim().split(delim);
        double[] dd = new double[ss.length];
        for (int i = 0; i < ss.length; ++i) {
            try {
                dd[i] = Util.parseFlexibleDouble(ss[i]);
                continue;
            }
            catch (NumberFormatException nfe) {
                throw new EuclidRuntimeException("" + nfe.getMessage(), nfe);
            }
            catch (ParseException e) {
                throw new EuclidRuntimeException("Bad double in (" + s + ") : " + ss[i] + "at position " + i, e);
            }
        }
        return dd;
    }

    public static final String concatenate(int[] ss, String separator) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < ss.length; ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            sb.append(ss[i]);
        }
        return sb.toString();
    }

    public static final String concatenate(String[] ss, String separator) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < ss.length; ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            sb.append(ss[i]);
        }
        String s = sb.toString();
        if (separator.trim().equals("")) {
            s = s.trim();
        }
        return s;
    }

    public static final boolean containsString(String[] strings, String s) {
        boolean b = false;
        if (s != null) {
            for (int i = 0; i < strings.length; ++i) {
                if (!s.equals(strings[i])) continue;
                b = true;
                break;
            }
        }
        return b;
    }

    public static double format(double d, int ndec) {
        int pow = 1;
        for (int i = 0; i < ndec; ++i) {
            pow *= 10;
        }
        return (double)Math.round(d * (double)pow) / (double)pow;
    }

    public static String trim(double d) {
        String s = "" + d;
        int idx = s.lastIndexOf(".");
        if (idx > 0) {
            int l;
            for (l = s.length() - 1; l > idx && s.charAt(l) == '0'; --l) {
            }
            if (l == idx) {
                --l;
            }
            s = s.substring(0, ++l);
        }
        return s;
    }

    public static List<String> createList(String[] ss) {
        ArrayList<String> list = new ArrayList<String>();
        for (String s : ss) {
            list.add(s);
        }
        return list;
    }

    public static int getPrime(int i) {
        int np;
        if (primeList == null) {
            primeList = new ArrayList<Integer>();
            primeList.add(new Integer(2));
            primeList.add(new Integer(3));
            primeList.add(new Integer(5));
            primeList.add(new Integer(7));
            primeList.add(new Integer(11));
        }
        int p = primeList.get(np - 1);
        for (np = primeList.size(); np <= i; ++np) {
            p = Util.nextPrime(p);
            primeList.add(new Integer(p));
        }
        return primeList.get(i);
    }

    private static int nextPrime(int pp) {
        int p = pp;
        while (!Util.isPrime(p += 2)) {
        }
        return p;
    }

    private static boolean isPrime(int p) {
        boolean prime = true;
        int sp = (int)Math.sqrt(p) + 1;
        for (int i = 1; i < primeList.size(); ++i) {
            int pp = primeList.get(i);
            if (p % pp == 0) {
                prime = false;
                break;
            }
            if (pp > sp) break;
        }
        return prime;
    }

    public static boolean isInt(String s) {
        boolean couldBeInt = true;
        try {
            new Integer(s);
        }
        catch (NumberFormatException e) {
            couldBeInt = false;
        }
        return couldBeInt;
    }

    public static boolean isIntArray(String s, String delimiterRegex) {
        boolean couldBeIntArray = true;
        String[] ss = s.split(delimiterRegex);
        try {
            new IntArray(ss);
        }
        catch (NumberFormatException e) {
            couldBeIntArray = false;
        }
        return couldBeIntArray;
    }

    public static boolean isFloatArray(String s, String delimiterRegex) {
        boolean couldBeFloatArray = true;
        String[] ss = s.split(delimiterRegex);
        try {
            new RealArray(ss);
        }
        catch (Exception e) {
            couldBeFloatArray = false;
        }
        return couldBeFloatArray;
    }

    public static boolean isFloat(String s) {
        boolean couldBeFloat = true;
        try {
            new Double(s);
        }
        catch (NumberFormatException e) {
            couldBeFloat = false;
        }
        return couldBeFloat;
    }

    public static String getCanonicalDate(String s) {
        String dateS = null;
        Pattern pattern = Pattern.compile(DATE_REGEX1, 2);
        Matcher matcher = pattern.matcher(s.toLowerCase());
        if (matcher.matches()) {
            int day = Integer.parseInt(matcher.group(1));
            String month = matcher.group(2).toLowerCase();
            boolean ignoreCase = true;
            int imonth = Util.indexOf(month, months, ignoreCase);
            int year = Integer.parseInt(matcher.group(3));
            dateS = "" + year + "-" + imonth + "-" + day;
        } else {
            pattern = Pattern.compile(DATE_REGEX2, 2);
            matcher = pattern.matcher(s.toLowerCase());
            if (matcher.matches()) {
                dateS = s;
            }
        }
        return dateS;
    }

    public static double getDouble(String s) {
        double d = Double.NaN;
        try {
            d = new Double(s);
        }
        catch (NumberFormatException nfe) {
            throw new RuntimeException("Bad double: " + s);
        }
        return d;
    }

    public static double trimFloat(double dd, int ndec) {
        int trim = 1;
        ndec = Math.min(ndec, 10);
        for (int i = 0; i < ndec; ++i) {
            trim *= 10;
        }
        return (double)((int)((double)trim * dd)) / (double)trim;
    }

    public static void sortByEmbeddedInteger(List<?> list) {
        StringIntegerComparator fic = new StringIntegerComparator();
        Collections.sort(list, fic);
    }

    public static void print(String s) {
        System.out.print(s);
    }

    public static void println(String s) {
        System.out.println(s);
    }

    public static void println() {
        System.out.println();
    }

    public static List<String> getRESTQueryAsLines(String s, String u, String mediaType) throws IOException {
        String line;
        byte[] content = Util.getRESTQuery(s, u, mediaType);
        BufferedReader br = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(content)));
        ArrayList<String> lines = new ArrayList<String>();
        while ((line = br.readLine()) != null) {
            lines.add(line);
        }
        return lines;
    }

    public static byte[] getRESTQuery(String serviceUrl, String urlString, String mediaType) throws IOException {
        URL url = new URL(urlString + serviceUrl);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.addRequestProperty("accept", mediaType);
        conn.connect();
        InputStream is = conn.getInputStream();
        byte[] bytes = IOUtils.toByteArray(is);
        conn.disconnect();
        return bytes;
    }

    public static String calculateMD5(String s) {
        String md5String = null;
        if (s != null && s.trim().length() > 0) {
            StringBuffer hexString = new StringBuffer();
            try {
                MessageDigest algorithm = MessageDigest.getInstance("MD5");
                algorithm.reset();
                algorithm.update(s.getBytes());
                byte[] messageDigest = algorithm.digest();
                for (int i = 0; i < messageDigest.length; ++i) {
                    hexString.append(Integer.toHexString(0xFF & messageDigest[i]));
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
            md5String = hexString.toString();
        }
        return md5String;
    }

    public static String getCanonicalPath(File file) {
        String path = null;
        try {
            File absoluteFile = file.getAbsoluteFile();
            path = absoluteFile.getCanonicalPath();
        }
        catch (IOException e) {
            throw new RuntimeException("cannot canonicalize " + file + " ... " + e.getMessage(), e);
        }
        return path;
    }

    public static String getRelativeFilename(File file1, File file2, String newSeparator) {
        if (newSeparator == null) {
            newSeparator = File.separator;
        }
        String regex = File.separator.equals("\\") ? "\\\\" : File.separator;
        String path = null;
        try {
            int j;
            String path1 = file1.getCanonicalPath();
            String path2 = file2.getCanonicalPath();
            String[] pathComponent1 = path1.split(regex);
            String[] pathComponent2 = path2.split(regex);
            for (int i = 0; i < pathComponent1.length && pathComponent2[i].equals(pathComponent1[i]); ++i) {
            }
            path = "";
            for (j = i; j < pathComponent1.length; ++j) {
                path = path + ".." + newSeparator;
            }
            for (j = i; j < pathComponent2.length - 1; ++j) {
                path = path + pathComponent2[j] + newSeparator;
            }
            path = path + pathComponent2[pathComponent2.length - 1];
        }
        catch (Exception e) {
            throw new RuntimeException("bad names/BUG", e);
        }
        return path;
    }

    static {
        Util.ISOLATIN_ENTITIES[160] = "_nbsp_";
        Util.ISOLATIN_ENTITIES[161] = "_iexcl_";
        Util.ISOLATIN_ENTITIES[162] = "_cent_";
        Util.ISOLATIN_ENTITIES[163] = "_pound_";
        Util.ISOLATIN_ENTITIES[164] = "_curren_";
        Util.ISOLATIN_ENTITIES[165] = "_yen_";
        Util.ISOLATIN_ENTITIES[166] = "_brvbar_";
        Util.ISOLATIN_ENTITIES[167] = "_sect_";
        Util.ISOLATIN_ENTITIES[168] = "_uml_";
        Util.ISOLATIN_ENTITIES[169] = "_copy_";
        Util.ISOLATIN_ENTITIES[170] = "_ordf_";
        Util.ISOLATIN_ENTITIES[171] = "_laquo_";
        Util.ISOLATIN_ENTITIES[172] = "_not_";
        Util.ISOLATIN_ENTITIES[173] = "_shy_";
        Util.ISOLATIN_ENTITIES[174] = "_reg_";
        Util.ISOLATIN_ENTITIES[175] = "_macr_";
        Util.ISOLATIN_ENTITIES[176] = "_deg_";
        Util.ISOLATIN_ENTITIES[177] = "_plusmn_";
        Util.ISOLATIN_ENTITIES[178] = "_sup2_";
        Util.ISOLATIN_ENTITIES[179] = "_sup3_";
        Util.ISOLATIN_ENTITIES[180] = "_acute_";
        Util.ISOLATIN_ENTITIES[181] = "_micro_";
        Util.ISOLATIN_ENTITIES[182] = "_para_";
        Util.ISOLATIN_ENTITIES[183] = "_middot_";
        Util.ISOLATIN_ENTITIES[184] = "_cedil_";
        Util.ISOLATIN_ENTITIES[185] = "_sup1_";
        Util.ISOLATIN_ENTITIES[186] = "_ordm_";
        Util.ISOLATIN_ENTITIES[187] = "_raquo_";
        Util.ISOLATIN_ENTITIES[188] = "_frac14_";
        Util.ISOLATIN_ENTITIES[189] = "_frac12_";
        Util.ISOLATIN_ENTITIES[190] = "_frac34_";
        Util.ISOLATIN_ENTITIES[191] = "_iquest_";
        Util.ISOLATIN_ENTITIES[192] = "_Agrave_";
        Util.ISOLATIN_ENTITIES[193] = "_Aacute_";
        Util.ISOLATIN_ENTITIES[194] = "_Acirc_";
        Util.ISOLATIN_ENTITIES[195] = "_Atilde_";
        Util.ISOLATIN_ENTITIES[196] = "_Auml_";
        Util.ISOLATIN_ENTITIES[197] = "_Aring_";
        Util.ISOLATIN_ENTITIES[198] = "_AElig_";
        Util.ISOLATIN_ENTITIES[199] = "_Ccedil_";
        Util.ISOLATIN_ENTITIES[200] = "_Egrave_";
        Util.ISOLATIN_ENTITIES[201] = "_Eacute_";
        Util.ISOLATIN_ENTITIES[202] = "_Ecirc_";
        Util.ISOLATIN_ENTITIES[203] = "_Euml_";
        Util.ISOLATIN_ENTITIES[204] = "_Igrave_";
        Util.ISOLATIN_ENTITIES[205] = "_Iacute_";
        Util.ISOLATIN_ENTITIES[206] = "_Icirc_";
        Util.ISOLATIN_ENTITIES[207] = "_Iuml_";
        Util.ISOLATIN_ENTITIES[208] = "_ETH_";
        Util.ISOLATIN_ENTITIES[209] = "_Ntilde_";
        Util.ISOLATIN_ENTITIES[210] = "_Ograve_";
        Util.ISOLATIN_ENTITIES[211] = "_Oacute_";
        Util.ISOLATIN_ENTITIES[212] = "_Ocirc_";
        Util.ISOLATIN_ENTITIES[213] = "_Otilde_";
        Util.ISOLATIN_ENTITIES[214] = "_Ouml_";
        Util.ISOLATIN_ENTITIES[215] = "_times_";
        Util.ISOLATIN_ENTITIES[216] = "_Oslash_";
        Util.ISOLATIN_ENTITIES[217] = "_Ugrave_";
        Util.ISOLATIN_ENTITIES[218] = "_Uacute_";
        Util.ISOLATIN_ENTITIES[219] = "_Ucirc_";
        Util.ISOLATIN_ENTITIES[220] = "_Uuml_";
        Util.ISOLATIN_ENTITIES[221] = "_Yacute_";
        Util.ISOLATIN_ENTITIES[222] = "_THORN_";
        Util.ISOLATIN_ENTITIES[223] = "_szlig_";
        Util.ISOLATIN_ENTITIES[224] = "_agrave_";
        Util.ISOLATIN_ENTITIES[225] = "_aacute_";
        Util.ISOLATIN_ENTITIES[226] = "_acirc_";
        Util.ISOLATIN_ENTITIES[227] = "_atilde_";
        Util.ISOLATIN_ENTITIES[228] = "_auml_";
        Util.ISOLATIN_ENTITIES[229] = "_aring_";
        Util.ISOLATIN_ENTITIES[230] = "_aelig_";
        Util.ISOLATIN_ENTITIES[231] = "_ccedil_";
        Util.ISOLATIN_ENTITIES[232] = "_egrave_";
        Util.ISOLATIN_ENTITIES[233] = "_eacute_";
        Util.ISOLATIN_ENTITIES[234] = "_ecirc_";
        Util.ISOLATIN_ENTITIES[235] = "_euml_";
        Util.ISOLATIN_ENTITIES[236] = "_igrave_";
        Util.ISOLATIN_ENTITIES[237] = "_iacute_";
        Util.ISOLATIN_ENTITIES[238] = "_icirc_";
        Util.ISOLATIN_ENTITIES[239] = "_iuml_";
        Util.ISOLATIN_ENTITIES[240] = "_eth_";
        Util.ISOLATIN_ENTITIES[241] = "_ntilde_";
        Util.ISOLATIN_ENTITIES[242] = "_ograve_";
        Util.ISOLATIN_ENTITIES[243] = "_oacute_";
        Util.ISOLATIN_ENTITIES[244] = "_ocirc_";
        Util.ISOLATIN_ENTITIES[245] = "_otilde_";
        Util.ISOLATIN_ENTITIES[246] = "_ouml_";
        Util.ISOLATIN_ENTITIES[247] = "_divide_";
        Util.ISOLATIN_ENTITIES[248] = "_oslash_";
        Util.ISOLATIN_ENTITIES[249] = "_ugrave_";
        Util.ISOLATIN_ENTITIES[250] = "_uacute_";
        Util.ISOLATIN_ENTITIES[251] = "_ucirc_";
        Util.ISOLATIN_ENTITIES[252] = "_uuml_";
        Util.ISOLATIN_ENTITIES[253] = "_yacute_";
        Util.ISOLATIN_ENTITIES[254] = "_thorn_";
        Util.ISOLATIN_ENTITIES[255] = "_yuml_";
        GREEK_ENTITIES = new String[200];
        Util.GREEK_ENTITIES[145] = "Alpha";
        Util.GREEK_ENTITIES[146] = "Beta";
        Util.GREEK_ENTITIES[147] = "Gamma";
        Util.GREEK_ENTITIES[148] = "Delta";
        Util.GREEK_ENTITIES[149] = "Epsilon";
        Util.GREEK_ENTITIES[150] = "Zeta";
        Util.GREEK_ENTITIES[151] = "Eta";
        Util.GREEK_ENTITIES[152] = "Theta";
        Util.GREEK_ENTITIES[153] = "Iota";
        Util.GREEK_ENTITIES[154] = "Kappa";
        Util.GREEK_ENTITIES[155] = "Lambda";
        Util.GREEK_ENTITIES[156] = "Mu";
        Util.GREEK_ENTITIES[157] = "Nu";
        Util.GREEK_ENTITIES[158] = "Omicron";
        Util.GREEK_ENTITIES[159] = "Pi";
        Util.GREEK_ENTITIES[160] = "Rho";
        Util.GREEK_ENTITIES[161] = "Sigma";
        Util.GREEK_ENTITIES[162] = "Tau";
        Util.GREEK_ENTITIES[163] = "Upsilon";
        Util.GREEK_ENTITIES[164] = "Phi";
        Util.GREEK_ENTITIES[165] = "Phi";
        Util.GREEK_ENTITIES[166] = "Psi";
        Util.GREEK_ENTITIES[167] = "Omega";
        Util.GREEK_ENTITIES[177] = "alpha";
        Util.GREEK_ENTITIES[178] = "beta";
        Util.GREEK_ENTITIES[179] = "gamma";
        Util.GREEK_ENTITIES[180] = "delta";
        Util.GREEK_ENTITIES[181] = "epsilon";
        Util.GREEK_ENTITIES[182] = "zeta";
        Util.GREEK_ENTITIES[183] = "eta";
        Util.GREEK_ENTITIES[184] = "theta";
        Util.GREEK_ENTITIES[185] = "iota";
        Util.GREEK_ENTITIES[186] = "kappa";
        Util.GREEK_ENTITIES[187] = "lambda";
        Util.GREEK_ENTITIES[188] = "mu";
        Util.GREEK_ENTITIES[189] = "nu";
        Util.GREEK_ENTITIES[190] = "omicron";
        Util.GREEK_ENTITIES[191] = "pi";
        Util.GREEK_ENTITIES[192] = "rho";
        Util.GREEK_ENTITIES[193] = "sigma";
        Util.GREEK_ENTITIES[194] = "tau";
        Util.GREEK_ENTITIES[195] = "upsilon";
        Util.GREEK_ENTITIES[196] = "phi";
        Util.GREEK_ENTITIES[197] = "chi";
        Util.GREEK_ENTITIES[198] = "psi";
        Util.GREEK_ENTITIES[199] = "omega";
        UPPER_GREEK_ENTITIES = new String[968];
        Util.UPPER_GREEK_ENTITIES[912] = "Alpha";
        Util.UPPER_GREEK_ENTITIES[914] = "Beta";
        Util.UPPER_GREEK_ENTITIES[915] = "Gamma";
        Util.UPPER_GREEK_ENTITIES[916] = "Delta";
        Util.UPPER_GREEK_ENTITIES[917] = "Epsilon";
        Util.UPPER_GREEK_ENTITIES[918] = "Zeta";
        Util.UPPER_GREEK_ENTITIES[919] = "Eta";
        Util.UPPER_GREEK_ENTITIES[920] = "Theta";
        Util.UPPER_GREEK_ENTITIES[921] = "Iota";
        Util.UPPER_GREEK_ENTITIES[922] = "Kappa";
        Util.UPPER_GREEK_ENTITIES[923] = "Lambda";
        Util.UPPER_GREEK_ENTITIES[924] = "Mu";
        Util.UPPER_GREEK_ENTITIES[925] = "Nu";
        Util.UPPER_GREEK_ENTITIES[926] = "Omicron";
        Util.UPPER_GREEK_ENTITIES[927] = "Pi";
        Util.UPPER_GREEK_ENTITIES[928] = "Rho";
        Util.UPPER_GREEK_ENTITIES[929] = "Sigma";
        Util.UPPER_GREEK_ENTITIES[930] = "Tau";
        Util.UPPER_GREEK_ENTITIES[931] = "Upsilon";
        Util.UPPER_GREEK_ENTITIES[932] = "Phi";
        Util.UPPER_GREEK_ENTITIES[933] = "Phi";
        Util.UPPER_GREEK_ENTITIES[934] = "Psi";
        Util.UPPER_GREEK_ENTITIES[935] = "Omega";
        Util.UPPER_GREEK_ENTITIES[945] = "alpha";
        Util.UPPER_GREEK_ENTITIES[946] = "beta";
        Util.UPPER_GREEK_ENTITIES[947] = "gamma";
        Util.UPPER_GREEK_ENTITIES[948] = "delta";
        Util.UPPER_GREEK_ENTITIES[949] = "epsilon";
        Util.UPPER_GREEK_ENTITIES[950] = "zeta";
        Util.UPPER_GREEK_ENTITIES[951] = "eta";
        Util.UPPER_GREEK_ENTITIES[952] = "theta";
        Util.UPPER_GREEK_ENTITIES[953] = "iota";
        Util.UPPER_GREEK_ENTITIES[954] = "kappa";
        Util.UPPER_GREEK_ENTITIES[955] = "lambda";
        Util.UPPER_GREEK_ENTITIES[956] = "mu";
        Util.UPPER_GREEK_ENTITIES[957] = "nu";
        Util.UPPER_GREEK_ENTITIES[958] = "omicron";
        Util.UPPER_GREEK_ENTITIES[959] = "pi";
        Util.UPPER_GREEK_ENTITIES[960] = "rho";
        Util.UPPER_GREEK_ENTITIES[961] = "sigma";
        Util.UPPER_GREEK_ENTITIES[962] = "tau";
        Util.UPPER_GREEK_ENTITIES[963] = "upsilon";
        Util.UPPER_GREEK_ENTITIES[964] = "phi";
        Util.UPPER_GREEK_ENTITIES[965] = "chi";
        Util.UPPER_GREEK_ENTITIES[966] = "psi";
        Util.UPPER_GREEK_ENTITIES[967] = "omega";
        GREEK2CHARACTER_MAP = new HashMap<String, Character>();
        GREEK2CHARACTER_MAP.put("Alpha", Character.valueOf('\u0390'));
        GREEK2CHARACTER_MAP.put("Beta", Character.valueOf('\u0392'));
        GREEK2CHARACTER_MAP.put("Gamma", Character.valueOf('\u0393'));
        GREEK2CHARACTER_MAP.put("Delta", Character.valueOf('\u0394'));
        GREEK2CHARACTER_MAP.put("Epsilon", Character.valueOf('\u0395'));
        GREEK2CHARACTER_MAP.put("Zeta", Character.valueOf('\u0396'));
        GREEK2CHARACTER_MAP.put("Eta", Character.valueOf('\u0397'));
        GREEK2CHARACTER_MAP.put("Theta", Character.valueOf('\u0398'));
        GREEK2CHARACTER_MAP.put("Iota", Character.valueOf('\u0399'));
        GREEK2CHARACTER_MAP.put("Kappa", Character.valueOf('\u039a'));
        GREEK2CHARACTER_MAP.put("Lambda", Character.valueOf('\u039b'));
        GREEK2CHARACTER_MAP.put("Mu", Character.valueOf('\u039c'));
        GREEK2CHARACTER_MAP.put("Nu", Character.valueOf('\u039d'));
        GREEK2CHARACTER_MAP.put("Omicron", Character.valueOf('\u039e'));
        GREEK2CHARACTER_MAP.put("Pi", Character.valueOf('\u039f'));
        GREEK2CHARACTER_MAP.put("Rho", Character.valueOf('\u03a0'));
        GREEK2CHARACTER_MAP.put("Sigma", Character.valueOf('\u03a1'));
        GREEK2CHARACTER_MAP.put("Tau", Character.valueOf('\u03a2'));
        GREEK2CHARACTER_MAP.put("Upsilon", Character.valueOf('\u03a3'));
        GREEK2CHARACTER_MAP.put("Phi", Character.valueOf('\u03a4'));
        GREEK2CHARACTER_MAP.put("Phi", Character.valueOf('\u03a5'));
        GREEK2CHARACTER_MAP.put("Psi", Character.valueOf('\u03a6'));
        GREEK2CHARACTER_MAP.put("Omega", Character.valueOf('\u03a7'));
        GREEK2CHARACTER_MAP.put("alpha", Character.valueOf('\u03b1'));
        GREEK2CHARACTER_MAP.put("beta", Character.valueOf('\u03b2'));
        GREEK2CHARACTER_MAP.put("gamma", Character.valueOf('\u03b3'));
        GREEK2CHARACTER_MAP.put("delta", Character.valueOf('\u03b4'));
        GREEK2CHARACTER_MAP.put("epsilon", Character.valueOf('\u03b5'));
        GREEK2CHARACTER_MAP.put("zeta", Character.valueOf('\u03b6'));
        GREEK2CHARACTER_MAP.put("eta", Character.valueOf('\u03b7'));
        GREEK2CHARACTER_MAP.put("theta", Character.valueOf('\u03b8'));
        GREEK2CHARACTER_MAP.put("iota", Character.valueOf('\u03b9'));
        GREEK2CHARACTER_MAP.put("kappa", Character.valueOf('\u03ba'));
        GREEK2CHARACTER_MAP.put("lambda", Character.valueOf('\u03bb'));
        GREEK2CHARACTER_MAP.put("mu", Character.valueOf('\u03bc'));
        GREEK2CHARACTER_MAP.put("nu", Character.valueOf('\u03bd'));
        GREEK2CHARACTER_MAP.put("omicron", Character.valueOf('\u03be'));
        GREEK2CHARACTER_MAP.put("pi", Character.valueOf('\u03bf'));
        GREEK2CHARACTER_MAP.put("rho", Character.valueOf('\u03c0'));
        GREEK2CHARACTER_MAP.put("sigma", Character.valueOf('\u03c1'));
        GREEK2CHARACTER_MAP.put("tau", Character.valueOf('\u03c2'));
        GREEK2CHARACTER_MAP.put("upsilon", Character.valueOf('\u03c3'));
        GREEK2CHARACTER_MAP.put("phi", Character.valueOf('\u03c4'));
        GREEK2CHARACTER_MAP.put("chi", Character.valueOf('\u03c5'));
        GREEK2CHARACTER_MAP.put("psi", Character.valueOf('\u03c6'));
        GREEK2CHARACTER_MAP.put("omega", Character.valueOf('\u03c7'));
        formTable = new Hashtable();
        months = new String[]{"jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec"};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Message {
        NYI("not yet implemented");

        public String value;

        private Message(String v) {
            this.value = v;
        }
    }
}

