/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.euclid;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.xmlcml.euclid.IntRange;

public class IntRangeArray
implements Iterable<IntRange> {
    private static final PrintStream SYSOUT = System.out;
    private List<IntRange> rangeList;

    public IntRangeArray() {
        this.init();
    }

    public IntRangeArray(List<IntRange> ranges) {
        this.init();
        this.rangeList.addAll(ranges);
    }

    public IntRangeArray(IntRangeArray array) {
        this();
        for (IntRange range : array.rangeList) {
            this.add(new IntRange(range));
        }
    }

    private void init() {
        this.rangeList = new ArrayList<IntRange>();
    }

    public void add(IntRange range) {
        this.rangeList.add(range);
    }

    public void sort() {
        Collections.sort(this.rangeList);
    }

    public void sortAndRemoveOverlapping() {
        this.sort();
        ArrayList<IntRange> newList = new ArrayList<IntRange>();
        Iterator<IntRange> iterator = this.rangeList.iterator();
        IntRange lastRange = null;
        while (iterator.hasNext()) {
            IntRange range = iterator.next();
            if (lastRange == null) {
                newList.add(range);
                lastRange = range;
                continue;
            }
            boolean intersects = lastRange.intersectsWith(range);
            if (intersects) {
                IntRange merged = lastRange.plus(range);
                newList.set(newList.size() - 1, merged);
                lastRange = merged;
                continue;
            }
            newList.add(range);
            lastRange = range;
        }
        this.rangeList = newList;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof IntRangeArray)) {
            return false;
        }
        IntRangeArray array2 = (IntRangeArray)obj;
        if (this.size() != array2.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).equals(array2.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = 17;
        for (int i = 0; i < this.rangeList.size(); ++i) {
            h += this.rangeList.get(i).hashCode() * 31;
        }
        return h;
    }

    public int size() {
        return this.rangeList.size();
    }

    public IntRange get(int serial) {
        return this.rangeList.get(serial);
    }

    public void debug() {
        for (IntRange range : this.rangeList) {
            SYSOUT.println(range);
        }
    }

    public IntRangeArray plus(IntRangeArray array) {
        IntRangeArray newArray = null;
        if (array != null) {
            newArray = new IntRangeArray();
            for (IntRange intRange : this.rangeList) {
                newArray.add(new IntRange(intRange));
            }
            for (IntRange intRange : array.rangeList) {
                newArray.add(new IntRange(intRange));
            }
            newArray.sortAndRemoveOverlapping();
        }
        return newArray;
    }

    public IntRangeArray inverse() {
        IntRangeArray newArray = null;
        IntRangeArray copy = new IntRangeArray(this);
        copy.sortAndRemoveOverlapping();
        if (copy.size() > 0) {
            newArray = new IntRangeArray();
            IntRange last = null;
            for (IntRange current : copy) {
                if (last != null) {
                    IntRange gap = new IntRange(last.maxval, current.minval);
                    newArray.add(gap);
                }
                last = current;
            }
        }
        return newArray;
    }

    @Override
    public Iterator<IntRange> iterator() {
        return this.rangeList.iterator();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (IntRange range : this.rangeList) {
            sb.append(range.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

