% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.r
\name{plot_activity}
\alias{plot_activity}
\title{Plot the density of submissions over time.}
\usage{
plot_activity(
  history,
  baseline = "baseline",
  col = 1:length(history),
  alpha.f = 0.7,
  bw = 3600 * 24,
  by = 4,
  xlab = "Date",
  ylab = "Submissions intensity",
  bty = "l",
  fg = "darkslategray",
  col.axis = fg,
  col.lab = fg,
  text.col = fg,
  ...
)
}
\arguments{
\item{history}{list of the submissions history per team as returned by \code{\link{compute_metrics}}}

\item{baseline}{string. name of the team considered as the baseline that will not be plotted.}

\item{col}{colors of the teams.}

\item{alpha.f}{factor modifying the opacity alpha of colors; typically in [0,1].}

\item{bw}{real. the smoothing bandwidth to be used by \code{\link[stats]{density}} in seconds.}

\item{by}{real. height of the interval between two teams in nb of submissions.}

\item{xlab, ylab}{axis labels. see \code{\link[graphics]{title}}.}

\item{bty, fg, col.axis, col.lab}{graphical parameters. see \code{\link[graphics]{par}}.}

\item{text.col}{the color used for the legend text. see \code{\link[graphics]{legend}}.}

\item{...}{further parameters passed to \code{\link[graphics]{plot}} function.}
}
\value{
\code{NULL}
}
\description{
Plot the density of submissions over time.
}
\seealso{
\code{\link[stats]{density}}
}
