% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cramerV.r
\name{cramerV}
\alias{cramerV}
\title{Cramer's V (phi)}
\usage{
cramerV(x, y = NULL, digits = 4, bias.correct = FALSE, ...)
}
\arguments{
\item{x}{Either a two-way table or a two-way matrix.
Can also be a vector of observations for one dimension
of a two-way table.}

\item{y}{If \code{x} is a vector, \code{y} is the vector of observations for
the second dimension of a two-way table.}

\item{digits}{The number of significant digits in the output.}

\item{bias.correct}{If \code{TRUE}, a bias correction is applied.}

\item{...}{Additional arguments passed to \code{chisq.test}.}
}
\value{
A single statistic, Cramer's V.
}
\description{
Calculates Cramer's V for a table of nominal variables.
}
\details{
Cramer's V is used as a measure of association
          between two nominal variables, or as an effect size
          for a chi-square test of association.  For a 2 x 2 table,
          the absolute value of the phi statistic is the same as
          Cramer's V.
}
\examples{
### Example with table
data(Anderson)
fisher.test(Anderson)
cramerV(Anderson)

### Example with two vectors
Species = c(rep("Species1", 16), rep("Species2", 16))
Color   = c(rep(c("blue", "blue", "blue", "green"),4),
            rep(c("green", "green", "green", "blue"),4))
fisher.test(Species, Color)
cramerV(Species, Color)

}
\references{
\url{http://rcompanion.org/handbook/H_10.html}
}
\seealso{
\code{\link{cohenW}}
}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\concept{correlation phi cramer V}
