% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwiseMcnemar.r
\name{pairwiseMcnemar}
\alias{pairwiseMcnemar}
\title{Pairwise McNemar and related tests for Cochran Q test post-hoc}
\usage{
pairwiseMcnemar(
  formula = NULL,
  data = NULL,
  x = NULL,
  g = NULL,
  block = NULL,
  test = "exact",
  method = "fdr",
  digits = 3,
  correct = FALSE
)
}
\arguments{
\item{formula}{A formula indicating the measurement variable and
the grouping variable. e.g. y ~ group | block.}

\item{data}{The data frame to use.}

\item{x}{The response variable.}

\item{g}{The grouping variable.}

\item{block}{The blocking variable.}

\item{test}{If \code{"exact"}, conducts an exact test of symmetry
analogous to a McNemar test.
If \code{"mcnemar"}, conducts a McNemar test of symmetry.
If \code{"permutation"}, conducts a permutation test 
analogous to a McNemar test.}

\item{method}{The method for adjusting multiple p-values.
See \code{\link{p.adjust}}.}

\item{digits}{The number of significant digits in the output.}

\item{correct}{If \code{TRUE}, applies a continuity correction
for the McNemar test.}
}
\value{
A list containing: a data frame of results of the global test;
        a data frame of results of the pairwise results;
        and a data frame mentioning the p-value adjustment method.
}
\description{
Conducts pairwise McNemar, exact, and permutation
             tests as a post-hoc to Cochran Q test.
}
\details{
The component tables for the pairwise tests
         must be of size 2 x 2.
         
         The input should include either \code{formula} and \code{data};
         or \code{x}, \code{g}, and \code{block}.
}
\note{
The parsing of the formula is simplistic. 
         The first variable on the
         left side is used as the measurement variable.  
         The first variable on the
         right side is used for the grouping variable.
         The second variable on the
         right side is used for the blocking variable.
}
\examples{
### Cochran Q post-hoc example
data(HayleySmith)
library(DescTools)
CochranQTest(Response ~ Practice | Student,
             data = HayleySmith)
HayleySmith$Practice = factor(HayleySmith$Practice,
                          levels = c("MowHeight", "SoilTest",
                                     "Clippings", "Irrigation"))
PT = pairwiseMcnemar(Response ~ Practice | Student,
                     data    = HayleySmith,
                     test    = "exact",
                     method  = "fdr",
                     digits  = 3)
PT
PT = PT$Pairwise
cldList(comparison = PT$Comparison,
        p.value    = PT$p.adjust,
        threshold  = 0.05)
                                                             
}
\references{
\url{http://rcompanion.org/handbook/H_07.html}
}
\seealso{
\code{\link{nominalSymmetryTest}}, \code{\link{groupwiseCMH}},
         \code{\link{pairwiseNominalIndependence}}, 
         \code{\link{pairwiseNominalMatrix}}
}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\concept{McNemar Cochran Q permutation exact}
