% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_dependencies.R
\name{add_dependencies}
\alias{add_dependencies}
\title{Add dependencies in DESCRIPTION}
\usage{
add_dependencies(compendium = NULL)
}
\arguments{
\item{compendium}{A character of length 1. The name of the folder to
recursively detect dependencies to be added to the \code{Imports} field of
\code{DESCRIPTION} file. It can be \code{'analysis/'} (if additional folders, i.e.
\verb{data/}, \verb{outputs/}, \verb{figures/}, etc. have been created in this folder),
\code{'.'} (if folders \verb{data/}, \verb{outputs/}, \verb{figures/}, etc. have been created
at the root of the project), etc.
See \code{\link[=new_compendium]{new_compendium()}} for further information.

Default is \code{compendium = NULL} (i.e. no additional folder are inspected
but \verb{R/}, \code{NAMESPACE}, \verb{vignettes/}, and \verb{tests/} are still inspected).}
}
\value{
No return value.
}
\description{
This function detects external dependencies used in \verb{R/}, \code{NAMESPACE}, and
\verb{@examples} sections of \code{roxygen2} headers and automatically adds these
dependencies in the \code{Imports} section of the \code{DESCRIPTION} file.

In the \code{NAMESPACE} this function detects dependencies mentioned as
\code{import(pkg)} and \code{importFrom(pkg,fun)}.

In the \verb{R/} folder it detects functions called as \code{pkg::fun()} in the code
of each R files. In \verb{@examples} sections it also detects packages attached
by \code{library()} or \code{require()}.

The \verb{vignettes/} folder is also inspected and detected dependencies
(\code{pkg::fun()}, \code{library()} or \code{require()}) are added to the \code{Suggests}
field of the \code{DESCRIPTION} file (in addition to the packages
\href{https://yihui.org/knitr/}{\code{knitr}} and
\href{https://rmarkdown.rstudio.com/}{\code{rmarkdown}}).

If the project is a research compendium user can also inspect additional
folder(s) with the argument \code{compendium} to add dependencies to the
\code{Imports} section of the \code{DESCRIPTION} file. The detection process is the
same as the one used for \verb{vignettes/}.

The \verb{tests/} folder is also inspected and detected dependencies
(\code{pkg::fun()}, \code{library()} or \code{require()}) are added to the \code{Suggests}
field of the \code{DESCRIPTION} file (in addition to the package
\href{https://testthat.r-lib.org}{\code{testthat}}).
}
\examples{
\dontrun{
add_dependencies()
}
}
\seealso{
Other development functions: 
\code{\link{add_github_actions_check}()},
\code{\link{add_github_actions_codecov}()},
\code{\link{add_github_actions_pkgdown}()},
\code{\link{add_github_actions_render}()},
\code{\link{add_r_depend}()},
\code{\link{add_to_buildignore}()},
\code{\link{add_to_gitignore}()}
}
\concept{development functions}
