% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_climate.R
\name{generate_climate}
\alias{generate_climate}
\title{Generate climate dataset}
\usage{
generate_climate(
  x,
  y,
  tz,
  era5land_hour,
  era5land_month,
  daytime_start = 7,
  daytime_end = 19
)
}
\arguments{
\item{x}{num. Longitude in UTM. Can be obtained from the location name with
the function geo_lite_sf from the package nominatimlite.}

\item{y}{num. Latitude in UTM. Can be obtained from the location name with
the function geo_lite_sf from the package nominatimlite.}

\item{tz}{num. Time zone. Can be obtained from the coordinates with the
function tz_lookup_coords from the package lutz.}

\item{era5land_hour}{str. Path to ERA5 land data monthly averaged reanalysis
by hour of day in netCDF. See the corresponding vignette to download
corresponding data from Copernicus in R.}

\item{era5land_month}{str. Path to ERA5 land data monthly averaged reanalysis
in netCDF. See the corresponding vignette to download corresponding data
from Copernicus in R.}

\item{daytime_start}{int. Daytime starting hour to compute nigh and day
variables (default 7).}

\item{daytime_end}{int. Daytime ending hour to compute nigh and day variables
(default 19).}
}
\value{
A list with two tables: daytimevar and climatedaytime12.
}
\description{
TROLL forest simulator relies on climate tables with half-hourly variations
of a typical day and monthly variations of a typical year which are recycled
through simulation days and years. Initially, TROLL climate tables were
computed from the Nouraflux dataset. Variations in quantities of interests
(temperatures, ...) were averaged to the target resolution (half-hour for
daily variation or month for monthly variation). The purpose of climate
generation functions is to compute equivalent climate tables from the ERA5
land reanalysis dataset. With these functions, rcontroll users only need
inventories and associated functional traits to run TROLL simulations. See
the corresponding vignette for further details.
}
