% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HPDataFrame.R
\name{HPDataFrame}
\alias{HPDataFrame}
\title{HPDataFrame class}
\usage{
HPDataFrame(..., nside, ordering = "nested", auto.spix = FALSE, spix,
  assumedUniquePix = FALSE, delete.duplicates = FALSE,
  save.dots = FALSE, save.duplicate.indices = FALSE)
}
\arguments{
\item{...}{Data. Can be named vectors or a data.frame. May
include columns (x,y,z) or (theta, phi) representing
Cartesian or spherical coordinates
of points on the unit sphere.}

\item{nside}{Integer number \eqn{2^k}, the nside
parameter, i.e, resolution. If \code{nside} is unspecified, then
the an attempt is made to use columns x,y and z from the provided
data, as Cartesian coordinates, to calculate an nside that is
sufficient to ensure all points belong to unique pixels.}

\item{ordering}{The HEALPix ordering scheme ("ring" or "nested").}

\item{auto.spix}{Boolean. If TRUE then spix will be found from
the coordinates provided in the data. That is, each row of
data will be assigned the pixel index of its closest HEALPix
pixel center. There must be columns x,y,z for cartesian or
theta, phi for spherical colatitude and longitude respectively.
If \code{auto.spix = FALSE} then \code{nside} must be specified.}

\item{spix}{A vector of HEALPix pixel indices indicating the
pixel locations of the data. Note that \code{spix} is ignored
if \code{auto.spix = TRUE}.}

\item{assumedUniquePix}{A boolean. Sets the \code{assumedUniquePix}
attribute of the HPDataFrame. This attribute indicates whether
or not the rows of a HPDataFrame can be assumed to belong to
unique pixels.}

\item{delete.duplicates}{Boolean. If TRUE then rows
corresponding to duplicate pixel indices will be dropped
from the returned HPDataFrame, and assumedUniquePix will
be set to TRUE.}

\item{save.dots}{A logical. If \code{TRUE} then the
dot product of each observation with the nearest
child HEALPix pixel
center will be stored as a column called "distance" in the returned
\code{HPDataFrame}, provided that \code{auto.spix = TRUE}.
Note that a 'child' pixel is any one of the
four pixels contained in the current pixel, in the nested
scheme, at the next highest resolution.
See \code{\link[rcosmo]{children}}.}

\item{save.duplicate.indices}{A logical. If \code{TRUE} and
\code{delete.duplicates} is also \code{TRUE}, then the
row indices of duplicated pixels will be retained
as an attribute called "duplicates". Note
that row index refers to the row position of the
duplicated pixel in the original \code{HPDataFrame},
and not the actual pixel index itself.}
}
\description{
HPDataFrames are a type of \code{data.frame} designed to carry
data located on the unit sphere. Each row of a \code{HPDataFrame}
is associated with a HEALPix pixel index. The \code{HPDataFrame}
also holds an attribute called \code{nside} which stores the
HEALPix Nside parameter (i.e., the resolution of the HEALPix grid
that is being used).
Unlike \code{\link{CMBDataFrame}}, HPDataFrames may have
repeated pixel indices. They are made this way so that
multiple data points falling within a given pixel
can be stored in different rows of any given HPDataFrame.
}
\details{
\code{HPDataFrame} with \code{auto.spix = TRUE} can be used to transform any
spherical data (not necessarily CMB) to the Healpix representation, see
Example 3 below.
}
\examples{

##Example 1.

hp1 <- HPDataFrame(I=rnorm(5), nside = 1, spix = c(1,1,2,2,3))
pix(hp1)
coords(hp1, new.coords = "cartesian")
class(hp1)
assumedUniquePix(hp1)

##Example 2.

# Where nside is not specified
sky <- CMBDataFrame(nside = 32, coords = "cartesian", ordering = "nested")
sky.s <- CMBDataFrame(sky, sample.size = 100)
hpdf <- HPDataFrame(sky.s, auto.spix = TRUE)
class(hpdf)
assumedUniquePix(hpdf)


# ## Example 3.
# ## Create a HPDataFrame with NON-UNIQUE pixel indices
#
# ## With earth data.
# ## Download World Cities Database from
# ## https://simplemaps.com/static/data/world-cities/basic/simplemaps_worldcities_basicv1.4.zip
# ## unpack the file worldcities.csv
#
# worldcities <- read.csv("worldcities.csv")
#
# ## Prepare a data frame with cities' coordinates
# sph <- geo2sph(data.frame(lon = pi/180*worldcities$lng,
#                           lat = pi/180*worldcities$lat))
# df <- data.frame(phi = sph$phi,
#                  theta = sph$theta,
#                  I = rep(1,nrow(sph)))
#
# ## Create and plot the corresponding HPDataFrame with
# ## pixel indices that are not necessarily unique
# ## by choosing your desired resolution (nside)
# hp <- HPDataFrame(usdf, auto.spix = TRUE, nside = 1024)
# plot(hp, size = 3, col = "darkgreen", back.col = "white")
# ## Add some pixels to visualise the sphere
# plot(CMBDataFrame(nside = 64), add = TRUE, col = "gray")

# ## Example 4.
# ## Create a HPDataFrame with UNIQUE pixel indices.
#
# ## With earth data.
# ## Download World Cities Database from
# ## https://simplemaps.com/static/data/world-cities/basic/simplemaps_worldcities_basicv1.4.zip
# ## unpack the file worldcities.csv
#
# worldcities <- read.csv("worldcities.csv")
# uscities <- worldcities[worldcities$country == "United States",]
#
# ## Prepare a data frame with cities' coordinates
# sph <- geo2sph(data.frame(lon = pi/180*uscities$lng,
#                           lat = pi/180*uscities$lat))
# usdf <- data.frame(phi = sph$phi,
#                    theta = sph$theta,
#                    I = rep(1,nrow(sph)))
#
# ## Select k cities with unique coordinates. The
# ## coordinates must be unique otherwise the
# ## automatically chosen separating nside
# ## will be infinite.
# k <- 1000
# usdf <- usdf[sample(nrow(usdf), k), ]
# plot(usdf$phi, usdf$theta)
# usdf[duplicated(usdf), ]
# usdf <- usdf[!duplicated(usdf), ]
# usdf[duplicated(usdf), ]
# usdf <- coords(usdf, new.coords = "cartesian")
#
# ## Create and plot the corresponding HPDataFrame . To make
# ## sure the pixels are unique, do not select a resolution
# ## resolution (nside), since it will be chosen automatically.
# ushp <- HPDataFrame(usdf, auto.spix = TRUE)
# nside(ushp)
# assumedUniquePix(ushp)
# plot(ushp, size = 3, col = "darkgreen", back.col = "white")
# ## Add some pixels to visualise the sphere
# plot(CMBDataFrame(nside = 64), add = TRUE, col = "gray")

}
