% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CMBWindowGenerics.R
\name{plot.CMBWindow}
\alias{plot.CMBWindow}
\title{Visualise a \code{\link{CMBWindow}}}
\usage{
\method{plot}{CMBWindow}(x, add = TRUE, type = "l", col = "red",
  size = 2, box = FALSE, axes = FALSE, aspect = FALSE, back.col,
  depth_test = "always", ...)
}
\arguments{
\item{x}{A CMBWindow.}

\item{add}{if TRUE then this plot will be added to any existing plot.
Note that if \code{back.col} (see below) is specified then a new plot
window will be opened and \code{add = TRUE} will have no effect}

\item{type}{a single character indicating the type of item to plot.
Supported types are: 'p' for points, 's' for spheres, 'l' for lines,
'h' for line segments from z = 0, and 'n' for nothing.}

\item{col}{specify the colour(s) of the plotted points}

\item{size}{the size of plotted points}

\item{box}{whether to draw a box}

\item{axes}{whether to draw axes}

\item{aspect}{either a logical indicating whether to adjust the
aspect ratio, or a new ratio.}

\item{back.col}{specifies the background colour of
the plot. This argument is passed to rgl::bg3d.}

\item{depth_test}{The depth test to be applied.
This controls how resistant the plotted
object is to being obscured.
See \code{\link[rgl]{rgl.material}}}

\item{...}{arguments passed to rgl::plot3d}
}
\description{
Visualise a \code{\link{CMBWindow}}
}
\examples{

win1 <- CMBWindow(theta = c(0,pi/2,pi/2), phi = c(0,0,pi/2))
win2 <- CMBWindow(theta = c(2*pi/3,3*pi/4,3*pi/4, 2*pi/3), phi = c(pi/4,pi/4,pi/3,pi/3))
plot(win1)
plot(win2)

}
