% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Statistics.R
\name{entropyCMB}
\alias{entropyCMB}
\title{CMB Entropy}
\usage{
entropyCMB(cmbdf, win, intensities = "I", method)
}
\arguments{
\item{cmbdf}{A \code{\link{CMBDataFrame}}.}

\item{win}{A \code{\link{CMBWindow}}}

\item{intensities}{A \code{\link{CMBDataFrame}} column with measured values.}

\item{method}{A method to estimate entropy, see \link{entropy}}
}
\value{
Estimated Shannon entropy for observations in \code{\link{CMBWindow}}
}
\description{
This function returns an estimated entropy for the specified
\code{\link{CMBDataFrame}} column  \code{intensities} and \code{\link{CMBWindow}}
region. The functions employs the function \link{entropy} and uses histogram
counts of \code{intensities} for computations. All arguments of the standard
\link{entropy} can be used.
}
\examples{
## Download the map first
# downloadCMBMap(foreground = "smica", nside = 1024)
# df <- CMBDataFrame("CMB_map_smica1024.fits")
# cmbdf <- sampleCMB(df, sample.size = 10000)
# win1 <- CMBWindow(theta = c(0,pi/2,pi/2), phi = c(0,0,pi/2))
# entropyCMB(cmbdf, win1)

}
\references{
\link{entropy}
}
