% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Statistics.R
\name{fRen}
\alias{fRen}
\title{Sample Renyi function}
\usage{
fRen(
  cmbdf,
  q.min = 1.01,
  q.max = 10,
  N = 20,
  k.box = log2(nside(cmbdf)) - 3,
  intensities = "I"
)
}
\arguments{
\item{cmbdf}{A \code{\link{CMBDataFrame}}.}

\item{q.min}{Left endpoint of the interval to compute the Renyi function. The default
value is 1.01,}

\item{q.max}{Right endpoint of the interval to compute the Renyi function. The default
value is 10}

\item{N}{Number of points to compute the Renyi function. The default value is 20.}

\item{k.box}{A  dyadic decomposition level in computing the Renyi function,
see the references in Details. The default value is \eqn{log2(nside(cmbdf)) - 3}}

\item{intensities}{A CMBDataFrame column with measured values}
}
\value{
Data frame which first column is the sampling grid
\eqn{seq(q.min, q.max, length.out = N)} of \eqn{q} values. Another column
consists of values of the sample Renyi function \eqn{T(q)} computed
on the grid using the  \eqn{k.box}th level dyadic decomposition
of the unit ball.
}
\description{
This function computes values of the sample Renyi function. Returns
the estimated values of \eqn{T(q)}  for \eqn{q} taking values on a grid.
For large data sets could be rather time consuming.
}
\examples{

## Download the map first
# downloadCMBMap(foreground = "smica", nside = 1024)
#
# cmbdf <- CMBDataFrame("CMB_map_smica1024.fits")
# win <- CMBWindow(theta = c(pi/4,pi/2,pi/2), phi = c(0,0,pi/2))
# cmbdf<- window(cmbdf, new.window = win)
# Tq <- fRen(cmbdf)
#
# plot(Tq[,1], Tq[,2], ylab =expression(D[q]), xlab = "q",
# main = "Sample Renyi function", pch = 20, col = "blue")


}
\references{
(1) Leonenko, N., and Shieh, N. 2013. Rényi function for multifractal
random fields. Fractals 21, Article No. 1350009.

(2) http://mathworld.wolfram.com/RenyiEntropy.html
}
