% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network.R
\name{as_network}
\alias{as_network}
\title{Create a network from a collection of line strings.}
\usage{
as_network(edges, flatten = TRUE, clean = TRUE)
}
\arguments{
\item{edges}{A data frame with the network edges}

\item{flatten}{Whether all intersections between edges should be
converted to nodes}

\item{clean}{Whether general cleaning tasks should be run on the generated
network (see \code{\link[=clean_network]{clean_network()}} for the description of tasks)}
}
\value{
A spatial network object
}
\description{
Create a network from a collection of line strings.
}
\examples{
edges <- sf::st_sfc(
  sf::st_linestring(matrix(c(0, 0, 1, 1), ncol = 2, byrow = TRUE)),
  sf::st_linestring(matrix(c(0, 1, 1, 0), ncol = 2, byrow = TRUE))
)
sf::st_crs(edges) <- sf::st_crs("EPSG:4326")
as_network(edges)
}
