% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cr_abstract.R
\name{cr_abstract}
\alias{cr_abstract}
\title{Get abstract}
\usage{
cr_abstract(doi, ...)
}
\arguments{
\item{doi}{(character) a DOI, required.}

\item{...}{Named parameters passed on to \code{\link[crul]{HttpClient}}}
}
\description{
Get abstract
}
\examples{
\dontrun{
# abstract found
cr_abstract(doi = '10.1109/TASC.2010.2088091')

# doi not found
# cr_abstract(doi = '10.5284/1011335')

# abstract not found, throws warning
# cr_abstract(doi = '10.1126/science.169.3946.635')
# cr_abstract(doi = '10.1371/journal.pone.0033693')
# cr_abstract(doi = '10.1007/12080.1874-1746')

# cr_abstract(cr_r(1))

# loop through many DOIs, allowing for failures
dois <- cr_r(10, filter = c(has_abstract = TRUE))
res <- lapply(dois, function(z) tryCatch(cr_abstract(z), error = function(e) e))
}
}
