% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docDscr_variables.R
\name{ddi_controlledVocabUsed}
\alias{ddi_controlledVocabUsed}
\alias{ddi_codeListAgencyName}
\alias{ddi_codeListID}
\alias{ddi_codeListName}
\alias{ddi_codeListSchemeURN}
\alias{ddi_codeListURN}
\alias{ddi_codeListVersionID}
\title{controlledVocabUsed and its child nodes}
\usage{
ddi_controlledVocabUsed(...)

ddi_codeListAgencyName(...)

ddi_codeListID(...)

ddi_codeListName(...)

ddi_codeListSchemeURN(...)

ddi_codeListURN(...)

ddi_codeListVersionID(...)
}
\arguments{
\item{...}{Child nodes or attributes.}
}
\value{
A ddi_node object.
}
\description{
Provides a code value, as well as a reference to the code list from which
the value is taken. Note that the CodeValue can be restricted to reference
an enumeration. More information on this element, especially the allowed
attributes, can be found in the references.
}
\details{
\emph{Parent node}

\code{controlledVocabUsed} is contained in \code{docDscr}.

\emph{controlledVocabUsed specific child nodes}
\itemize{
\item \code{ddi_codeListAgencyName()} is the agency maintaining the code list.
\item \code{ddi_codeListID()} identifies the code list that the value is taken from.
\item \code{ddi_codeListName()} identifies the code list that the value is taken from
with a human-readable name.
\item \code{ddi_codeListSchemeURN()} identifies the code list scheme using a URN.
\item \code{ddi_codeListURN()} identifies the code list that the vlaue is taken from
with a URN.
\item \code{ddi_codeListVersionID()} is the version of the code list. (Default value
is 1.0).
}
}
\section{Shared and complex child nodes}{

\itemize{
\item \code{\link[=ddi_usage]{ddi_usage()}}
}
}

\examples{
ddi_controlledVocabUsed(ddi_codeListID("TimeMethod"),
                        ddi_codeListName("Time Method"), 
                        ddi_codeListAgencyName("DDI Alliance"),
                        ddi_codeListVersionID("1.2"),
                        ddi_codeListURN("urn:ddi-cv:TimeMethod:1.2"),
                        ddi_codeListSchemeURN("
                               http://www.ddialliance.org/Specification/
                               DDI-CV/TimeMethod_1.2_Genericode1.0_DDI-CVProfile1.0.xml"),
                        ddi_usage())

}
\references{
\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/controlledVocabUsed.html}{controlledVocabUsed documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/codeListAgencyName.html}{codeListAgencyName documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/codeListID.html}{codeListID documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/codeListName.html}{codeListName documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/codeListSchemeURN.html}{codeListSchemeURN documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/codeListURN.html}{codeListURN documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/codeListVersionID.html}{codeListVersionID documentation}
}
