## ------------------------------------------------------------------------
library(rddtools)

## ------------------------------------------------------------------------
data("indh")

## ------------------------------------------------------------------------
str(indh)

## ------------------------------------------------------------------------
rdd_dat_indh <- rdd_data(y=choice_pg,
                         x=poverty,
                         data=indh,
                         cutpoint=30 )

## ------------------------------------------------------------------------
str(rdd_dat_indh)

## ------------------------------------------------------------------------
summary(rdd_dat_indh)

## ------------------------------------------------------------------------
plot(rdd_dat_indh[1:715,])

## ------------------------------------------------------------------------
(reg_para <- rdd_reg_lm(rdd_dat_indh, order=4))

## ------------------------------------------------------------------------
plot(reg_para)

## ------------------------------------------------------------------------
bw_ik <- rdd_bw_ik(rdd_dat_indh)
(reg_nonpara <- rdd_reg_np(rdd_object=rdd_dat_indh, bw=bw_ik))

## ------------------------------------------------------------------------
plot(reg_nonpara)

## ------------------------------------------------------------------------
plotSensi(reg_nonpara, from=0.05, to=1, by=0.1)

