% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSensi.R
\name{plotSensi}
\alias{plotSensi}
\alias{plotSensi.rdd_reg_np}
\alias{plotSensi.rdd_reg_lm}
\title{Plot the sensitivity to the bandwidth}
\usage{
plotSensi(
  rdd_regobject,
  from,
  to,
  by = 0.01,
  level = 0.95,
  output = c("data", "ggplot"),
  plot = TRUE,
  ...
)

\method{plotSensi}{rdd_reg_np}(
  rdd_regobject,
  from,
  to,
  by = 0.05,
  level = 0.95,
  output = c("data", "ggplot"),
  plot = TRUE,
  device = c("ggplot", "base"),
  vcov. = NULL,
  ...
)

\method{plotSensi}{rdd_reg_lm}(
  rdd_regobject,
  from,
  to,
  by = 0.05,
  level = 0.95,
  output = c("data", "ggplot"),
  plot = TRUE,
  order,
  type = c("colour", "facet"),
  ...
)
}
\arguments{
\item{rdd_regobject}{object of a RDD regression, from either \code{\link{rdd_reg_lm}} or \code{\link{rdd_reg_np}}}

\item{from}{First bandwidth point. Default value is max(1e-3, bw-0.1)}

\item{to}{Last bandwidth point. Default value is bw+0.1}

\item{by}{Increments in the \code{from} \code{to} sequence}

\item{level}{Level of the confidence interval}

\item{output}{Whether to return (invisibly) the data frame containing the bandwidths and corresponding estimates, or the ggplot object}

\item{plot}{Whether to actually plot the data.}

\item{device}{Whether to draw a base or a ggplot graph.}

\item{vcov.}{Specific covariance function to pass to coeftest. See help of package \code{\link[sandwich]{sandwich}}}

\item{order}{For parametric models (from \code{\link{rdd_reg_lm}}), the order of the polynomial.}

\item{type}{For parametric models (from \code{\link{rdd_reg_lm}}) whether different orders are represented as different colour or as different facets.}

\item{\ldots}{Further arguments passed to specific methods}
}
\value{
A data frame containing the bandwidths and corresponding estimates and confidence intervals.
}
\description{
Draw a plot showing the LATE estimates depending on multiple bandwidths
}
\examples{
data(house)
house_rdd <- rdd_data(y=house$y, x=house$x, cutpoint=0)

#Non-parametric estimate 
bw_ik <- rdd_bw_ik(house_rdd)
reg_nonpara <- rdd_reg_np(rdd_object=house_rdd, bw=bw_ik)
plotSensi(reg_nonpara)
plotSensi(reg_nonpara, device='base')

#Parametric estimate:
reg_para_ik <- rdd_reg_lm(rdd_object=house_rdd, order=4, bw=bw_ik)
plotSensi(reg_para_ik)
plotSensi(reg_para_ik, type='facet')
}
\author{
Matthieu Stigler <\email{Matthieu.Stigler@gmail.com}>
}
