% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metacommunity.R
\name{metacommunity}
\alias{metacommunity}
\alias{metacommunity,data.frame,missing-method}
\alias{metacommunity,data.frame-method}
\alias{metacommunity,numeric,missing-method}
\alias{metacommunity,numeric-method}
\alias{metacommunity,matrix,missing-method}
\alias{metacommunity,matrix-method}
\alias{metacommunity,data.frame,matrix-method}
\alias{metacommunity,data.frame-method,matrix-method}
\alias{metacommunity,numeric,matrix-method}
\alias{metacommunity,numeric-method,matrix-method}
\alias{metacommunity,matrix,matrix-method}
\alias{metacommunity,missing,similarity-method}
\alias{metacommunity,similarity-method}
\alias{metacommunity,numeric,similarity-method}
\alias{metacommunity,data.frame,similarity-method}
\alias{metacommunity,matrix,similarity-method}
\alias{metacommunity,ANY,phylo-method}
\title{Metacommunity}
\usage{
metacommunity(partition, similarity)

\S4method{metacommunity}{data.frame,missing}(partition)

\S4method{metacommunity}{numeric,missing}(partition)

\S4method{metacommunity}{matrix,missing}(partition)

\S4method{metacommunity}{data.frame,matrix}(partition, similarity)

\S4method{metacommunity}{numeric,matrix}(partition, similarity)

\S4method{metacommunity}{matrix,matrix}(partition, similarity)

\S4method{metacommunity}{missing,similarity}(partition, similarity)

\S4method{metacommunity}{numeric,similarity}(partition, similarity)

\S4method{metacommunity}{data.frame,similarity}(partition, similarity)

\S4method{metacommunity}{matrix,similarity}(partition, similarity)

\S4method{metacommunity}{ANY,phylo}(partition, similarity)
}
\arguments{
\item{partition}{two-dimensional \code{matrix} of mode \code{numeric}
with rows as types, columns as subcommunities, and elements containing
the relative abundances of types in subcommunities. For phylogenetic
diversity, see \emph{Details}}

\item{similarity}{(optional) object of class \code{similarity}}
}
\value{
\code{metacommunity()} returns an object of class
\code{metacommunity} (see \emph{Fields}).
}
\description{
Functions to generate a \code{metacommunity} object.
}
\section{Fields}{

\describe{
\item{\code{type_abundance}}{two-dimensional \code{matrix} of mode \code{numeric}
with rows as types (species), columns as subcommunities, and each
element containing the relative abundance of types in each subcommunity
relative to the metacommunity as a whole. In the phylogenetic case, this
corresponds to the proportional abundance of historical species, which is
calculated from the proportional abundance of terminal taxa}

\item{\code{similarity}}{two-dimensional \code{matrix} of mode \code{numeric} with
rows as types, columns as types, and elements containing pairwise
similarities between types}

\item{\code{similarity_components}}{list containing the components necessary to
calculate similarity. This list is empty when \code{precompute_dist = TRUE}
when calculating distance. When a pairwise distance matrix is too large and
\code{precompute_dist = FALSE}, this list contains all the information
required to calculate pairwise distance between types}

\item{\code{similarity_parameters}}{list containing parameters associated with
converting pairwise distances to similarities (the \code{dist2sim()}
arguments)}

\item{\code{ordinariness}}{two-dimensional \code{matrix} of mode \code{numeric}
with rows as types, columns as subcommunities, and elements containing the
ordinariness of types within subcommunities}

\item{\code{subcommunity_weights}}{\code{vector} of mode \code{numeric} containing
subcommunity weights}

\item{\code{type_weights}}{two-dimensional \code{matrix} of mode \code{numeric},
with rows as types, columns as subcommunities, and elements containing
weights of types within a subcommunity}

\item{\code{dat_ID}}{object of class \code{character} denoting the type of diversity
being calculated. This can be "naive", "genetic", "taxonomic", and so on}

\item{\code{raw_abundance}}{[Phylogenetic] two-dimensional \code{matrix} of mode
\code{numeric} with rows as types, columns as subcommunities, and elements
containing the relative abundance of present day species}

\item{\code{raw_structure}}{[Phylogenetic] two-dimensional \code{matrix} of mode
\code{numeric} with rows as historical species, columns as present day
species, and elements containing historical species lengths within lineages}

\item{\code{parameters}}{[Phylogenetic] \code{data.frame} containing parameters
associated with each historic species in the phylogeny}
}}

\examples{
# Naive-type
partition <- cbind(a = c(1,1,1,0,0), b = c(0,1,0,1,1))
row.names(partition) <- paste0("sp", 1:5)
partition <- partition / sum(partition)
meta <- metacommunity(partition)

}
\seealso{
\code{\link{metacommunity-class}}
}
