% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dr_listsets.r
\name{dr_list_sets}
\alias{dr_list_sets}
\title{List the sets in the Dryad metadata repository.}
\usage{
dr_list_sets(token = NULL, as = "df", ...)
}
\arguments{
\item{token}{(character) a token previously provided by the server to resume a
request where it last left off. 50 is max number of records returned. We will
loop for you internally to get all the records you asked for.}

\item{as}{(character) What to return. One of "df" (for data.frame; default),
"list", or "raw" (raw text)}

\item{...}{Curl debugging options passed on to \code{\link[httr]{GET}}}
}
\description{
Retrieve the set structure of Dryad, useful for selective harvesting
}
\examples{
\dontrun{
dr_list_sets()
dr_list_sets(as = "list")
dr_list_sets(as = "raw")
library('httr')
res <- dr_list_sets(config = verbose())
}
}

