% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dryad_fetch.R
\name{dryad_fetch}
\alias{dryad_fetch}
\title{Download Dryad files}
\usage{
dryad_fetch(url, destfile = NULL, try_file_names = FALSE, ...)
}
\arguments{
\item{url}{(character) One or more Dryad URL for a dataset}

\item{destfile}{(character) Destination file. If not given, we assign a
file name based on URL provided.}

\item{try_file_names}{(logical) try to parse file names out of the
URLs. Default: \code{FALSE}}

\item{...}{Further args passed on to \code{\link[curl:curl_download]{curl::curl_download()}}}
}
\value{
named (list) with path(s) to the file(s) - list names
are the urls passed into the \code{url} parameter
}
\description{
Download Dryad files
}
\details{
This function is a thin wrapper around \code{\link[curl:curl_download]{curl::curl_download()}} to
get files to your machine only. We don't attempt to read/parse them
}
\examples{
\dontrun{
# Single file
x <- dryad_files('10.5061/dryad.1758')

## without specifying a destination file
dryad_fetch(url = x)

## specify a destination file
dryad_fetch(url = x[1], (f <- tempfile(fileext = ".csv")))

## use try_file_names - we try to extract file names from URLs
dryad_fetch(url = x, try_file_names = TRUE)

# Many files
x <- dryad_files(doi = '10.5061/dryad.60699')
res <- dryad_fetch(x)
head(read.delim(res[[1]], sep = ";"))
}
}
