% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projectRasterDWD.R
\name{projectRasterDWD}
\alias{projectRasterDWD}
\title{project DWD raster data}
\usage{
projectRasterDWD(
  r,
  proj = "radolan",
  extent = "radolan",
  targetproj = "ll",
  quiet = rdwdquiet()
)
}
\arguments{
\item{r}{Raster object}

\item{proj}{Current projection to be given to \code{r}. Can be\cr
- a \code{\link[raster:projection]{raster::crs()}} input (e.g. a projection character string),\cr
- NULL to not set proj+extent (but still consider \code{targetproj}),\cr
- or a special charstring for internal defaults, namely:
"radolan" (readDWD.binary + .asc + .radar), "seasonal" (.raster) or "nc"  (.nc).\cr
DEFAULT: "radolan"}

\item{extent}{Current \code{\link[raster:extent]{raster::extent()}} to be given to \code{r}.
Ignored if \code{proj=NULL}. Can be an extent object,
a vector with 4 numbers, or "radolan" / "rw" / "seasonal" / "nc" with internal defaults.
DEFAULT: "radolan"}

\item{targetproj}{\code{r} is reprojected to this \code{\link[raster:projection]{raster::crs()}}.
Use NULL to not reproject (i.e. only set proj and extent).
DEFAULT: "ll" with internal default for lat-lon.}

\item{quiet}{Logical: suppress progress messages? DEFAULT: FALSE through \code{\link[=rdwdquiet]{rdwdquiet()}}}
}
\value{
Raster object with projection and extent, invisible
}
\description{
Set projection and extent for DWD raster data. Optionally (and
per default) also reprojects to latlon data.\cr\cr
\strong{WARNING:} reprojection to latlon changes values slightly. For the
tested RX product, this change is significant, see:
\url{https://github.com/brry/rdwd/blob/master/misc/ExampleTests/Radartests.pdf}\cr
In raster::plot, \strong{use zlim with the original range} if needed.
}
\details{
The internal defaults are extracted from the Kompositformatbeschreibung at
\url{https://www.dwd.de/DE/leistungen/radolan/radolan.html}, as provided
2019-04 by Antonia Hengst.\cr The nc extent was obtained by projecting
Germanys bbox to EPSG 3034 (specified in the DWD documentation). Using that
as a starting point, I then refined the extent to a visual match, see
\href{https://github.com/brry/rdwd/blob/master/misc/developmentNotes.R}{developmentNotes.R}\cr\cr
}
\examples{
# To be used after readDWD.binary etc
}
\seealso{
\verb{raster::}\code{\link[raster:projection]{crs}} / \code{\link[raster:extent]{extent}} /
\code{\link[raster:projectRaster]{projectRaster}}\cr
\code{readDWD.}\code{\link[=readDWD.binary]{binary}} / \code{\link[=readDWD.raster]{raster}} /
\code{\link[=readDWD.asc]{asc}} / \code{\link[=readDWD.radar]{radar}} / \code{\link[=readDWD.nc]{nc}}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, May 2019
}
\keyword{aplot}
