% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.Recur}
\alias{plot.Recur}
\title{Produce Event Plot or Mean Cumulative Function Plot}
\usage{
\method{plot}{Recur}(
  x,
  mcf = FALSE,
  event.result = c("increasing", "decreasing", "asis"),
  event.calendarTime = FALSE,
  mcf.adjustRiskset = TRUE,
  mcf.conf.int = FALSE,
  control = list(),
  ...
)
}
\arguments{
\item{x}{an object of class \code{Recur} returned by the \code{Recur()} function.
See \code{?Recur} for creating \code{Recur} objects.}

\item{mcf}{an optional logical value indicating whether the mean cumulative function (MCF) will
be plotted instead of the event plot. When \code{mcf = TRUE},
the \code{mcf} is internally called. See \code{\link{mcf}} for details.}

\item{event.result}{an optional character string that is passed to the
\code{plotEvents()} function as the \code{result} argument. See \code{\link{plotEvents}}.
This argument is used to specify whether the event plot is sorted by the subjects' terminal time.
The available options are
\describe{
  \item{\code{increasing}}{sort the terminal time from in ascending order (default).
This places longer terminal times on top. }
  \item{\code{decreasing}}{sort the terminal time from in descending order.
This places shorter terminal times on top. }
  \item{\code{none}}{present the event plots as is, without sorting by the terminal times.}
}}

\item{event.calendarTime}{an optional logical value indicating whether to plot in calendar time.
When \code{event.calendarTime = FALSE} (default),
the event plot will have patient time on the x-axis.}

\item{mcf.adjustRiskset}{an optional logical value that is passed to
the \code{mcf()} function as the \code{adjustRiskset} argument. 
This argument indicates whether risk set size will be adjusted.
If \code{mcf.adjustRiskset = TRUE}, subjects leave the risk set after terminal times
as in the Nelson-Aalen estimator.
If \code{mcf.adjustRiskset = FALSE}, subjects remain in the risk set after terminal time.}

\item{mcf.conf.int}{an optional logical value that is passed to
the \code{mcf()} function as the \code{conf.int} argument. See \code{\link{mcf}} for details.}

\item{control}{a list of control parameters. See \bold{Details}.}

\item{...}{additional graphical parameters to be passed to methods.}
}
\value{
A \code{ggplot} object.
}
\description{
Plot the event plot or the mean cumulative function (MCF) from an \code{Recur} object.
}
\details{
The argument \code{control} consists of options with argument defaults to a list with
the following values:
\describe{
  \item{xlab}{customizable x-label, default value is "Time".}
  \item{ylab}{customizable y-label, default value is "Subject" for event plot and
"Cumulative mean" for MCF plot.}
  \item{main}{customizable title, the default value is "Recurrent event plot"
when \code{mcf = FALSE} and
"Sample cumulative mean function plot" when \code{mcf = TRUE}.}
  \item{terminal.name}{customizable label for terminal event,
the default value is "Terminal event".}
  \item{recurrent.name}{customizable legend title for recurrent event,
the default value is "Recurrent events".}
  \item{recurrent.types}{customizable label for recurrent event type,
the default value is \code{NULL}.}
  \item{alpha}{between 0 and 1, controls the transparency of points.}
}
The \code{xlab}, \code{ylab} and \code{main} parameters can be specified
outside of the \code{control} list.
}
\examples{
data(simDat)
reObj <- with(simDat, Recur(t.start \%to\% t.stop, id, event, status))

## Event plots:
plot(reObj)
plot(reObj, event.result = "decreasing")

## With (hypothetical) multiple event types
simDat$event2 <- with(simDat, ifelse(t.stop > 10 & event > 0, 2, event))
reObj2 <- with(simDat, Recur(t.start \%to\% t.stop, id, event2, status))
plot(reObj2)

## With (hypothetical) calendar times
simDat2 <- simDat
simDat2$t.start <- as.Date(simDat2$t.start + simDat2$x2 * 5, origin = "20-01-01")
simDat2$t.stop <- as.Date(simDat2$t.stop + simDat2$x2 * 5, origin = "20-01-01")
reObj3 <- with(simDat2, Recur(t.start \%to\% t.stop, id, event, status))
plot(reObj3, event.calendarTime = TRUE)

## MCF plots
plot(reObj, mcf = TRUE)
plot(reObj, mcf = TRUE, mcf.adjustRiskset = FALSE)



library(reReg)
data(simDat)
reObj <- with(simDat, Recur(t.start \%to\% t.stop, id, event, status))
summary(reObj)
}
\references{
Nelson, W. B. (1995) Confidence Limits for Recurrence Data-Applied to Cost
or Number of Product Repairs. \emph{Technometrics}, \bold{37}(2): 147--157.
}
\seealso{
\code{\link{Recur}}, \code{\link{plotEvents}}, \code{\link{mcf}}
}
\keyword{Plots}
