% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/columns.R
\name{colDef}
\alias{colDef}
\title{Column definitions}
\usage{
colDef(name = NULL, aggregate = NULL, sortable = NULL,
  resizable = NULL, filterable = NULL, show = TRUE,
  defaultSortOrder = NULL, sortNALast = FALSE, format = NULL,
  cell = NULL, aggregated = NULL, header = NULL, footer = NULL,
  details = NULL, html = FALSE, na = "", minWidth = NULL,
  maxWidth = NULL, width = NULL, align = NULL, class = NULL,
  style = NULL, headerClass = NULL, headerStyle = NULL,
  footerClass = NULL, footerStyle = NULL)
}
\arguments{
\item{name}{Column header name.}

\item{aggregate}{Aggregate function. The name of a built-in aggregate
function or a custom \code{\link[=JS]{JS()}} aggregate function. Built-in aggregate functions
are: \code{"mean"}, \code{"sum"}, \code{"max"}, \code{"min"}, \code{"count"}, \code{"unique"}, \code{"frequency"}.}

\item{sortable}{Enable sorting? Overrides the table option.}

\item{resizable}{Enable column resizing? Overrides the table option.}

\item{filterable}{Enable column filtering? Overrides the table option.}

\item{show}{Show the column? Defaults to \code{TRUE}.}

\item{defaultSortOrder}{Default sort order. Either \code{"asc"} for ascending
order or \code{"desc"} for descending order. Overrides the table option.}

\item{sortNALast}{Always sort missing values (\link{NA} or \link{NaN}) last?}

\item{format}{Column formatting options. A \code{\link[=colFormat]{colFormat()}} object to
format all cells, or a named list of \code{\link[=colFormat]{colFormat()}} objects to format standard
cells (\code{"cell"}) and aggregated cells (\code{"aggregated"}) separately.}

\item{cell}{Custom cell renderer. An R function that takes the cell value,
row index, and column name as arguments, or a \code{\link[=JS]{JS()}} function that takes a
cell info object as an argument.}

\item{aggregated}{Custom aggregated cell renderer. A \code{\link[=JS]{JS()}} function that takes
a cell info object as an argument.}

\item{header}{Custom header renderer. An R function that takes the header value
and column name as arguments, or a \code{\link[=JS]{JS()}} function that takes a column info
object as an argument.}

\item{footer}{Footer content or render function. Render functions can be an
R function that takes two arguments, the column values and column name, or a
\code{\link[=JS]{JS()}} function that takes a column info object as an argument.}

\item{details}{Additional content to display when expanding a row. An R function
that takes a row index argument or a \code{\link[=JS]{JS()}} function that takes a row info object
as an argument. Cannot be used on a grouping column.}

\item{html}{Render cells as HTML? HTML strings are escaped by default.}

\item{na}{String to display for missing values (i.e. \link{NA} or \link{NaN}).
By default, missing values are displayed as blank cells.}

\item{minWidth}{Min width of the column in pixels.}

\item{maxWidth}{Max width of the column in pixels.}

\item{width}{Fixed width of the column in pixels. Overrides minWidth and maxWidth.}

\item{align}{Column alignment. One of \code{"left"}, \code{"right"}, \code{"center"}.}

\item{class}{Additional CSS classes to apply to cells. Can also be an R function
that takes the cell value, row index, and column name as arguments, or a \code{\link[=JS]{JS()}}
function that takes a row info object, column info object, and table state
object as arguments.

Note that R functions cannot apply classes to aggregated cells.}

\item{style}{Inline styles to apply to cells. A named list or character string.
Can also be an R function that takes the cell value and row index as arguments,
or a \code{\link[=JS]{JS()}} function that takes a row info object, column info object, and
table state object as arguments.

Note that R functions cannot apply styles to aggregated cells.
If \code{style} is a named list, property names should be camelCased.}

\item{headerClass}{Additional CSS classes to apply to the header.}

\item{headerStyle}{Inline styles to apply to the header. A named list or
character string.

Note that if \code{headerStyle} is a named list, property names should be camelCased.}

\item{footerClass}{Additional CSS classes to apply to the footer.}

\item{footerStyle}{Inline styles to apply to the footer. A named list or
character string.

Note that if \code{footerStyle} is a named list, property names should be camelCased.}
}
\value{
A column definition object that can be used to customize columns
in \code{reactable()}.
}
\description{
Column definitions
}
\examples{
reactable(
  iris,
  columns = list(
    Sepal.Length = colDef(name = "Sepal Length"),
    Sepal.Width = colDef(filterable = TRUE),
    Petal.Length = colDef(show = FALSE),
    Petal.Width = colDef(defaultSortOrder = "desc")
  )
)

}
