% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icon_sets.R
\name{icon_sets}
\alias{icon_sets}
\title{Add colored icons to rows in a column}
\usage{
icon_sets(
  data,
  icons = c("circle", "circle", "circle"),
  colors = c("red", "orange", "green"),
  percent = NULL
)
}
\arguments{
\item{data}{Dataset containing at least one numeric column.}

\item{icons}{A vector of three icons from the Font Awesome library (via shiny).
Icons should be given in order from low values to high values.
Default icons are circles.}

\item{colors}{A vector of three colors to color the icons.
Colors should be given in order from low values to high values.
Default colors provided are c('red','orange','green').
Can use R's built-in colors or other color packages.}

\item{percent}{Optionally format numbers as percentages.}
}
\value{
a function that applies an icon
    to a column of numeric values.
}
\description{
The `icon_sets()` function conditionally adds an icon from the Font Awesome library (via shiny) to each row of a column and assigns a color depending on their value in relation to other values in that particular column.
    It should be placed within the cell argument in reactable::colDef.
}
\examples{
data <- MASS::Cars93[20:49, c("Make", "MPG.city", "MPG.highway")]

## By default, icon_sets() assigns red circles to the lowest-third values,
## orange circles to the middle-third values,
## and green to the top-third values
reactable(data,
defaultColDef = colDef(cell = icon_sets(data)))

## Assign custom colors
reactable(data,
defaultColDef = colDef(cell = icon_sets(data,
colors = c("tomato", "grey", "dodgerblue"))))

## Assign icons from Font Awesome's icon library
reactable(data,
defaultColDef = colDef(cell = icon_sets(data,
icons = c("arrow-down","minus","arrow-up"))))

}
