% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/readGenalex-Genepop.R
\name{writeGenepop}
\alias{writeGenepop}
\title{Write GenAlEx-format genotypes to a text file in Genepop format}
\usage{
writeGenepop(x, file, eol = "\\n", check.annotation = TRUE)
}
\arguments{
\item{x}{Annotated data frame of class \code{'genalex'}}

\item{file}{File name or connection for writing.  If given as \code{""},
\code{stdout()} is used.}

\item{eol}{End-of-line character used for output (defaults to \code{"\n"}).}

\item{check.annotation}{If \code{TRUE}, the annotations for the dataset
are checked using \code{"is.genalex(x, force = TRUE, skip.strings = TRUE)"}.
If that returns \code{FALSE}, nothing is written and an error is generated.}
}
\value{
No value is returned.
}
\description{
Writes genotype data encoded in an annotated data frame of class
\code{'genalex'} to a Genepop-format text file.
included immediately to the right of genotype columns.  Genepop
and its documentation are available at
\url{http://kimura.univ-montp2.fr/~rousset/} and
\url{http://kimura.univ-montp2.fr/~rousset/Genepop.pdf}.
}
\details{
Although the GenAlEx and Genepop formats encode nearly the same data,
there are flexibilities and limitations on both sides.  For example,
Genepop allows for a maximum of 3 digits to encode each allele, and
only haploid or diploid data, while allowing for some mixing of
diploid and haploid encodings.  GenAlEx allows for more digits per
allele and higher ploidy, although numeric data is still required,
and only allows for a single ploidy per data file.  Perhaps future
extensions to this function will allow for additional haploid data
to be written.

An attempt is made to produce output with useful whitespace.  The
locus names and each set of individual genotypes are aligned at a
column determined by the longest sample name.

GenAlEx format components that are attributes of class \code{'genalex'}
are translated to components in the Genepop file as so:

\enumerate{
   \item The dataset title from the \code{"dataset.title"} attribute is
         written as the first line
   \item The locus names from the \code{"locus.names"} attribute are
         written comma-separated as the second line
   \item For each population listed in the \code{"pop.labels"} attribute,
         a single line containing \code{Pop popname} is written
   \item For each sample from a population, the sample identifier is
         written, then a space, comma and space, then the individual
         genotypes encoded as two or three digits per allele.  Alleles
         for each locus are concatenated, and successive loci are
         separated by a single space.
   \item Populations are written in the order in which they appear in
         the \code{"pop.labels"} attribute
   \item Missing alleles are coded as zeroes \code{"00"} or \code{"000"}
   \item The same number of digits are used for encoding each allele of
         all loci
   \item For Genepop ploidy is indicated by the number of digits used for
         encoding each locus.  Two or three digits for the entire locus
         indicates haploidy, while four or six digits indicates diploidy
         with each allele using two or three digits, respectively.
   \item For Genepop there is no provision for encoding additional
         non-genetic data
}
}
\examples{
data(Qagr_pericarp_genotypes)
# lots of output to terminal
dd <- as.genalex(head(Qagr_pericarp_genotypes, 40), force = TRUE)
writeGenepop(dd, file = "")
}
\author{
Douglas G. Scofield
}
\references{
Rousset, F. (2008)  GENEPOP '007: a complete reimplementation
of the GENEPOP software for Windows and Linux.
\emph{Molecular Ecology Resources} 8, 103-106.
\url{http://onlinelibrary.wiley.com/doi/10.1111/j.1471-8286.2007.01931.x/abstract}.
}
\seealso{
\code{\link{writeGenalex}}
}
\keyword{attribute}
\keyword{file}
\keyword{manip}

