% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_dhis2-helpers.R
\name{get_program_stages}
\alias{get_program_stages}
\title{Get program stages for one or more DHSI2 programs}
\usage{
get_program_stages(login, programs = NULL, program = NULL)
}
\arguments{
\item{login}{A httr2_response object returned by the \code{dhis2_login()} function}

\item{programs}{A data frame with the program IDs and names obtained from the
\code{get_programs()} function}

\item{program}{A character with the program ID or name}
}
\value{
A data frame with the following columns:
\enumerate{
\item \code{program_id}: the unique ID of the program
\item \code{program_name}: the displayed name of the program
\item \code{program_stage_name}: the name of each stage associate with the program
\item \code{program_stage_id}: the ID of each program stage
}
}
\description{
Retrieves the stages associated with specified DHIS2 program IDs, or all
programs if none are specified. If any of the supplied program names or IDs
are not found, the function displays a message and proceeds with
the valid ones.
}
\examples{
\dontrun{
  # establish the connection to the DHIS2 instance
  dhis2_login <- login(
    type = "dhis2",
    from = "https://smc.moh.gm/dhis",
    user_name = "test",
    password = "Gambia@123"
  )

  # get the list of all program stages from the DHIS2 instance
  all_program_stages <- get_program_stages(
    login = dhis2_login,
    program = "E5IUQuHg3Mg",
    programs = NULL
  )
}
}
