% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/read_table.R
\name{read_table}
\alias{read_table}
\title{Read text file where columns are separated by whitespace.}
\usage{
read_table(file, col_names = TRUE, col_types = NULL, na = "NA",
  skip = 0, n_max = -1)
}
\arguments{
\item{file}{Either a path to a file, a connection, or literal data
   (either a single string or a raw vector).

   Files ending in \code{.gz}, \code{.bz2}, \code{.xz}, or \code{.zip} will
   be automatically uncompressed. Files starting with \code{http://},
   \code{https://}, \code{ftp://}, or \code{ftps://} will be automatically
   downloaded.

   Literal data is most useful for examples and tests. It must contain at
   least one new line to be recognised as data (instead of a path).}

\item{col_names}{Either \code{TRUE}, \code{FALSE} or a character vector
  of column names.

  If \code{TRUE}, the first row of the input will be used as the column
  names, and will not be included in the data frame. If \code{FALSE}, column
  names will be generated automatically: X1, X2, X3 etc.

  If \code{col_names} is a character vector, the values will be used as the
  names of the columns, and the first row of the input will be read into
  the first row of the output data frame.}

\item{col_types}{One of \code{NULL}, a list, a named list or a string.

  If \code{NULL}, the column type will be imputed from the first 30 rows
  on the input. This is convenient (and fast), but not robust. If the
  imputation fails, you'll need to supply the correct types yourself.

  If a list, it must contain one "\code{\link{collector}}" for each column.
  If you only want to read a subset of the columns, you can use a named list
  (where the names give the column names). If a column is not mentioned by
  name, it will not be included in the output.

  Alternatively, you can use a compact string representation where each
  character represents one column: c = character, d = double, i = integer,
  l = logical and \code{_} skips the column.}

\item{na}{String to use for missing values.}

\item{skip}{Number of lines to skip before reading data.}

\item{n_max}{Maximum number of records to read.}
}
\description{
This is designed to read the type of textual data where each column is
separate by one (or more) columns of space. Each line is the same length,
and each field is in the same position in every line. It's similar to
\code{\link{read.table}}, but rather parsing like a file delimited by
arbitrary amounts of whitespace, it first finds empty columns and then
parses like a fixed width file.
}
\examples{
# One corner from http://www.masseyratings.com/cf/compare.htm
massey <- system.file("extdata/massey-rating.txt", package = "readr")
cat(read_file(massey))
read_table(massey)

# Sample of 1978 fuel economy data from
# http://www.fueleconomy.gov/feg/epadata/78data.zip
epa <- system.file("extdata/epa78.txt", package = "readr")
cat(read_file(epa))
read_table(epa, col_names = FALSE)
}
\seealso{
\code{\link{read_fwf}} to read fixed width files where each column
  is not separated by whitespace. \code{read_fwf} is also useful for reading
  tabular data with non-standard formatting.
}

