% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{basename_unique}
\alias{basename_unique}
\title{Return basenames that are unique}
\usage{
basename_unique(x, path_only = FALSE)
}
\arguments{
\item{x}{character vector; file paths}

\item{path_only}{logical; if \code{TRUE}, only return the unique part of the path}
}
\description{
Return basenames that are unique
}
\examples{
files <- c("../data/glob/subdir1/test.txt", "../data/glob/subdir2/test.txt")
readtext:::basename_unique(files)
# [1] "subdir1/test.txt" "subdir2/test.txt"
readtext:::basename_unique(files, path_only = TRUE)
# [1] "subdir1" "subdir2"
readtext:::basename_unique(c("../data/test1.txt", "../data/test2.txt"))
# [1] "test1.txt" "test2.txt"
}
\keyword{internal}
